"use strict";
Object.defineProperty(exports, "__esModule", {
    value: true
});
Object.defineProperty(exports, "useForwardConsoleLog", {
    enumerable: true,
    get: function() {
        return useForwardConsoleLog;
    }
});
const _react = require("react");
const _forwardlogs = require("../forward-logs");
const useForwardConsoleLog = (socketRef)=>{
    (0, _react.useEffect)(()=>{
        if (!_forwardlogs.isTerminalLoggingEnabled) {
            return;
        }
        const socket = socketRef.current;
        if (!socket) {
            return;
        }
        const onOpen = ()=>{
            _forwardlogs.logQueue.onSocketReady(socket);
        };
        socket.addEventListener('open', onOpen);
        return ()=>{
            socket.removeEventListener('open', onOpen);
        };
    }, [
        socketRef
    ]);
};

if ((typeof exports.default === 'function' || (typeof exports.default === 'object' && exports.default !== null)) && typeof exports.default.__esModule === 'undefined') {
  Object.defineProperty(exports.default, '__esModule', { value: true });
  Object.assign(exports.default, exports);
  module.exports = exports.default;
}

//# sourceMappingURL=use-forward-console-log.js.map