"use client";

import { useEffect } from "react";
import { useRouter, usePathname } from "next/navigation";
import { useAuth } from "@/context/AuthContext";
import { CircularLoader } from "@/app/components/common/AppLoader";


const publicRoutes = ["/login", "/login/forgotpassword", "/login/resetpassword"];

export default function ProtectedRoute({ children }: { children: React.ReactNode }) {
  const { user, loading } = useAuth();
  const router = useRouter();
  const pathname = usePathname();

  useEffect(() => {
    if (!loading && !user && !publicRoutes.includes(pathname)) {
      router.replace("/login");
    }
  }, [loading, user, pathname, router]);

  // While checking auth state, show loader
  if (loading) {
    return <CircularLoader />;
  }

  return <>{children}</>;
}
