// src/app/api/resetpassword/route.ts
import { NextRequest, NextResponse } from 'next/server';
import axios, { AxiosError } from 'axios';
import { API_BASE_PATH } from "@/config/apiConfig";
const API_BASE_URL = API_BASE_PATH;
export async function PUT(req: NextRequest) {
  try {
    const body = await req.json();
    const { token, password, confirm_password } = body;

    const formData = new URLSearchParams();
    formData.append('token', token);
    formData.append('password', password);
    formData.append('confirm_password', confirm_password);

    const response = await axios.put(`${API_BASE_URL}/user/changepassword`, formData, {
      headers: {
        Accept: 'application/json',
        'Content-Type': 'application/x-www-form-urlencoded',
      },
    });

    return NextResponse.json({ message: 'Password changed successfully' }, { status: 200 });
  } catch (error) {
    const axiosError = error as AxiosError<{ message: string }>;
    return NextResponse.json(
      { message: axiosError.response?.data?.message || 'Failed to change password' },
      { status: axiosError.response?.status || 500 }
    );
  }
}
