<!-- Sidebar -->
<div class="sidebar" id="sidebar">
    <div class="sidebar-inner slimscroll">
        <div id="sidebar-menu" class="sidebar-menu">
            <ul>
                <!-- Main Menu -->
                <li class="menu-title">
                    <span>Main</span>
                </li>
                <li class="<?php echo e(set_active(['home','em/dashboard'])); ?> submenu">
                    <a href="#">
                        <i class="la la-dashboard"></i>
                        <span>Dashboard</span> 
                        <span class="menu-arrow"></span>
                    </a>
                    <ul>
                    <?php if(Auth::user()->role_name == 'Admin'): ?>

                        <li><a class="<?php echo e(set_active(['home'])); ?>" href="<?php echo e(route('home')); ?>">Admin Dashboard</a></li>
                        <?php endif; ?>   

                        <?php if(Auth::user()->role_name == 'Normal User'): ?>

                        <li><a class="<?php echo e(set_active(['em/dashboard'])); ?>" href="<?php echo e(route('em/dashboard')); ?>">Employee Dashboard</a></li>
                        <?php endif; ?>   
                    </ul>
                </li>

                <?php if(Auth::user()->role_name == 'Admin'): ?>
                    <!-- Admin Authentication -->
                    <li class="menu-title"><span>Authentication</span></li>
                    <li class="<?php echo e(set_active(['userManagement', 'activity/log'])); ?> submenu">
                        <a href="#"><i class="la la-user-secret"></i> <span>User Controller</span> <span class="menu-arrow"></span></a>
                        <ul>
                            <li><a class="<?php echo e(set_active(['userManagement'])); ?>" href="<?php echo e(route('userManagement')); ?>">All Users</a></li>
                        </ul>
                    </li>

                    <!-- Admin Features -->
                    <li><a class="<?php echo e(set_active(['attendance/page'])); ?>" href="<?php echo e(route('attendance/page')); ?>"><i class="la la-calendar-check-o mr-3"></i> Attendance</a></li>
                    <li><a class="<?php echo e(set_active(['form/leaves/new'])); ?>" href="<?php echo e(route('form/leaves/new')); ?>"><i class="la la-calendar mr-3"></i> Leaves <span class="badge badge-pill bg-primary float-right">1</span></a></li>
                    <li class="<?php echo e(set_active(['roles/permissions/page'])); ?>"><a href="<?php echo e(route('roles/permissions/page')); ?>"><i class="la la-key"></i><span>Roles & Permissions</span></a></li>

                    <li><a class="<?php echo e(set_active(['form/departments/page'])); ?>" href="<?php echo e(route('form/departments/page')); ?>"><i class="la la-building mr-3"></i> Departments</a></li>
                    <li><a class="<?php echo e(set_active(['form/designations/page'])); ?>" href="<?php echo e(route('form/designations/page')); ?>"><i class="la la-sitemap mr-3"></i> Designations</a></li>
                    <li><a class="<?php echo e(set_active(['form/leavesettings/page'])); ?>" href="<?php echo e(route('form/leavesettings/page')); ?>"><i class="la la-cogs mr-3"></i> Leave Settings</a></li>
                    <li><a class="<?php echo e(set_active(['form/holidays/new'])); ?>" href="<?php echo e(route('form/holidays/new')); ?>"><i class="la la-plane mr-3"></i> Holidays</a></li>
                   
                    <li class="menu-title"><span>Project Management</span></li>

                    <li class="<?php echo e(set_active(['all/employee/list', 'form/leaves/employee/new'])); ?> submenu" slimscroll>
                        <a href="#"><i class="la la-user"></i> <span>Project Management</span> <span class="menu-arrow"></span></a>
                        <ul>
                            <li><a class="<?php echo e(set_active(['client'])); ?>" href="<?php echo e(route('client.index')); ?>">Clients</a></li>
                            <li><a class="<?php echo e(set_active(['projects'])); ?>" href="<?php echo e(route('projects.index')); ?>">Projects</a></li>
                            <li><a class="<?php echo e(set_active(['tasks'])); ?>" href="<?php echo e(route('task.index')); ?>">Tasks</a></li>
                            <li><a class="<?php echo e(set_active(['defects'])); ?>" href="<?php echo e(route('defects.index')); ?>">Defect Task</a></li>
                           
                        </ul>
                    </li>
                    <!-- Payroll -->
                    <li class="menu-title"><span>HR</span></li>
                    <li class="<?php echo e(set_active(['form/salary/page', 'form/payroll/items'])); ?> submenu">
                        <a href="#"><i class="la la-money"></i> <span>Payroll</span> <span class="menu-arrow"></span></a>
                        <ul>
                            <li><a class="<?php echo e(set_active(['form/salary/page'])); ?>" href="<?php echo e(route('form/salary/page')); ?>">Employee Salary</a></li>
                            <li><a class="<?php echo e(set_active(['form/payroll/items'])); ?>" href="<?php echo e(route('form/payroll/items')); ?>">Payroll Items</a></li>
                        </ul>
                    </li>

                    <!-- Reports -->
                    <li class="<?php echo e(set_active(['form/expense/reports/page', 'form/invoice/reports/page'])); ?> submenu">
                        <a href="#"><i class="la la-pie-chart"></i> <span>Reports</span> <span class="menu-arrow"></span></a>
                        <ul>
                            <li><a class="<?php echo e(set_active(['form/expense/reports/page'])); ?>" href="<?php echo e(route('form/expense/reports/page')); ?>">Expense Report</a></li>
                            <li><a class="<?php echo e(set_active(['form/invoice/reports/page'])); ?>" href="<?php echo e(route('form/invoice/reports/page')); ?>">Invoice Report</a></li>
                            <li><a class="<?php echo e(set_active(['form/payments/reports/page'])); ?>" href="<?php echo e(route('form/payments/reports/page')); ?>">Payments Report</a></li>
                            <li><a class="<?php echo e(set_active(['form/employee/reports/page'])); ?>" href="<?php echo e(route('form/employee/reports/page')); ?>">Employee Report</a></li>
                            <li><a class="<?php echo e(set_active(['form/attendance/reports/page'])); ?>" href="<?php echo e(route('form/attendance/reports/page')); ?>">Attendance Report</a></li>
                            <li><a class="<?php echo e(set_active(['form/leave/reports/page'])); ?>" href="<?php echo e(route('form/leave/reports/page')); ?>">Leave Report</a></li>
                        </ul>
                    </li>
                <?php endif; ?>

                <?php if(Auth::user()->role_name == 'Normal User'): ?>
                    <!-- Employee Menu -->
                    <li class="menu-title"><span>Employees</span></li>
                    <li class="<?php echo e(set_active(['all/employee/list', 'form/leaves/employee/new'])); ?> submenu">
                        <a href="#"><i class="la la-user"></i> <span>Employees</span> <span class="menu-arrow"></span></a>
                        <ul>
                            <li><a class="<?php echo e(set_active(['all/employee/list'])); ?>" href="<?php echo e(route('all/employee/card')); ?>">All Employees</a></li>
                            <li><a class="<?php echo e(set_active(['form/leaves/employee/new'])); ?>" href="<?php echo e(route('form/leaves/employee/new')); ?>">Leaves</a></li>
                            <li><a class="<?php echo e(set_active(['attendance/employee/page'])); ?>" href="<?php echo e(route('attendance/employee/page')); ?>">Attendance</a></li>
                            <li><a class="<?php echo e(set_active(['form/timesheet/page'])); ?>" href="<?php echo e(route('form/timesheet/page')); ?>">Timesheet</a></li>
                            <li><a class="<?php echo e(set_active(['form/shiftscheduling/page'])); ?>" href="<?php echo e(route('form/shiftscheduling/page')); ?>">Shift & Schedule</a></li>
                            <li><a class="<?php echo e(set_active(['form/overtime/page'])); ?>" href="<?php echo e(route('form/overtime/page')); ?>">Overtime</a></li>
                           
                        </ul>
                    </li>

                    <li class="<?php echo e(set_active(['all/employee/list', 'form/leaves/employee/new'])); ?> submenu">
                        <a href="#"><i class="la la-user"></i> <span>Project Management</span> <span class="menu-arrow"></span></a>
                        <ul>
                            <li><a class="<?php echo e(set_active(['projects'])); ?>" href="<?php echo e(route('projects.index')); ?>">Projects</a></li>
                            <li><a class="<?php echo e(set_active(['tasks'])); ?>" href="<?php echo e(route('task.index')); ?>">Tasks</a></li>
                            <li><a class="<?php echo e(set_active(['defects'])); ?>" href="<?php echo e(route('defects.index')); ?>">Defect Task</a></li>
                           
                        </ul>
                    </li>
                <?php endif; ?>
            </ul>
        </div>
    </div>
</div>
<!-- /Sidebar -->
<?php /**PATH C:\Users\GUGAN\Desktop\HTML\Gugan_MIS\resources\views/sidebar/sidebar.blade.php ENDPATH**/ ?>