 
<?php $__env->startSection('content'); ?>
    <link href="https://cdn.jsdelivr.net/npm/toastr@2.1.4/build/toastr.min.css" rel="stylesheet">
 
    <div class="page-wrapper">
        <div class="content container-fluid">
            <div class="page-header">
                <div class="row align-items-center">
                    <div class="col">
                        <h3 class="page-title">Designations</h3>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="<?php echo e(route('home')); ?>">Dashboard</a></li>
                            <li class="breadcrumb-item active">Designations</li>
                        </ul>
                    </div>
                    <div class="col-auto float-right ml-auto">
                        <!-- Add Designation Button -->
                        <a href="#" class="btn add-btn" data-toggle="modal" data-target="#add_designation"><i class="fa fa-plus"></i> Add Designation</a>
                    </div>
                </div>
            </div>
 
            <?php if(session('success')): ?>
                <div class="alert alert-success">
                    <?php echo e(session('success')); ?>

                </div>
            <?php endif; ?>
 
            <?php if(session('error')): ?>
                <div class="alert alert-danger">
                    <?php echo e(session('error')); ?>

                </div>
            <?php endif; ?>
 
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table table-striped custom-table mb-0 datatable">
                            <thead>
                                <tr>
                                    <th>#</th>
                                    <th>Designation</th>
                                    <th>Department</th>
                                    <th class="text-right">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__currentLoopData = $designations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $designation): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <tr>
                                        <td><?php echo e($loop->iteration); ?></td>
                                        <td><?php echo e($designation->designation); ?></td>
                                        <td><?php echo e($designation->department); ?></td>
                                        <td class="text-right">
                                            <a href="#" class="btn btn-sm btn-info edit-designation"
                                                data-id="<?php echo e($designation->id); ?>"
                                                data-designation_name="<?php echo e($designation->designation); ?>"
                                                data-department="<?php echo e($designation->department); ?>"
                                                data-toggle="modal"
                                                data-target="#edit_designation">Edit</a>
                                            <a href="#" class="btn btn-sm btn-danger delete-designation"
                                                data-id="<?php echo e($designation->id); ?>"
                                                data-toggle="modal"
                                                data-target="#delete_designation">Delete</a>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
 
        <!-- Add Designation Modal -->
        <div id="add_designation" class="modal custom-modal fade" tabindex="-1" aria-labelledby="add_designation_label" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Add New Designation</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">&times;</button>
                    </div>
                    <div class="modal-body">
                        <form id="addDesignationForm" method="POST" action="<?php echo e(route('form.designations.save')); ?>">
                            <?php echo csrf_field(); ?>
                            <div class="form-group">
                                <label>Designation Name</label>
                                <input class="form-control <?php $__errorArgs = ['designation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" type="text" name="designation" value="<?php echo e(old('designation')); ?>" required>
                                <?php $__errorArgs = ['designation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group">
                                <label>Department</label>
                                <select class="form-control <?php $__errorArgs = ['department'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" name="department" required>
                                    <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($department->department); ?>" <?php echo e(old('department') == $department->department ? 'selected' : ''); ?>><?php echo e($department->department); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                                <?php $__errorArgs = ['department'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="invalid-feedback"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <button class="btn btn-primary submit-btn">Save</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
 
        <!-- Edit Designation Modal -->
        <div id="edit_designation" class="modal custom-modal fade" tabindex="-1" aria-labelledby="edit_designation_label" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Edit Designation</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">&times;</button>
                    </div>
                    <div class="modal-body">
                        <form id="editDesignationForm" method="POST" action="">
                            <?php echo csrf_field(); ?>
                            <input type="hidden" id="edit_designation_id" name="id">
 
                            <div class="form-group">
                                <label>Designation Name</label>
                                <input class="form-control" id="edit_designation_name" type="text" name="designation" required>
                            </div>
 
                            <div class="form-group">
                                <label>Department</label>
                                <select class="form-control" id="edit_department" name="department" required>
                                    <?php $__currentLoopData = $departments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $department): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <option value="<?php echo e($department->department); ?>"><?php echo e($department->department); ?></option>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </select>
                            </div>
 
                            <button class="btn btn-primary submit-btn">Save Changes</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
 
        <!-- Delete Designation Modal -->
        <div id="delete_designation" class="modal custom-modal fade" tabindex="-1" aria-labelledby="delete_designation_label" aria-hidden="true">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Delete Designation</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">&times;</button>
                    </div>
                    <div class="modal-body">
                        <form id="deleteDesignationForm" method="POST" action="<?php echo e(route('form.designations.delete', ':id')); ?>">
                            <?php echo csrf_field(); ?>
                            <?php echo method_field('DELETE'); ?>
                            <p>Are you sure you want to delete this designation?</p>
                            <input type="hidden" id="delete_designation_id" name="id">
                            <button class="btn btn-danger submit-btn">Delete</button>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php $__env->stopSection(); ?>
 
<?php $__env->startSection('script'); ?>
<script>
    // Edit Designation
    $(document).on('click', '.edit-designation', function() {
        var designationId = $(this).data('id');
        var designationName = $(this).data('designation_name');
        var department = $(this).data('department');
 
        // Set the modal input fields with data
        $('#edit_designation_id').val(designationId);
        $('#edit_designation_name').val(designationName);
        $('#edit_department').val(department);
 
        // Set the form action for updating the designation
        var actionUrl = '<?php echo e(route("form.designations.update", ":id")); ?>';
        actionUrl = actionUrl.replace(':id', designationId);
        $('#editDesignationForm').attr('action', actionUrl);
 
        // Show the edit modal
        $('#edit_designation').modal('show');
    });
 
    // Delete Designation
    $(document).on('click', '.delete-designation', function() {
        var designationId = $(this).data('id');
        var action = "<?php echo e(route('form.designations.delete', ':id')); ?>".replace(':id', designationId);
        $('#deleteDesignationForm').attr('action', action);
    });
</script>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.master', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH C:\Users\GUGAN\Desktop\HTML\Gugan_MIS\resources\views/employees/designations.blade.php ENDPATH**/ ?>