@extends('layouts.master')
@section('content')
    <style>
        .select {
            width: 100%; /* Make dropdowns responsive */
            padding: 10px;
            border: 1px solid #ccc;
            border-radius: 4px;
            font-size: 16px;
            background-color: white; /* Light background color */
            color: #333; /* Text color */
            transition: border-color 0.3s; /* Smooth transition for border color */
        }
        .select:focus {
            border-color: red; /* Change border color on focus */
            outline: none; /* Remove default outline */
        }
    </style>
    <!-- Page Wrapper -->
    <div class="page-wrapper">
        <!-- Page Content -->
        <div class="content container-fluid">
            <!-- Page Header -->
            <div class="page-header">
                <div class="row align-items-center">
                    <div class="col">
                        <h3 class="page-title">Leaves <span id="year"></span></h3>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="{{ route('home') }}">Dashboard</a></li>
                            <li class="breadcrumb-item active">Leaves</li>
                        </ul>
                    </div>
                    <div class="col-auto float-right ml-auto">
                        <a href="#" class="btn add-btn" data-toggle="modal" data-target="#add_leave"><i class="fa fa-plus"></i> Add Leave</a>
                    </div>
                </div>
            </div>
            <!-- Leave Statistics -->
            <div class="row">
                <div class="col-md-3">
                    <div class="stats-info">
                        <h6>Today Presents</h6>
                        <h4>1 / {{$usercount}}</h4>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stats-info">
                        <h6>Planned Leaves</h6>
                        <h4>8 <span>Today</span></h4>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stats-info">
                        <h6>Unplanned Leaves</h6>
                        <h4>0 <span>Today</span></h4>
                    </div>
                </div>
                <div class="col-md-3">
                    <div class="stats-info">
                        <h6>Pending Requests</h6>
                        <h4>12</h4>
                    </div>
                </div>
            </div>
            <!-- /Leave Statistics -->

            <!-- <div class="row filter-row">
                <div class="col-sm-6 col-md-3 col-lg-3 col-xl-2 col-12">  
                    <div class="form-group form-focus">
                        <input type="text" class="form-control floating">
                        <label class="focus-label">Employee Name</label>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 col-lg-3 col-xl-2 col-12">  
                    <div class="form-group form-focus select-focus">
                        <select class="select floating"> 
                            <option> -- Select -- </option>
                            <option>Casual Leave</option>
                            <option>Medical Leave</option>
                            <option>Loss of Pay</option>
                        </select>
                        <label class="focus-label">Leave Type</label>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 col-lg-3 col-xl-2 col-12"> 
                    <div class="form-group form-focus select-focus">
                        <select class="select floating"> 
                            <option> -- Select -- </option>
                            <option> Pending </option>
                            <option> Approved </option>
                            <option> Rejected </option>
                        </select>
                        <label class="focus-label">Leave Status</label>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 col-lg-3 col-xl-2 col-12">  
                    <div class="form-group form-focus">
                        <div class="cal-icon">
                            <input class="form-control floating datetimepicker" type="text">
                        </div>
                        <label class="focus-label">From</label>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 col-lg-3 col-xl-2 col-12">  
                    <div class="form-group form-focus">
                        <div class="cal-icon">
                            <input class="form-control floating datetimepicker" type="text">
                        </div>
                        <label class="focus-label">To</label>
                    </div>
                </div>
                <div class="col-sm-6 col-md-3 col-lg-3 col-xl-2 col-12">  
                    <a href="#" class="btn btn-success btn-block"> Search </a>  
                </div>     
            </div> -->

			<!-- /Page Header -->
              
            <div class="row">
                <div class="col-md-12">
                    <div class="table-responsive">
                        <table class="table table-striped custom-table mb-0 datatable">
                            <thead>
                                <tr>
                                    <th>Employee</th>
                                    <th>Leave Type</th>
                                    <th>From</th>
                                    <th>To</th>
                                    <th>No of Days</th>
                                    <th>Reason</th>
                                    <th class="text-center">Status</th>
                                    <th class="text-right">Actions</th>
                                </tr>
                            </thead>

                            <tbody>
                                @if(!empty($getLeave))
                                    @foreach ($getLeave as $items )
                                        @php // get photo from the table users
                                            $profiles  = DB::table('users')->where('name', $items->employee_name)->get();
                                        @endphp
                                        <tr>
                                            <td>
                                            {{ $items->employee_name }}
                                            </td>
                                            <td hidden class="id">{{ $items->id }}</td>
                                            <td class="leave_type">{{$items->leave_type}}</td>
                                            <td hidden class="from_date">{{ $items->date_from }}</td>
                                            <td>{{ $items->date_from }}</td>
                                            <td hidden class="to_date">{{$items->date_to}}</td>
                                            <td>{{$items->date_to}} </td>
                                            <td class="no_of_day">{{$items->number_of_day}} </td>
                                            <td class="leave_reason">{{$items->reason}}</td>
                                            <!-- Status dropdown button -->
                                            <td class="">
    <div class="dropdown action-label">
        <a class="btn btn-white btn-sm btn-rounded dropdown-toggle" href="#" data-toggle="dropdown" aria-expanded="false">
            <i class="fa fa-dot-circle-o text-purple"></i> {{ ucfirst(strtolower($items->status)) }}
        </a>
        <div class="dropdown-menu dropdown-menu-right">
            <a class="dropdown-item status-change" href="#" data-id="{{ $items->id }}" data-status="new"><i class="fa fa-dot-circle-o text-purple"></i> New</a>
            <a class="dropdown-item status-change" href="#" data-id="{{ $items->id }}" data-status="pending"><i class="fa fa-dot-circle-o text-info"></i> Pending</a>
            <a class="dropdown-item status-change" href="#" data-id="{{ $items->id }}" data-status="approved" data-toggle="modal" data-target="#approve_leave"><i class="fa fa-dot-circle-o text-success"></i> Approved</a>
            <a class="dropdown-item status-change" href="#" data-id="{{ $items->id }}" data-status="declined"><i class="fa fa-dot-circle-o text-danger"></i> Declined</a>
        </div>
    </div>
</td>


                                            <td class="text-right">
                                                <div class="dropdown dropdown-action">
                                                    <a href="#" class="action-icon dropdown-toggle" data-toggle="dropdown" aria-expanded="false"><i class="material-icons">more_vert</i></a>
                                                    <div class="dropdown-menu dropdown-menu-right">
                                                    <a class="dropdown-item leaveUpdate" 
   data-toggle="modal" 
   data-id="{{ $items->id }}" 
   data-employee_name="{{ $items->employee_name }}"
   data-leave_type="{{ $items->leave_type }}"
   data-date_from="{{ $items->date_from }}"
   data-date_to="{{ $items->date_to }}"
   data-reason="{{ $items->reason }}"
   data-status="{{ $items->status }}"
   data-target="#edit_leave">
   <i class="fa fa-pencil m-r-5"></i> Edit
</a>

                                                        <form action="{{ route('leaves.delete', $items->id) }}" method="POST" style="display:inline;">
    @csrf
    @method('DELETE')
    <button type="submit" class="dropdown-item leaveDelete" style="border: none; background: none;">
        <i class="fa fa-trash-o m-r-5"></i> Delete
    </button>
</form>
                      </div>
                                                </div>
                                            </td>
                                        </tr>
                                    @endforeach
                                @endif
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
        <!-- /Page Content -->
       
        <!-- Add Leave Modal -->
        <div id="add_leave" class="modal custom-modal fade" role="dialog">
            <div class="modal-dialog modal-dialog-centered modal-dialog-scrollable" role="document">
                <div class="modal-content">
                    <div class="modal-header">
                        <h5 class="modal-title">Add Leave</h5>
                        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                            <span aria-hidden="true">&times;</span>
                        </button>
                    </div>
                    <div class="modal-body">
                        <form class="applyLeave" action="{{ route('form/leaves/save') }}" method="POST">
                            @csrf
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Employee Name <span class="text-danger">*</span></label>
                                        <select class="select select2s-hidden-accessible" style="width: 100%;" tabindex="-1" aria-hidden="true" id="employee_name" name="employee_name">
                                            <option value="">-- Select --</option>
                                            @foreach ($userList as $key=>$user )
                                                <option value="{{ $user->name }}" data-employee_id={{ $user->user_id }}>{{ $user->name }}</option>
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Employee ID<span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="employee_id" name="employee_id" readonly>
                                    </div>
                                </div>
                            </div>
                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Leave Type <span class="text-danger">*</span></label>
                                        <select class="select" id="leave_type" name="leave_type">
                                            <option selected disabled>Select Leave Type</option>
                                            @foreach($leaveInformation as $key => $leaves)
                                                @if($leaves->leave_type != 'Total Leave Balance' && $leaves->leave_type != 'Use Leave' && $leaves->leave_type != 'Remaining Leave')   
                                                    <option value="{{ $leaves->leave_type }}">{{ $leaves->leave_type }}</option>
                                                @endif
                                            @endforeach
                                        </select>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>Remaining Leaves <span class="text-danger">*</span></label>
                                        <input type="text" class="form-control" id="remaining_leave" name="remaining_leave" readonly value="0">
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>From <span class="text-danger">*</span></label>
                                        <div class="cal-icon">
                                            <input type="text" class="form-control datetimepicker" id="date_from" name="date_from" autocomplete="off">
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-6">
                                    <div class="form-group">
                                        <label>To <span class="text-danger">*</span></label>
                                        <div class="cal-icon">
                                            <input type="text" class="form-control datetimepicker" id="date_to" name="date_to" autocomplete="off">
                                        </div>
                                    </div>
                                </div>
                            </div>  
                            <div class="row">
                                <div class="col-md-6" id="leave_dates_display" style="display: none"></div>
                                <div class="col-md-6" id="select_leave_day" style="display: none"></div>
                            </div>
                            <div class="form-group">
                                <label>Number of days <span class="text-danger">*</span></label>
                                <input type="text" class="form-control" id="number_of_day" name="number_of_day" value="0" readonly>
                            </div>
                            <div class="row">
                                <div id="leave_day_select" class="col-md-12">
                                    <div class="form-group">
                                        <label>Leave Day <span class="text-danger">*</span></label>
                                        <select class="select" name="select_leave_day[]" id="leave_day">
                                            <option value="Full-Day Leave">Full-Day Leave</option>
                                            <option value="Half-Day Morning Leave">Half-Day Morning Leave</option>
                                            <option value="Half-Day Afternoon Leave">Half-Day Afternoon Leave</option>
                                            <option value="Public Holiday">Public Holiday</option>
                                            <option value="Off Schedule">Off Schedule</option>
                                        </select>
                                    </div>
                                </div>
                            </div>

                            <div class="form-group">
                                <label>Leave Reason <span class="text-danger">*</span></label>
                                <textarea rows="2" class="form-control" name="reason"></textarea>
                            </div>
                           
                            <div class="submit-section">
                                <button type="submit" id="apply_leave" class="btn btn-primary submit-btn">Submit</button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
       
        <!-- Modal for approval confirmation -->
<div class="modal custom-modal fade" id="approve_leave" role="dialog">
    <div class="modal-dialog modal-dialog-centered">
        <div class="modal-content">
            <div class="modal-body">
                <div class="form-header">
                    <h3>Leave Approve</h3>
                    <p>Are you sure you want to approve this leave?</p>
                </div>
                <div class="modal-btn delete-action">
                    <div class="row">
                        <div class="col-6">
                            <a href="javascript:void(0);" class="btn btn-primary continue-btn">Approve</a>
                        </div>
                        <div class="col-6">
                            <a href="javascript:void(0);" data-dismiss="modal" class="btn btn-primary cancel-btn">Decline</a>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

        <!-- /Approve Leave Modal -->
        
  
  
    <!-- Edit Modal -->

    <!-- Edit Leave Modal -->
    <div class="modal fade" id="edit_leave" tabindex="-1" role="dialog" aria-labelledby="edit_leave_label" aria-hidden="true">
    <div class="modal-dialog modal-dialog-centered" role="document">
        <div class="modal-content">
            <div class="modal-header">
                <h5 class="modal-title" id="edit_leave_label">Edit Leave Request</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <!-- Edit Leave Form -->
                <form action="{{ route('leave.update', ':id') }}" method="POST" id="editLeaveForm">
                    @csrf
                    @method('PUT')

                    <div class="form-group">
                        <label for="employee_name_edit">Employee Name</label>
                        <input type="text" class="form-control" id="employee_name_edit" name="employee_name" required>
                    </div>
                    <div class="form-group">
                        <label for="leave_type_edit">Leave Type</label>
                        <input type="text" class="form-control" id="leave_type_edit" name="leave_type" required>
                    </div>
                    <div class="form-group">
                        <label for="date_from_edit">From</label>
                        <input type="date" class="form-control" id="date_from_edit" name="date_from" required>
                    </div>
                    <div class="form-group">
                        <label for="date_to_edit">To</label>
                        <input type="date" class="form-control" id="date_to_edit" name="date_to" required>
                    </div>
                    <div class="form-group">
                        <label for="reason_edit">Reason</label>
                        <textarea class="form-control" id="reason_edit" name="reason" required></textarea>
                    </div>
                    <div class="form-group">
                        <label for="status_edit">Status</label>
                        <select class="form-control" id="status_edit" name="status">
                            <option value="new">New</option>
                            <option value="pending">Pending</option>
                            <option value="approved">Approved</option>
                            <option value="declined">Declined</option>
                        </select>
                    </div>

                    <button type="submit" class="btn btn-primary">Save Changes</button>
                </form>
            </div>
        </div>
    </div>
</div>


  
  
  
  
        <!-- Delete Leave Modal -->
        <div class="modal custom-modal fade" id="delete_approve" role="dialog">
            <div class="modal-dialog modal-dialog-centered">
                <div class="modal-content">
                    <div class="modal-body">
                        <div class="form-header">
                            <h3>Delete Leave</h3>
                            <p>Are you sure want to delete this leave?</p>
                        </div>
                        <div class="modal-btn delete-action">
                            <form action="{{ route('form/leaves/edit/delete') }}" method="POST">
                                @csrf
                                <input type="hidden" name="id" class="e_id" value="">
                                <div class="row">
                                    <div class="col-6">
                                        <button type="submit" class="btn btn-primary continue-btn submit-btn">Delete</button>
                                    </div>
                                    <div class="col-6">
                                        <a href="javascript:void(0);" data-dismiss="modal" class="btn btn-primary cancel-btn">Cancel</a>
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        <!-- /Delete Leave Modal -->
    </div>
    <!-- /Page Wrapper -->
@section('script')

    <script>
        $(document).ready(function() {
            $('.select2s-hidden-accessible').select2({
                closeOnSelect: false
            });
        });
        $('#employee_name').on('change',function()
        {
            $('#employee_id').val($(this).find(':selected').data('employee_id'));
        });





    </script>


<script>
    $(document).ready(function() {
        // When a status change link is clicked
        $('.status-change').on('click', function(e) {
            e.preventDefault();

            var leaveId = $(this).data('id');
            var status = $(this).data('status');

            // If the status is 'approved', show the confirmation modal
            if (status === 'approved') {
                $('#approve_leave').data('leave-id', leaveId);
            } else {
                updateStatus(leaveId, status); // Update status directly
            }
        });

        // When the user clicks the approve button in the modal
        $('.continue-btn').on('click', function() {
            var leaveId = $('#approve_leave').data('leave-id');
            var status = 'approved';
            updateStatus(leaveId, status);
            $('#approve_leave').modal('hide');
        });

        // AJAX request to update status
        function updateStatus(leaveId, status) {
            $.ajax({
                url: '{{ route('leave.updateStatus') }}',
                method: 'POST',
                data: {
                    id: leaveId,
                    status: status,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response) {
                    if (response.status === 'success') {
                        alert(response.message); // Show success message
                        window.location.reload(); // Refresh the page
                    } else {
                        alert('Failed to update the status.');
                    }
                },
                error: function() {
                    alert('Error occurred while updating the status.');
                }
            });
        }
    });
</script>
<script>

$(document).on('click', '.leaveUpdate', function() {
    var leaveId = $(this).data('id');  // Get the ID of the leave request being edited
    var employeeName = $(this).data('employee_name');
    var leaveType = $(this).data('leave_type');
    var dateFrom = $(this).data('date_from');
    var dateTo = $(this).data('date_to');
    var reason = $(this).data('reason');
    var status = $(this).data('status');
    
    // Set the form values in the modal
    $('#employee_name_edit').val(employeeName);
    $('#leave_type_edit').val(leaveType);
    $('#date_from_edit').val(dateFrom);
    $('#date_to_edit').val(dateTo);
    $('#reason_edit').val(reason);
    $('#status_edit').val(status);

    // Update the form action URL to include the correct leave ID
    var actionUrl = '{{ route("leave.update", ":id") }}';
    actionUrl = actionUrl.replace(':id', leaveId);
    $('#editLeaveForm').attr('action', actionUrl);
});

</script>


    <!-- Calculate Leave  -->
    <script>
        // Define the URL for the AJAX request
        var url = "{{ route('hr/get/information/leave') }}";
        
        // Function to handle leave type change
        function handleLeaveTypeChange() {
            var leaveType   = $('#leave_type').val();
            var numberOfDay = $('#number_of_day').val();    
            $.post(url, {
                leave_type: leaveType,
                number_of_day: numberOfDay,
                _token: $('meta[name="csrf-token"]').attr('content')
            }, function(data) {
                if (data.response_code == 200) {
                    $('#remaining_leave').val(data.leave_type);
                }
            }, 'json');
        }
        
        function countLeaveDays()
        {
            // Get the date values from input fields
            var dateFrom = new Date($('#date_from').val());
            var dateTo   = new Date($('#date_to').val());
            var leaveDay = $('#leave_day').val();
            
            if (!isNaN(dateFrom) && !isNaN(dateTo)) {
                var numDays = Math.ceil((dateTo - dateFrom) / (1000 * 3600 * 24)) + 1;
                if (leaveDay.includes('Half-Day')) numDays -= 0.5;
                $('#number_of_day').val(numDays);
                updateRemainingLeave(numDays);

                // Clear previous display
                $('#leave_dates_display').empty();
                $('#select_leave_day').empty();

                // Display each date one by one if numDays > 0
                if (numDays > 0) {
                    for (let d = 0; d < numDays; d++) {
                        let currentDate = new Date(dateFrom);
                        currentDate.setDate(currentDate.getDate() + d);
                        var formattedDate = currentDate.getDate() + ' ' + (currentDate.getMonth() + 1) + ',' + currentDate.getFullYear();

                        document.getElementById('leave_day_select').style.display = 'block'; // or 'flex', depending on your layout
                        // Append each leave date to the display
                        if (numDays > 0) {
                            document.getElementById('leave_dates_display').style.display = 'block'; // or 'flex', depending on your layout
                            document.getElementById('select_leave_day').style.display = 'block'; // or 'flex', depending on your layout

                            const inputDate = formattedDate;
                            let [day, month, year] = inputDate.split(/[\s,]+/);
                            let date = new Date(year, month - 1, day - 1);
                            let formattedDateConvert = currentDate.getDate() + ' ' + currentDate.toLocaleString('en-GB', { month: 'short' }) + ', ' + currentDate.getFullYear();

                            // Create unique IDs for inputs and labels
                            let leaveDateInputId = `leave_date_${d}`;

                            // Append each leave date to the display
                            $('#leave_dates_display').append(`
                                <div class="form-group">
                                    <label><span class="text-danger">Leave Date ${d+1}</span></label>
                                    <div class="cal-icon">
                                        <input type="text" class="form-control" id="${leaveDateInputId}" name="leave_date[]" value="${formattedDateConvert}" readonly>
                                    </div>
                                </div>
                            `);
                            
                            // Function to generate leave day select elements
                            function generateLeaveDaySelects(numDays) {
                                $('#select_leave_day').empty(); // Clear existing elements
                                for (let d = 0; d < numDays; d++) {
                                    let leaveDayId = `leave_day_${d}`;
                                    document.getElementById('leave_day_select').style.display = 'none'; // or 'flex', depending on your layout
                                    $('#select_leave_day').append(`
                                        <div class="form-group">
                                            <label><span class="text-danger">Leave Day ${d+1}</span></label>
                                            <select class="select" name="select_leave_day[]" id="${leaveDayId}">
                                                <option value="Full-Day Leave">Full-Day Leave</option>
                                                <option value="Half-Day Morning Leave">Half-Day Morning Leave</option>
                                                <option value="Half-Day Afternoon Leave">Half-Day Afternoon Leave</option>
                                                <option value="Public Holiday">Public Holiday</option>
                                                <option value="Off Schedule">Off Schedule</option>
                                            </select>
                                        </div>
                                    `);
                                }
                            }

                            // Call this function when you need to set up the dropdowns
                            generateLeaveDaySelects(numDays);

                            // Function to update total leave days and remaining leave
                            function updateLeaveDaysAndRemaining() {
                                let totalDays = numDays; // Start with the total number of days
                                for (let d = 0; d < numDays; d++) {
                                    let leaveType = $(`#leave_day_${d}`).val(); // Get the selected leave type
                                    if (leaveType && leaveType.includes('Half-Day')) totalDays -= 0.5;
                                }
                                $('#number_of_day').val(totalDays);
                                // Update remaining leave
                                updateRemainingLeave(totalDays);
                            }

                            // Event listener for leave day selection change
                            $(document).on('change', '[id^="leave_day"]', updateLeaveDaysAndRemaining);

                            // Initial setup
                            updateLeaveDaysAndRemaining();
                        } else {
                            $('#leave_dates_display').hide();
                            $('#select_leave_day').hide();
                        }
                    }
                    
                }
            } else {
                $('#number_of_day').val('0');
                $('#leave_dates_display').text(''); // Clear the display in case of invalid dates
                $('#select_leave_day').text(''); // Clear the display in case of invalid dates
            }
        }
            
        // Function to update remaining leave
        function updateRemainingLeave(numDays) {
            $.post(url, {
                number_of_day: numDays,
                leave_type: $('#leave_type').val(),
                _token: $('meta[name="csrf-token"]').attr('content')
            }, function(data) {
                if (data.response_code == 200) {
                    $('#remaining_leave').val(data.leave_type);
                    $('#apply_leave').prop('disabled', data.leave_type < 0);
                    // Show the alert only once if leave type is less than 0
                    if (data.leave_type < 0 && !$('#apply_leave').data('alerted')) {
                        toastr.info('You cannot apply for leave at this time.');
                        $('#apply_leave').data('alerted', true);
                    } else if (numDays < 0.5) {
                        $('#apply_leave').prop('disabled', true);
                    }
                }
            }, 'json');
        }
        
        // Event listeners
        $('#leave_type').on('change', handleLeaveTypeChange);
        $('#date_from, #date_to, #leave_day').on('dp.change', countLeaveDays);

        // Clearn data in form
        $(document).on('click', '.close', function() {
            // Clear the leave dates display
            $('#leave_dates_display').empty();
            // Clear the select leave day display
            $('#select_leave_day').empty();
            // Reset other relevant fields
            $('#number_of_day').val('');
            $('#date_from').val('');
            $('#date_to').val('');
            $('#leave_type').val(''); // Reset to default value if needed
            $('#remaining_leave').val('');
            // Optionally hide any UI elements
            $('#leave_day_select').hide(); // or reset to its original state
        });
    </script>

    <!-- Validate Form  -->
    <script>
        $(document).ready(function() {
            $(".applyLeave").validate({
                rules: {
                    employee_name: { required: true },
                    leave_type: { required: true },
                    date_from: { required: true },
                    date_to: { required: true },
                    reason: { required: true }
                },
                messages: {
                    employee_name: "Please select employee name",
                    leave_type: "Please select leave type",
                    date_from: "Please select date from",
                    date_to: "Please select date to",
                    reason: "Please input reason for leave"
                },
                errorElement: 'span',
                errorClass: 'text-danger',
                errorPlacement: function(error, element) {
                    error.appendTo(element.parent());
                },
                submitHandler: function(form) {
                    form.submit();
                }
            });
    
            $('#employee_name, #leave_type').on('change', function() {
                $(this).siblings('span.error').toggle(!$(this).val());
            });
        });
    </script>
    

    @endsection
@endsection
