# SilverStripe community code of conduct

These guidelines aim to be an aspirational ideal for how we should behave when interacting in the SilverStripe developer community and to aid in building great open source software.

This code of conduct should be applied to all discussions and interactions involving SilverStripe and its related resources.

Honour the code of conduct whenever you participate formally and informally in our community and follow it in spirit as much as in letter.

## **Be open, collaborative and curious**

 * Experiment with your code and share the results.
 * Ask questions if you get stuck.
 * If you can answer questions be responsive and help guide others towards solutions
 * Share code and knowledge that might help others.
 * The community is first and foremost about people sharing their knowledge to build something great together.

## Be empathetic, friendly and considerate.
 * Welcome and encourage participation from everyone that wishes to join our community.
 * Remember growing the community socially is as important as code related matters.
 * Be respectful and honour diversity in our community. Sexist, racist, and other exclusionary jokes can offend those around you and are not appropriate.
 * Keep your actions lawful, non-discriminatory, and unthreatening towards others.

## Respect the reader’s time.
 * Be concise and read over things before you post.
 * Mind your words, you write something once that will be read by many - being abusive, mean spirited and swearing at others does nothing to help get points across and drive constructive contributions to open source.
 * Be clear when responding who you are representing, are you speaking on behalf of another business or acting in your capacity as an individual community member? Either is fine and encouraged and you should aim to make it clear to the reader.

## Respect different levels of participation.
 * Welcome newcomers, spend a little time helping orientate them in our community.
 * All contributors and core committers, module maintainers and knowledge sharers are participating in the community in a voluntary nature. Have respect for them and their time when making requests. You may need to exercise some patience.
 * Whenever possible reference your comments to others with example code or links to documentation. This helps people learn and become more experienced community members and developers.
 * If you manage to solve your own problem, tell others how you solved it. This will help people in the future that find they have the same problem as you.
 * If you are reducing your input and potentially stepping away from the community please remember others might rely on your contributions. Be prepared to ensure these are kept open and available, spend some time handing over to another community member or core contributor to help continuity of SilverStripe open source.

## Resolve conflicts directly
 * Conflict may eventuate from time to time, we should view it as a constructive process. Understanding others positions without descending into ad hominem attacks is valuable.
 * Involve a 3rd party or if necessary inform a core committer if conflicts continue to escalate.
 * Breaches of the code of conduct by community members may first result in a reminder about the code of conduct (we realise we're all human and sometimes we have bad days).
 * Repeated and deliberate breaching after this will be referred to the core committers team and may result in members being asked to leave the community channels.
 * While we have a policy of not removing postings and comments from our digital channels, there may be times in which items are removed if deemed blatantly discriminatory towards individuals, groups or cultures.
 * Call others on their behaviour within the community and remind them of this code where necessary.
 * Refer to [these helpful guides on conflict resolution](http://www.crnhq.org/pages.php?pID=10) to aid you.

## A living document
 * This is a living document, as core committers we don't have all the answers and we attempt to make the community an innovative and valuable space for everyone that wishes to participate.

 * If you would like to improve the wording, add additional items, or simply fix typos, each contribution to the code of conduct will be considered on it's merit and agreed upon unanimously by the core committers. Any changes will be included in future revisions of the SilverStripe code of conduct.

## Core committers house rules
Core committers are also bound by their [own set of house rules](core_committers#house_rules_for_the_core_committer_team).

_The SilverStripe code of conduct has been adapted from the following sources:_

http://www.apache.org/foundation/policies/conduct.html

https://www.djangoproject.com/conduct/

http://web.archive.org/web/20141109123859/http://speakup.io/coc.html

http://www.crnhq.org/pages.php?pID=10
