title: Bug Reports
summary: Report bugs or problems with SilverStripe, feature requests or other issues.

# Contributing Issues and Opinions

## Reporting Bugs

If you have discovered a bug in SilverStripe, we'd be glad to hear about it -
well written bug reports can be half of the solution already!

 * [Framework Bugtracker](https://github.com/silverstripe/silverstripe-framework/issues)
 * [CMS Bugtracker](https://github.com/silverstripe/silverstripe-cms/issues)
 * [Documentation Bugtracker](https://github.com/silverstripe/silverstripe-framework/issues)
 * Search on [http://silverstripe.org/modules](http://silverstripe.org/modules) for module-specific bugtrackers
 * Request features: [UserVoice](http://silverstripe.uservoice.com).

Before submitting a bug:

 * Ask for assistance on the [forums](http://www.silverstripe.org/community/forums/), [core mailinglist](http://groups.google.com/group/silverstripe-dev) or on [IRC](http://irc.silverstripe.org/) if you're unsure if its really a bug.
 * Search for similar, existing tickets
 * Is this a security issue? Please follow our separate reporting guidelines below.
 * Is this a issue with the core framework or cms? Modules have their own issue trackers (see [silverstripe.org/modules](http://www.silverstripe.org/modules/))
 * Try to reproduce your issue on a [clean installation](/getting_started/composer#using-development-versions), maybe the bug has already been fixed on an unreleased branch?
 * The bugtracker is not the place to discuss enhancements, please use the forums or mailinglist.
   Only log enhancement tickets if they gather a large interest in the community
   and the enhancement is likely to be implemented in the next couple of months.

If the issue does look like a new bug:

 * [Create a new ticket](https://github.com/silverstripe/silverstripe-framework/issues/new)
 * Describe the steps required to reproduce your issue, and the expected outcome. Unit tests, screenshots and screencasts can help here.
 * Describe your environment as detailed as possible: SilverStripe version, Browser, PHP version, Operating System, any installed SilverStripe modules.
 * *(optional)* [Submit a pull request](/contributing/code/#step-by-step-from-forking-to-sending-the-pull-request) which fixes the issue.

Lastly, don't get your hopes up too high. Unless your issue is a blocker 
affecting a large number of users, don't expect SilverStripe developers to jump 
onto it right way. Your issue is a starting point where others with the same 
problem can collaborate with you to develop a fix. 

## Feature Requests

<div class="warning" markdown='1'>
Please don't file "feature requests" as Github issues. If there's a new feature 
you'd like to see in SilverStripe, you either need to write it yourself (and 
[submit a pull request](/contributing/code/#step-by-step-from-forking-to-sending-the-pull-request) or convince somebody else to 
write it for you. Any "wishlist" type issues without code attached can be 
expected to be closed as soon as they're reviewed.
</div>

In order to gain interest and feedback in your feature, we encourage you to 
present it to the community through the [forums](http://www.silverstripe.org/community/forums), 
[core mailinglist](http://groups.google.com/group/silverstripe-dev) or on 
[IRC](http://irc.silverstripe.org/).

## Reporting Security Issues

Report security issues to [security@silverstripe.org](mailto:security@silverstripe.org). 
See our "[Release Process](/contributing/release_process/#security-releases)" documentation for more info, and 
read our guide on [how to write secure code](/developer_guides/security/secure_coding/).

## Sharing your Opinion

* [silverstripe.org/forums](http://www.silverstripe.org/community/forums/): Forums on silverstripe.org
* [silverstripe-dev](http://groups.google.com/group/silverstripe-dev/): Core development mailinglist
* [silverstripe-documentation](http://groups.google.com/group/silverstripe-translators/): Translation team mailing list
