# 3.0.3-rc2 (2012-11-16)

## Overview

3.0.3 provides security fixes, bugfixes and a number of minor enhancements since 3.0.2.

Upgrading from 3.0.x should be a straightforward matter of dropping in the new release,
with the exception noted below.

## Upgrading

Impact of the upgrade:

* Reset password email links generated prior to 3.0.3 will cease to work.
* Users who use the "remember me" login feature will have to log in again.

API changes related to the below security patch:

* `Member::generateAutologinHash` is deprecated. You can no longer get the autologin token from `AutoLoginHash` field in `Member`. Instead use the return value of the `Member::generateAutologinTokenAndStoreHash` and do not persist it.
* `Security::getPasswordResetLink` now requires `Member` object as the first parameter. The password reset URL GET parameters have changed from only `h` (for hash) to `m` (for member ID) and `t` (for plaintext token).
* `RandomGenerator::generateHash` will be deprecated with 3.1. Rename the function call to `RandomGenerator::randomToken`.

### Security: Hash autologin tokens before storing in the database.

Severity: Moderate

Autologin tokens (remember me and reset password) are stored in the database as a plain text.
If attacker obtained the database they would be able to gain access to accounts that have requested a password change, or have "remember me" enabled.

## Changelog

### API Changes

 * 2012-11-16 [0dd97a3](https://github.com/silverstripe/sapphire/commit/0dd97a3) Form#loadDataFrom 2nd arg now sets how existing field data is merged with new data (Hamish Friedlander)
 * 2012-11-08 [a8b0e44](https://github.com/silverstripe/sapphire/commit/a8b0e44) Hash autologin tokens before storing in the database. (Mateusz Uzdowski)

### Bugfixes

 * 2012-11-16 [7315be4](https://github.com/silverstripe/sapphire/commit/7315be4) default values from DataObject not showing in GridField details form (Hamish Friedlander)
 * 2012-11-15 [78ab9d3](https://github.com/silverstripe/sapphire/commit/78ab9d3) Video embed from Add Media Feature no longer works (open #8033) (stojg)

### Other

 * 2012-11-09 [05a44e8](https://github.com/silverstripe/sapphire/commit/05a44e8) Correct branch for Travis build status image (Ingo Schommer)
