# 3.0.3-rc1 (2012-11-06)

## Overview

3.0.3 provides security fixes, bugfixes and a number of minor enhancements since 3.0.2.

Upgrading from 3.0.x should be a straightforward matter of dropping in the new release.

## Upgrading

### Security: JSONDataFormatter/RestfulServer information leak

Severity: Important

The `JSONDataFormatter` skipped object-level access checks via `canView()`,
which could lead to information leakage (e.g. when used through the
["restfulserver" module](https://github.com/silverstripe/silverstripe-restfulserver)).
Thanks to Rutger de Jong for reporting.

### Security: Privilege escalation through profile form

Severity: Moderate

A logged-in CMS user can gain additional privileges by crafting a request
to their profile form which resets another user's password.
This method can potentially be used by CSRF attacks as well.
Thanks to Nathaniel Carew (Sense of Security) for reporting.

### Security: XSS vulnerability in "Site Title" CMS input field

Severity: Moderate

The "Site Title" field (SiteConfig.Title) can be altered to contain
unsanitized HTML which is rendered unescaped in the CMS. This can lead
to XSS attacks.
Thanks to Nathaniel Carew (Sense of Security) for reporting.

## Changelog

### API Changes

 * 2012-10-17 [8eb0fa9](https://github.com/silverstripe/sapphire/commit/8eb0fa9) Add the ability to query if the schema update is in progress. (Mateusz Uzdowski)
 * 2012-09-06 [4ead89a](https://github.com/silverstripe/sapphire/commit/4ead89a) Adds getManipulatedList() method to GridField to get the SS_List after applying Manipulators (Simon Welsh)

### Features and Enhancements

 * 2012-11-04 [71b8b65](https://github.com/silverstripe/silverstripe-installer/commit/71b8b65) Added dev dependencies to composer. FIX: Don't hardcode framework and cms version in installer. (Sam Minnee)
 * 2012-10-05 [9aaa6b1](https://github.com/silverstripe/sapphire/commit/9aaa6b1) change those harded-coded 'sapphire' to 'framework' either in javascript code or inline document, or a &lt;a&gt; href propty. (Normann Lou)
 * 2012-10-04 [de36063](https://github.com/silverstripe/sapphire/commit/de36063) Make it possible to extend SS_Log (Simon Elvery)
 * 2012-10-04 [11f1c0a](https://github.com/silverstripe/sapphire/commit/11f1c0a) Add documentation for the new config system in 3.0 (Hamish Friedlander)
 * 2012-09-28 [91e4fde](https://github.com/silverstripe/sapphire/commit/91e4fde) "Readonly" behaviour for CMS tabs (Ingo Schommer)
 * 2012-09-27 [b7e7c16](https://github.com/silverstripe/sapphire/commit/b7e7c16) Amend Travis build to run a simple PHP_CodeSniffer test. (Sam Minnee)
 * 2012-09-26 [07bc75c](https://github.com/silverstripe/sapphire/commit/07bc75c) open/7881 - removed disabled checkboxes and replaced them with green ticks. Added help text above the list of permissions. Removed action buttons by fade out when user goes to users permissions tab. (Jeremy Bridson)
 * 2012-09-25 [f265595](https://github.com/silverstripe/sapphire/commit/f265595) GridFieldPageCount control for displaying the current page count/total in the gridview header. Designed to complement a functional pager in the grid footer. NEW: GridFieldPageCount widget to default config settings FIX: @extend .col_buttons in GridField.scss which was raising a warning (Damian Mooyman)
 * 2012-09-04 [53fdafb](https://github.com/silverstripe/silverstripe-cms/commit/53fdafb) 7839 Support for documents as a file type in Files and images (jean)
 * 2012-09-04 [70cc688](https://github.com/silverstripe/sapphire/commit/70cc688) 7838 Support for document as a category in File class (jean)
 * 2012-09-03 [b6a6c46](https://github.com/silverstripe/sapphire/commit/b6a6c46) Allow setting default cache lifetime, and test that it's being used correctly on new caches (Sean Harvey)
 * 2012-08-20 [ce68c4a](https://github.com/silverstripe/sapphire/commit/ce68c4a) Send javascript events on show and hide of treedropdown (Andrew O'Neil)

### Bugfixes

 * 2012-11-05 [3451da0](https://github.com/silverstripe/sapphire/commit/3451da0) Fixing session keep alive for non-ADMIN users (Sean Harvey)
 * 2012-11-05 [aff28eb](https://github.com/silverstripe/sapphire/commit/aff28eb) JSONDataFormatter should respect canView() permissions (Sean Harvey)
 * 2012-11-05 [7a7c1a6](https://github.com/silverstripe/sapphire/commit/7a7c1a6) Escape tree title (Sean Harvey)
 * 2012-11-05 [5152164](https://github.com/silverstripe/sapphire/commit/5152164) Multiple HTMLEditorFields not redrawing, fix by storing its container object before setting timeout (Normann Lou)
 * 2012-11-05 [1cb9c34](https://github.com/silverstripe/sapphire/commit/1cb9c34) ing broken references to sprites (probably caused by old Compass version) (Sean Harvey)
 * 2012-11-04 [2d3c33d](https://github.com/silverstripe/sapphire/commit/2d3c33d) Fixed details about version in composer create-project (Sam Minnee)
 * 2012-11-04 [dfd3455](https://github.com/silverstripe/sapphire/commit/dfd3455) Only include processed requirements at the top level. (Fixes #7847) (Will Rossiter)
 * 2012-11-01 [a5fd3cf](https://github.com/silverstripe/sapphire/commit/a5fd3cf) Inspect current directory for include_path (Ingo Schommer)
 * 2012-10-31 [bcbf463](https://github.com/silverstripe/sapphire/commit/bcbf463) Remove .ss-tabset class from CMS tabs to prevent rogue ajax load (#7980) (Ingo Schommer)
 * 2012-10-31 [2d04de0](https://github.com/silverstripe/sapphire/commit/2d04de0) FormField-&gt;removeExtraClass() works on indexed arrays (Ingo Schommer)
 * 2012-10-31 [d342794](https://github.com/silverstripe/sapphire/commit/d342794) Fixed intermittent absence of UploadField "drop" area (Ingo Schommer)
 * 2012-10-31 [5ca1d5b](https://github.com/silverstripe/sapphire/commit/5ca1d5b) Fixes to the topics/forms.md documentation (stojg)
 * 2012-10-30 [666a20f](https://github.com/silverstripe/sapphire/commit/666a20f) ed DropdownFieldTest assertions when tidy is not available (Ingo Schommer)
 * 2012-10-29 [1ce279e](https://github.com/silverstripe/sapphire/commit/1ce279e) FileNameFilter should remove any amount of underscores from start of filename (Sean Harvey)
 * 2012-10-28 [a0f8d04](https://github.com/silverstripe/sapphire/commit/a0f8d04) Border at top of tabs when no subtabs (Naomi Guyer)
 * 2012-10-24 [9c1b469](https://github.com/silverstripe/sapphire/commit/9c1b469) Fixed DateField date format error for IE8 (Marcus Nyeholt)
 * 2012-10-24 [ac48950](https://github.com/silverstripe/sapphire/commit/ac48950) Fixing "+" characters being replaced with whitespace (Sean Harvey)
 * 2012-10-23 [b221f7b](https://github.com/silverstripe/silverstripe-cms/commit/b221f7b) Remove Metadata Label from RedirectorPage. (Fixes #7959) (Will Rossiter)
 * 2012-10-19 [7254344](https://github.com/silverstripe/silverstripe-cms/commit/7254344) Fixed SideReport for use with Postgres (using v8.4) which requires table/column-names to be quoted. MySQL seems OK with either/both (Russell Michell)
 * 2012-10-18 [9158dea](https://github.com/silverstripe/sapphire/commit/9158dea) No indent on rightTitle (fixes #7950) (Naomi Guyer)
 * 2012-10-18 [c924445](https://github.com/silverstripe/silverstripe-cms/commit/c924445) Installation successful "CMS" link has broken href (fixes #7874) (Naomi Guyer)
 * 2012-10-17 [1a864d7](https://github.com/silverstripe/sapphire/commit/1a864d7) Force gridfield to wrap on long content (Naomi Guyer)
 * 2012-10-16 [ef32310](https://github.com/silverstripe/silverstripe-cms/commit/ef32310) Allow 1024 chars for keywords, not a mere 255 (Sam Minnee)
 * 2012-10-16 [0d7816b](https://github.com/silverstripe/sapphire/commit/0d7816b) Fixed issue with Deprecation failing to extract the module from a stacktrace, especially on non-unix systems API Added Convert::nl2os function to normalise end of line characters across systems with tests BUG Fixed i18n unit tests in non-unix systems constantly failing BUG Fixed problems with HTMLCleaner tests failing in non-unix systems (Damian Mooyman)
 * 2012-10-16 [d50cb23](https://github.com/silverstripe/silverstripe-cms/commit/d50cb23) Fixed issue with MigrateSiteTreeLinkingTask test data being incorrectly loaded into database Fixed issue (Damian Mooyman)
 * 2012-10-16 [a171c7e](https://github.com/silverstripe/sapphire/commit/a171c7e) Fixing regression in 26d70d6fca with formatted output in SS_HTMLValue (Sean Harvey)
 * 2012-10-15 [35da873](https://github.com/silverstripe/sapphire/commit/35da873) Using Session::set() for DB::set_alternative_database_name() (Ingo Schommer)
 * 2012-10-15 [9088692](https://github.com/silverstripe/sapphire/commit/9088692) 7906 Regression: GridFieldConfig_RelationEditor: Removing relation deletes data object (UndefinedOffset)
 * 2012-10-15 [e84b033](https://github.com/silverstripe/sapphire/commit/e84b033) Pass only the search string where testing, not the entire form. (Mateusz Uzdowski)
 * 2012-10-15 [06e184a](https://github.com/silverstripe/silverstripe-cms/commit/06e184a) Add "add new" button to Pages list view (fixes 7649) (Naomi Guyer)
 * 2012-10-12 [bc34580](https://github.com/silverstripe/sapphire/commit/bc34580) Fixing model not being set before populateDefaults() (Sean Harvey)
 * 2012-10-11 [9bb1908](https://github.com/silverstripe/sapphire/commit/9bb1908) ing BulkLoader to use increase_time_limit_to() (Sean Harvey)
 * 2012-10-11 [bc64de0](https://github.com/silverstripe/sapphire/commit/bc64de0) ing misleading SimpleImageField deprecation message (Sean Harvey)
 * 2012-10-11 [27a7fc3](https://github.com/silverstripe/sapphire/commit/27a7fc3) ing misleading ImageField deprecation message (Sean Harvey)
 * 2012-10-11 [c99991b](https://github.com/silverstripe/sapphire/commit/c99991b) Dummy Page_Controller initiated during login now is correctly initialised via dependency injection (Damian Mooyman)
 * 2012-10-08 [680baab](https://github.com/silverstripe/sapphire/commit/680baab) Delay HTMLEditorField showing (TinyMCE workaround) (Ingo Schommer)
 * 2012-10-08 [b38cb39](https://github.com/silverstripe/sapphire/commit/b38cb39) Prevent CMS submission on disabled buttons (#7928) (Ingo Schommer)
 * 2012-10-08 [0cce580](https://github.com/silverstripe/sapphire/commit/0cce580) Fix deprecated use of dataFieldByName() in Member_Validator (Sean Harvey)
 * 2012-10-08 [574c53d](https://github.com/silverstripe/sapphire/commit/574c53d) 7927 Redirect to the parent controller after deleting an item in a gridfield (edit form) (jean)
 * 2012-10-05 [5a52904](https://github.com/silverstripe/silverstripe-cms/commit/5a52904) Fixing Update URLSegment from Title behavior. (Ryan Wachtl)
 * 2012-10-05 [1c7b7d0](https://github.com/silverstripe/sapphire/commit/1c7b7d0) ed grammatical error for Form.FIELDISREQUIRED (Will Morgan)
 * 2012-10-05 [113545d](https://github.com/silverstripe/sapphire/commit/113545d) Non-breaking space added automatically by TinyMCE on anchors (Sean Harvey)
 * 2012-10-03 [323fd4a](https://github.com/silverstripe/sapphire/commit/323fd4a) Fixed ef81318aea3c24a898a02f8c6fdc0ec2af66a9c9 for PostgreSQL by quoting fields. (Sam Minnee)
 * 2012-10-03 [4e1b6af](https://github.com/silverstripe/sapphire/commit/4e1b6af) ed long line. (Sam Minnee)
 * 2012-10-02 [b22a7af](https://github.com/silverstripe/sapphire/commit/b22a7af) TreeDropdownField panel positioning (Ingo Schommer)
 * 2012-10-02 [4684601](https://github.com/silverstripe/sapphire/commit/4684601) ed markdown whitespace usage (Ingo Schommer)
 * 2012-10-01 [4d39209](https://github.com/silverstripe/sapphire/commit/4d39209) GridFieldPageCount now throws an exception if added to a gridfield with no gridfieldpaginator (Damian Mooyman)
 * 2012-09-30 [28bd939](https://github.com/silverstripe/sapphire/commit/28bd939) Ignore charset when checking mime types in LeftAndMain ajax responses. (Sam Minnee)
 * 2012-09-29 [356a367](https://github.com/silverstripe/sapphire/commit/356a367) Setting response length directly before output (fixes #7574) (Ingo Schommer)
 * 2012-09-28 [b186626](https://github.com/silverstripe/sapphire/commit/b186626) If a nested page editable but parent not, user can't expand tree (Sean Harvey)
 * 2012-09-28 [a602ba5](https://github.com/silverstripe/sapphire/commit/a602ba5) Old version of SimpleTest does not recognise input fields of type 'email'. (Frank Mullenger)
 * 2012-09-27 [d54ef36](https://github.com/silverstripe/sapphire/commit/d54ef36) ED: CSV Test cases now use platform-correct linebreak characters (Damian Mooyman)
 * 2012-09-27 [5ea2c3d](https://github.com/silverstripe/sapphire/commit/5ea2c3d) ED: Unnecessarily strict comparison of path separators in windows filenames (Damian Mooyman)
 * 2012-09-27 [1f7fc1f](https://github.com/silverstripe/sapphire/commit/1f7fc1f) Remove instances of lines longer than 120c (Sam Minnee)
 * 2012-09-26 [33f67e1](https://github.com/silverstripe/sapphire/commit/33f67e1) ed FulltextSearchable regression from 21a6390d (Ingo Schommer)
 * 2012-09-26 [da70dc4](https://github.com/silverstripe/sapphire/commit/da70dc4) Fixed possible reference to null string (Marcus Nyeholt)
 * 2012-09-25 [bde71c1](https://github.com/silverstripe/silverstripe-cms/commit/bde71c1) ing permission issue with CMSSettingsController, where it won't show up for users with limited rights, even when they have the `EDIT_SITECONFIG` permission (Roman)
 * 2012-09-25 [5186bad](https://github.com/silverstripe/sapphire/commit/5186bad) DateField Calendar - make dates with day- and monthnames validate (martimiz)
 * 2012-09-25 [345dbc8](https://github.com/silverstripe/silverstripe-cms/commit/345dbc8) Fixing broken links "admin/show", should be "admin/pages..." (Sean Harvey)
 * 2012-09-25 [495ffb0](https://github.com/silverstripe/sapphire/commit/495ffb0) ED: Issue with duplicate help tips appearing on select fields in CMS. See Security / Groups / Edit Group form field for example. (Damian Mooyman)
 * 2012-09-25 [cd7ea01](https://github.com/silverstripe/sapphire/commit/cd7ea01) ED: Minor adjustment to order of file fulltext search fields. By matching the order of these index columns to the same as the fields on the table itself, this will prevent the unnecessary regeneration of fulltext indexes on some database connectors each dev/build, notably MS SQL Server. (Damian Mooyman)
 * 2012-09-24 [548ec24](https://github.com/silverstripe/silverstripe-cms/commit/548ec24) Fixing "public function" not allowed in SilverStripeNavigator.js (Sean Harvey)
 * 2012-09-23 [2c4ebd3](https://github.com/silverstripe/silverstripe-cms/commit/2c4ebd3) ing broken SiteTreeHTMLEditorFieldTest (Sean Harvey)
 * 2012-09-23 [0b17e00](https://github.com/silverstripe/sapphire/commit/0b17e00) Fixing percent encoding issues with saveHTML (Sean Harvey)
 * 2012-09-21 [118b28d](https://github.com/silverstripe/silverstripe-cms/commit/118b28d) setFolderName in CMSFileAddController should default to the root (Sean Harvey)
 * 2012-09-20 [ef81318](https://github.com/silverstripe/sapphire/commit/ef81318) Retaining join extraFields on ManyManyList-&gt;add() (Ingo Schommer)
 * 2012-09-20 [954eb60](https://github.com/silverstripe/sapphire/commit/954eb60) If combined files can't be written, fallback instantly to uncombined (Sean Harvey)
 * 2012-09-19 [69d888b](https://github.com/silverstripe/sapphire/commit/69d888b) ED: Issue with test reporting not correctly presenting errors that prevent test execution. (Damian Mooyman)
 * 2012-09-14 [a2d76c9](https://github.com/silverstripe/silverstripe-cms/commit/a2d76c9) Remove page types from the "add new page here" menu if they appear in a hide_ancestor (fixes #7712) (UndefinedOffset)
 * 2012-09-14 [8ec6312](https://github.com/silverstripe/sapphire/commit/8ec6312) Fix to prevent unintended results from getComponentsQuery(...) (stozze)
 * 2012-09-14 [399b2a2](https://github.com/silverstripe/sapphire/commit/399b2a2) ED: collateFamilyIDs() nested groups throws error (Josh)
 * 2012-09-14 [499b7c9](https://github.com/silverstripe/sapphire/commit/499b7c9) Fix to prevent unintended results from getComponentsQuery(...) (stozze)
 * 2012-09-14 [54d8abc](https://github.com/silverstripe/sapphire/commit/54d8abc) ListBoxField and DropdownField does not respect getSource in all Places In some places source is referenced directly and assumed to be array, while in some places the getSource() method is used instead. By changing this you have more freedom when extending these classes (Tom)
 * 2012-09-14 [26d70d6](https://github.com/silverstripe/sapphire/commit/26d70d6) HtmlEditorField doesn't save HTML fragments in HTMLValue correctly (Sean Harvey)
 * 2012-09-14 [0e997d0](https://github.com/silverstripe/sapphire/commit/0e997d0) ED: Cleaned up test case, made sure it initialised consistently and correctly ADDED: Extra assertions to test case to ensure that different expressions of the same index definition were treated as non-changes. (Damian Mooyman)
 * 2012-09-13 [d1a3c80](https://github.com/silverstripe/sapphire/commit/d1a3c80) 7862 Strict equality check on previously selected item in the TreeDropdownField (jean)
 * 2012-09-11 [8a5a4ff](https://github.com/silverstripe/sapphire/commit/8a5a4ff) TinyMCE UI shows placeholders in mi_NZ (fixes #7797) (Ingo Schommer)
 * 2012-09-11 [5eca675](https://github.com/silverstripe/sapphire/commit/5eca675) ed PermissionRole field localization (Ingo Schommer)
 * 2012-09-11 [9124d8a](https://github.com/silverstripe/silverstripe-cms/commit/9124d8a) ed report title column localization (Ingo Schommer)
 * 2012-09-11 [100aa17](https://github.com/silverstripe/sapphire/commit/100aa17) 7856 If the submit button is disabled, to perform the ajax request (jean)
 * 2012-09-11 [45819cf](https://github.com/silverstripe/silverstripe-cms/commit/45819cf) 7856 Show the Create button as disabled if no pagetypes are available for page creation (jean)
 * 2012-09-11 [30e15d1](https://github.com/silverstripe/sapphire/commit/30e15d1) ED: Generation of tables with fulltext indexes now no longer incorrectly thinks that all fulltext indexes have changed. ADDED: Test cases correctly checking for changes (and no changes) to the data model for both fields and indexes. FIXED: References to indexes throughough the code that probably should have quoted field names. This prevents a lot of 'spam' during dev build. This includes an updated FulltextSearchable test case. (Damian Mooyman)
 * 2012-09-10 [e73d28b](https://github.com/silverstripe/sapphire/commit/e73d28b) ing unit test to restore extensions after test (Sean Harvey)
 * 2012-09-07 [02e95ad](https://github.com/silverstripe/silverstripe-cms/commit/02e95ad) Consistently save SiteConfig, and refactor Translatable hooks (Damian Mooyman)
 * 2012-09-07 [5cbd2db](https://github.com/silverstripe/sapphire/commit/5cbd2db) CMSProfileController::Member_ProfileForm() respecting canEdit() permissions on Member (Sean Harvey)
 * 2012-09-07 [dcf5d21](https://github.com/silverstripe/sapphire/commit/dcf5d21) Fixing deprecated usage of dataFieldByName() in Member_Validator (Sean Harvey)
 * 2012-09-06 [d2b4e0d](https://github.com/silverstripe/sapphire/commit/d2b4e0d) Use the manipulated datalist for counting total items. (Simon Welsh)
 * 2012-09-04 [2934423](https://github.com/silverstripe/silverstripe-cms/commit/2934423) Page type names not translated in pages overview search form (Niklas Forsdahl)
 * 2012-09-04 [f843dd5](https://github.com/silverstripe/silverstripe-cms/commit/f843dd5) Fix site tree filter not showing parents of results more than a level deep in the hierachy (Andrew O'Neil)
 * 2012-09-03 [a0462b9](https://github.com/silverstripe/sapphire/commit/a0462b9) Fixes an issue where batch actions dropdown doesn't show up after ajax request back to the cms Pages section (Saophalkun Ponlu)
 * 2012-09-03 [0667617](https://github.com/silverstripe/sapphire/commit/0667617) ED: Issue where messages attached to checkbox fields would not be displayed. (Damian Mooyman)
 * 2012-08-27 [aa52dae](https://github.com/silverstripe/sapphire/commit/aa52dae) Don't add ss-tabset class to GridFieldDetailForms without tabs, as this causes the first &lt;ul&gt; within the form to have tabs applied (Andrew O'Neil)
 * 2012-08-15 [940236a](https://github.com/silverstripe/sapphire/commit/940236a) CMS Menu header now changes height depending on the name. Fixes 7665 (Jeremy Bridson)

### Other

 * 2012-11-05 [cf7f51a](https://github.com/silverstripe/sapphire/commit/cf7f51a) Removed unnecessary step in composer instructions. (Sam Minnee)
 * 2012-11-05 [3f6740f](https://github.com/silverstripe/sapphire/commit/3f6740f) Improved module installation docs for composer. (Sam Minnee)
 * 2012-11-05 [2ae5c49](https://github.com/silverstripe/silverstripe-cms/commit/2ae5c49) Updated translations (Sean Harvey)
 * 2012-11-05 [1861751](https://github.com/silverstripe/sapphire/commit/1861751) Updated translations (Sean Harvey)
 * 2012-11-05 [71c20be](https://github.com/silverstripe/sapphire/commit/71c20be) Updating default en.yml with updated entities (Sean Harvey)
 * 2012-11-05 [b003979](https://github.com/silverstripe/silverstripe-cms/commit/b003979) Tweaking text for "You can start editing" on successful install (Sean Harvey)
 * 2012-11-05 [0964a5b](https://github.com/silverstripe/silverstripe-cms/commit/0964a5b) Updating default en.yml with updated entities (Sean Harvey)
 * 2012-11-05 [2debb0d](https://github.com/silverstripe/silverstripe-installer/commit/2debb0d) Updating favicon (Sean Harvey)
 * 2012-11-03 [c1ae8f9](https://github.com/silverstripe/sapphire/commit/c1ae8f9) Added docs for composer (Sam Minnee)
 * 2012-11-02 [2c5c488](https://github.com/silverstripe/sapphire/commit/2c5c488) Set method visibility to public in FileNameFilterTest (Sean Harvey)
 * 2012-11-02 [cd29b8c](https://github.com/silverstripe/sapphire/commit/cd29b8c) Adding additional tests for special characters in FileNameFilterTest (Sean Harvey)
 * 2012-11-01 [0f83cfc](https://github.com/silverstripe/silverstripe-installer/commit/0f83cfc) Removed custom repo sources from composer.json (Ingo Schommer)
 * 2012-11-01 [6d7a0f5](https://github.com/silverstripe/silverstripe-installer/commit/6d7a0f5) Added composer.json (Ingo Schommer)
 * 2012-11-01 [f0810dc](https://github.com/silverstripe/silverstripe-cms/commit/f0810dc) Added composer.json (Ingo Schommer)
 * 2012-11-01 [3213a6b](https://github.com/silverstripe/sapphire/commit/3213a6b) Added composer.json (Ingo Schommer)
 * 2012-11-01 [0b279a2](https://github.com/silverstripe/sapphire/commit/0b279a2) Changes ping to POST and clears Requirements for ping (Simon Welsh)
 * 2012-10-30 [da4534b](https://github.com/silverstripe/sapphire/commit/da4534b) Removed duplicate assertion comments in DropdownFieldTest (Ingo Schommer)
 * 2012-10-30 [a7753df](https://github.com/silverstripe/sapphire/commit/a7753df) Moved GridField docs to reference (Ingo Schommer)
 * 2012-10-30 [cceee89](https://github.com/silverstripe/silverstripe-installer/commit/cceee89) Release script feedback (Ingo Schommer)
 * 2012-10-30 [9e595db](https://github.com/silverstripe/sapphire/commit/9e595db) Changelogs (Ingo Schommer)
 * 2012-10-30 [e30029b](https://github.com/silverstripe/sapphire/commit/e30029b) Update thirdparty/jquery-ui/datepicker/i18n/jquery.ui.datepicker-en.js (Martin D.)
 * 2012-10-30 [fa348d6](https://github.com/silverstripe/silverstripe-cms/commit/fa348d6) Code refactoring of CMSMain::SearchForm() extracted some methods. (Stig Lindqvist)
 * 2012-10-29 [624f427](https://github.com/silverstripe/sapphire/commit/624f427) Removes line longer than 120c (Simon Welsh)
 * 2012-10-29 [0316818](https://github.com/silverstripe/sapphire/commit/0316818) Fixed typo; "SilverStripe" was mis-spelled. (Russell Michell)
 * 2012-10-27 [b031188](https://github.com/silverstripe/sapphire/commit/b031188) Updated gridfield docs (Simon Welsh)
 * 2012-10-25 [f6f96a6](https://github.com/silverstripe/sapphire/commit/f6f96a6) Update docs/en/changelogs/3.0.0.md (Juan Molina)
 * 2012-10-23 [29c2fec](https://github.com/silverstripe/sapphire/commit/29c2fec) Changes flush and build URLs for tutorials. (Simon Welsh)
 * 2012-10-22 [3b65b38](https://github.com/silverstripe/sapphire/commit/3b65b38) UPDATE: replace subclassing with a DataExtension, add has_many warning (martimiz)
 * 2012-10-16 [3a9edde](https://github.com/silverstripe/sapphire/commit/3a9edde) fixed docs (Zauberfisch)
 * 2012-10-16 [1c32cde](https://github.com/silverstripe/sapphire/commit/1c32cde) ENHANCMENT - documentation for the UploadField (martimiz)
 * 2012-10-16 [28dce22](https://github.com/silverstripe/sapphire/commit/28dce22) Build status in README (Ingo Schommer)
 * 2012-10-16 [607fc58](https://github.com/silverstripe/silverstripe-cms/commit/607fc58) Build status in README (Ingo Schommer)
 * 2012-10-16 [9e34a98](https://github.com/silverstripe/sapphire/commit/9e34a98) Removed wrong datamodel docs (Ingo Schommer)
 * 2012-10-16 [4ff8cff](https://github.com/silverstripe/sapphire/commit/4ff8cff) PHP5.4 fixes (Simon Welsh)
 * 2012-10-16 [570744f](https://github.com/silverstripe/silverstripe-installer/commit/570744f) phing upload-release (modified copy from master) (Ingo Schommer)
 * 2012-10-16 [be8ab2e](https://github.com/silverstripe/sapphire/commit/be8ab2e) Travis branch exclusions (Ingo Schommer)
 * 2012-10-16 [d298ec9](https://github.com/silverstripe/silverstripe-cms/commit/d298ec9) Blacklisting further travis branches (Ingo Schommer)
 * 2012-10-12 [4c35c30](https://github.com/silverstripe/sapphire/commit/4c35c30) Exclude test/travis/_config.php from being include in the test manifest. (Robert Curry)
 * 2012-10-12 [79cc947](https://github.com/silverstripe/silverstripe-cms/commit/79cc947) Batch actions UI enhancement (#7878) (Saophalkun Ponlu)
 * 2012-10-12 [9fe99cf](https://github.com/silverstripe/sapphire/commit/9fe99cf) Batch actions UI enhancement (#7878) (Saophalkun Ponlu)
 * 2012-10-11 [6de479c](https://github.com/silverstripe/sapphire/commit/6de479c) Added github-compatible contributing notes (Ingo Schommer)
 * 2012-10-11 [196db98](https://github.com/silverstripe/silverstripe-cms/commit/196db98) Added github-compatible contributing notes (Ingo Schommer)
 * 2012-10-11 [1ddd85c](https://github.com/silverstripe/silverstripe-installer/commit/1ddd85c) Added github-compatible contributing notes (Ingo Schommer)
 * 2012-10-11 [7625d10](https://github.com/silverstripe/sapphire/commit/7625d10) Update docs/en/installation/from-source.md (Juan Molina)
 * 2012-10-11 [9819752](https://github.com/silverstripe/silverstripe-cms/commit/9819752) Remove use of backticks in BrokenLinksReport, always use ANSI quotes (Sean Harvey)
 * 2012-10-10 [fca9831](https://github.com/silverstripe/sapphire/commit/fca9831) Remove end php tag from TemplateIteratorProvider (Sean Harvey)
 * 2012-10-09 [9e7b8ba](https://github.com/silverstripe/sapphire/commit/9e7b8ba) Point people at silverstripe-dev and not the forum for discussing patches. (Sam Minnee)
 * 2012-10-09 [7d203a9](https://github.com/silverstripe/sapphire/commit/7d203a9) Moved all translator-targeted documentation to contributing/translation and left translation-process for advanced topics relating to module maintainers and the core team. (Sam Minnee)
 * 2012-10-09 [c4d2f9e](https://github.com/silverstripe/sapphire/commit/c4d2f9e) Corrected a number of inbound links pointing to the documentation. (Sam Minnee)
 * 2012-10-09 [c28dd4c](https://github.com/silverstripe/sapphire/commit/c28dd4c) Make the copyright assignment clearer, and gave some explanation of why we do this. (Sam Minnee)
 * 2012-10-09 [65d20e4](https://github.com/silverstripe/sapphire/commit/65d20e4) Simplified some of the code contribution guidelines. (Sam Minnee)
 * 2012-10-09 [433d29c](https://github.com/silverstripe/sapphire/commit/433d29c) Removed 'release candidate branch' step of contributing. (Sam Minnee)
 * 2012-10-09 [439339d](https://github.com/silverstripe/sapphire/commit/439339d) Broke up contributing docs into 4 sections and unified code contribtion guide. (Sam Minnee)
 * 2012-10-08 [832dae2](https://github.com/silverstripe/silverstripe-cms/commit/832dae2) Partially revert 90a154c888 (on JS files) (Ingo Schommer)
 * 2012-10-08 [ef0cd7b](https://github.com/silverstripe/sapphire/commit/ef0cd7b) Update docs/en/howto/extend-cms-interface.md (kentvv)
 * 2012-10-08 [ab065b4](https://github.com/silverstripe/sapphire/commit/ab065b4) Update docs/en/howto/simple-contact-form.md (Juan Molina)
 * 2012-10-07 [2c480ed](https://github.com/silverstripe/sapphire/commit/2c480ed) Update docs/en/reference/dataextension.md (Juan Molina)
 * 2012-10-05 [be13ba3](https://github.com/silverstripe/sapphire/commit/be13ba3) Removed 'built-in page controls' links from docs (Ingo Schommer)
 * 2012-10-05 [890bac8](https://github.com/silverstripe/sapphire/commit/890bac8) Docs: GridFieldDeleteAction (Ingo Schommer)
 * 2012-10-05 [7901b02](https://github.com/silverstripe/sapphire/commit/7901b02) Use TinyMCE fancy selects for better usability selecting styles (Sean Harvey)
 * 2012-10-02 [fe4f0c9](https://github.com/silverstripe/sapphire/commit/fe4f0c9) Markdown line endings (Ingo Schommer)
 * 2012-09-28 [b75c4b8](https://github.com/silverstripe/sapphire/commit/b75c4b8) Localization for PermissionCheckboxSetField (Ingo Schommer)
 * 2012-09-28 [d504e9e](https://github.com/silverstripe/sapphire/commit/d504e9e) Add .cms-tabset on all GridFieldDetailForm instances (Ingo Schommer)
 * 2012-09-28 [d50341d](https://github.com/silverstripe/sapphire/commit/d50341d) Rendering attributes for CMSTabSet.ss (Ingo Schommer)
 * 2012-09-28 [f991401](https://github.com/silverstripe/sapphire/commit/f991401) Translation possible for clear before import (Simon Erkelens)
 * 2012-09-27 [a86b54b](https://github.com/silverstripe/sapphire/commit/a86b54b) Update tutorial to include RSS feed API change. (Will Rossiter)
 * 2012-09-25 [69e9876](https://github.com/silverstripe/sapphire/commit/69e9876) Correct brush name in template docs to avoid js popup (Howard Grigg)
 * 2012-09-24 [8806fd1](https://github.com/silverstripe/sapphire/commit/8806fd1) Upgrading TinyMCE dependency from 3.5.6 to 3.5.7 (Sean Harvey)
 * 2012-09-23 [0df9b1c](https://github.com/silverstripe/sapphire/commit/0df9b1c) added CroppedImage (Anselm Christophersen)
 * 2012-09-21 [38f28de](https://github.com/silverstripe/silverstripe-cms/commit/38f28de) Adds Travis testing to the CMS (Simon Welsh)
 * 2012-09-19 [df44239](https://github.com/silverstripe/silverstripe-cms/commit/df44239) Method visibility according to coding conventions (Ingo Schommer)
 * 2012-09-19 [e2f073f](https://github.com/silverstripe/sapphire/commit/e2f073f) Method visibility according to coding conventions (Ingo Schommer)
 * 2012-09-19 [d0153f3](https://github.com/silverstripe/sapphire/commit/d0153f3) Write the test before ending it, so it still exists. (Simon Welsh)
 * 2012-09-19 [76373a4](https://github.com/silverstripe/silverstripe-cms/commit/76373a4) Remove ContentController view, moved functionality to Controller view (Will Rossiter)
 * 2012-09-19 [3fc928a](https://github.com/silverstripe/sapphire/commit/3fc928a) Include  in basic Controller view (Will Rossiter)
 * 2012-09-19 [b075fa2](https://github.com/silverstripe/sapphire/commit/b075fa2) Have tiny_mce_gzip.php use local silverstripe-cache folder if available (Sean Harvey)
 * 2012-09-19 [e0beca1](https://github.com/silverstripe/sapphire/commit/e0beca1) Added missing $tempPath argument (regression from last commit) (Sean Harvey)
 * 2012-09-19 [aa4fa75](https://github.com/silverstripe/sapphire/commit/aa4fa75) Consistently use the $base argument to getTempFolder() (Sean Harvey)
 * 2012-09-18 [7381cb4](https://github.com/silverstripe/sapphire/commit/7381cb4) Updated Template docs to include using backslash to escape (Howard Grigg)
 * 2012-09-18 [e509fb5](https://github.com/silverstripe/sapphire/commit/e509fb5) Tidy up RSSFeed docs based on community feedback. (Thanks Matt Howlett) (Will Rossiter)
 * 2012-09-18 [6ab04a6](https://github.com/silverstripe/sapphire/commit/6ab04a6) Refer to setColumns in deprecation message instead of non-existent setCols (Sean Harvey)
 * 2012-09-17 [71758c7](https://github.com/silverstripe/sapphire/commit/71758c7) ISSUE 7833: Invoke ShortcodeParser on RestfulServer output (Elliot Sawyer)
 * 2012-09-17 [a6f5b99](https://github.com/silverstripe/sapphire/commit/a6f5b99) Formatted warnings correctly (Sean Harvey)
 * 2012-09-15 [581da54](https://github.com/silverstripe/sapphire/commit/581da54) Updated default controller and template link to documentation (Peter Indiola)
 * 2012-09-15 [7f3f560](https://github.com/silverstripe/sapphire/commit/7f3f560) Update docs/en/topics/forms.md (Peter Indiola)
 * 2012-09-14 [758b4fd](https://github.com/silverstripe/sapphire/commit/758b4fd) Upgrading TinyMCE dependency to 3.5.6, and updating language packs. (Sean Harvey)
 * 2012-09-14 [a77d1b8](https://github.com/silverstripe/silverstripe-cms/commit/a77d1b8) Use HTML5 doctype for default ContentController template (Sean Harvey)
 * 2012-09-12 [1434190](https://github.com/silverstripe/sapphire/commit/1434190) Removed some line breaks for code blocks to render properly in the doc module (Anselm Christophersen)
 * 2012-09-11 [f5ff607](https://github.com/silverstripe/sapphire/commit/f5ff607) Localization for "cancel" button in GridFieldDetailForm (Ingo Schommer)
 * 2012-09-11 [83c608e](https://github.com/silverstripe/sapphire/commit/83c608e) Updated translations (Ingo Schommer)
 * 2012-09-11 [94c4061](https://github.com/silverstripe/silverstripe-cms/commit/94c4061) Updated translations (Ingo Schommer)
 * 2012-09-11 [20fead5](https://github.com/silverstripe/sapphire/commit/20fead5) DOCS - Correcting links to Roadmap and Changelog (Howard Grigg)
 * 2012-09-11 [b48a27b](https://github.com/silverstripe/sapphire/commit/b48a27b) Tweak IIS and SQL Server requirements in system requirements docs (Sean Harvey)
 * 2012-09-11 [42140d3](https://github.com/silverstripe/sapphire/commit/42140d3) Tweaking IIS and SQL Server requirements documentation (Sean Harvey)
 * 2012-09-11 [1aed488](https://github.com/silverstripe/sapphire/commit/1aed488) Simplify IIS installation instructions, refer to stable download (Sean Harvey)
 * 2012-09-11 [697d3db](https://github.com/silverstripe/sapphire/commit/697d3db) Removed SQLite from Travis build. (Sam Minnee)
 * 2012-09-10 [147bec5](https://github.com/silverstripe/sapphire/commit/147bec5) Rewrite the permission docs for IIS7. (Mateusz Uzdowski)
 * 2012-09-06 [dc4ccc7](https://github.com/silverstripe/sapphire/commit/dc4ccc7) delcared Email::is_valid_address($email) as public static to avoid strict notice ("Non-static method Email::is_valid_address() should not be called statically, assuming $this from incompatible context") (icecaster)
 * 2012-09-04 [a6f3e9f](https://github.com/silverstripe/sapphire/commit/a6f3e9f) Corrects replacement method name in deprecation notice. (Simon Welsh)

