# 3.1.0-beta3 #

## Overview ##

### CMS

 * New context action "Show children as list" on tree for better management on large sites
 * Display "last edited" and "last published" data for pages in CMS
 * More legible and simplified tab and menu styling in the CMS
 * Dropped support for Internet Explorer 7

### Framework

 * Static properties are immutable and private, you must use Config API
 * Statics in custom Page classes need to be "private"
 * `$default_cast` is now `Text` instead of `HTMLText`, to secure templates from XSS by default
 * Shortcodes are no longer supported in template files. They continue to work in DB fields and other
   HTMLText-cast fields.
 * `DataList` and `ArrayList` are now immutable, they'll return cloned instances on modification
 * Removed legacy table APIs (e.g. `TableListField`), use GridField instead
 * Deny URL access if `Controller::$allowed_actions` is undefined
 * Removed support for "*" rules in `Controller::$allowed_actions`
 * Removed support for overriding rules on parent classes through `Controller::$allowed_actions`
 * `RestfulService` verifies SSL peers by default
 * Optional integration with ImageMagick as a new image manipulation backend

## Upgrading

See [3.1.0 release notes](/changelogs/3.1.0)

## Changelog

### API Changes

 * 2013-04-11 [c8e8b51](https://github.com/silverstripe/sapphire/commit/c8e8b51) used call_user_func_array in order to have an arbitrary number of parameter for getFormattedImage (fixes #1752) (g4b0)
 * 2013-04-09 [14b997e](https://github.com/silverstripe/sapphire/commit/14b997e) Deprecated Object::add_extension() usage (as of 3.2) (Ingo Schommer)
 * 2013-04-07 [6a95db0](https://github.com/silverstripe/sapphire/commit/6a95db0) Support inequalities in templates (s-m)
 * 2013-04-06 [5238e9c](https://github.com/silverstripe/sapphire/commit/5238e9c) add onBeforeRollback() and onAfterRollback() hooks. (Will Rossiter)
 * 2013-04-06 [1fc780c](https://github.com/silverstripe/sapphire/commit/1fc780c) Return a 404 error when no director rule is matched (Andrew Short)
 * 2013-04-06 [cc09cce](https://github.com/silverstripe/silverstripe-cms/commit/cc09cce) remove static related classes, now staticpublisher module (Will Rossiter)
 * 2013-04-06 [6e2906d](https://github.com/silverstripe/silverstripe-cms/commit/6e2906d) remove static related classes, now staticpublisher module (Will Rossiter)
 * 2013-04-05 [ddb017a](https://github.com/silverstripe/sapphire/commit/ddb017a) Move LimitWordCount() to Varchar (Will Rossiter)
 * 2013-03-30 [5ec85d0](https://github.com/silverstripe/sapphire/commit/5ec85d0) Don't allow dots in URL segments (Andrew Short)
 * 2013-03-27 [e97c034](https://github.com/silverstripe/sapphire/commit/e97c034) i18n::$common_languages and i18n::$common_locales converted to Config API (Ingo Schommer)
 * 2013-03-27 [828ac7f](https://github.com/silverstripe/sapphire/commit/828ac7f) Replaced SSViewer.custom_theme with SSViewer.theme_enabled (Ingo Schommer)
 * 2013-03-21 [3334eaf](https://github.com/silverstripe/sapphire/commit/3334eaf) Marked statics private, use Config API instead (#8317) (Ingo Schommer)
 * 2013-03-18 [51c8e86](https://github.com/silverstripe/silverstripe-cms/commit/51c8e86) Marked statics private, use Config API instead (#8317) (Ingo Schommer)
 * 2013-03-12 [215628a](https://github.com/silverstripe/sapphire/commit/215628a) re factored Hierarchy class to use new ::get() syntax API: removed broken & unused method Hierarchy-&gt;partialTreeAsUL() (Zauberfisch)
 * 2013-03-12 [743a186](https://github.com/silverstripe/sapphire/commit/743a186) Make SSViewer#process return HTMLText not string (Hamish Friedlander)
 * 2013-03-12 [9bd6dd9](https://github.com/silverstripe/sapphire/commit/9bd6dd9) Make default_cast Text and not HTMLText (Hamish Friedlander)
 * 2013-03-12 [168f071](https://github.com/silverstripe/sapphire/commit/168f071) Make HTMLValue replace-able via DI (Hamish Friedlander)
 * 2013-03-08 [b81f39a](https://github.com/silverstripe/sapphire/commit/b81f39a) Handle uncaught ValidationException on CMS controller execution (Ingo Schommer)
 * 2013-02-27 [9258485](https://github.com/silverstripe/sapphire/commit/9258485) Adding setURL to HTTPRequest object (Daniel Hensby)
 * 2013-02-27 [e6fffb9](https://github.com/silverstripe/sapphire/commit/e6fffb9) Remove content-length setting in HTTPResponse (Ingo Schommer)
 * 2013-02-27 [600d9cf](https://github.com/silverstripe/sapphire/commit/600d9cf) Make Object::config use late static binding (Hamish Friedlander)
 * 2013-02-27 [904fd2d](https://github.com/silverstripe/sapphire/commit/904fd2d) Make Object::config use late static binding (Hamish Friedlander)
 * 2013-02-15 [2352317](https://github.com/silverstripe/silverstripe-installer/commit/2352317) Filter composer files in IIS and Apache rules (fixes #8011) (Ingo Schommer)
 * 2013-02-12 [10199f9](https://github.com/silverstripe/sapphire/commit/10199f9) Data corruption on Versioned due to lazy loading (Julian Seidenberg)
 * 2012-12-13 [becc5ba](https://github.com/silverstripe/silverstripe-installer/commit/becc5ba) Block all yaml files by default, to reduce the change of information leakage (Hamish Friedlander)

### Features and Enhancements

 * 2013-04-08 [f296439](https://github.com/silverstripe/sapphire/commit/f296439) Hints for scaffolded date/time fields (Ingo Schommer)
 * 2013-04-03 [6eda25a](https://github.com/silverstripe/sapphire/commit/6eda25a) Allow specifying the secure domain to Director::forceSSL() (Sean Harvey)
 * 2013-03-21 [dd6aaaf](https://github.com/silverstripe/sapphire/commit/dd6aaaf) Additional image generation functions now self-determine if a modification to the underlying image backend is necessary before generating additional image files. (Damian Mooyman)
 * 2013-03-19 [01f46d0](https://github.com/silverstripe/sapphire/commit/01f46d0) Enforce max node counts to avoid excessive resource usage (Ingo Schommer)
 * 2013-03-18 [5779097](https://github.com/silverstripe/sapphire/commit/5779097) Move temp data into a user-specific subfolder, to stop temp-permission bugs from occurring. (Sam Minnee)
 * 2013-03-14 [ec93643](https://github.com/silverstripe/silverstripe-cms/commit/ec93643) Set correct ParentID when creating page from list view (Ingo Schommer)
 * 2013-03-14 [1e1049b](https://github.com/silverstripe/silverstripe-cms/commit/1e1049b) "Show children as list" tree context action (Ingo Schommer)
 * 2013-03-12 [d2650bb](https://github.com/silverstripe/sapphire/commit/d2650bb) Disable shortcodes in $Layout and $Content in SSViewer (Hamish Friedlander)
 * 2013-03-12 [cd41a53](https://github.com/silverstripe/sapphire/commit/cd41a53) Let shortcodes be disabled in HTMLText & HTMLVarchar (Hamish Friedlander)
 * 2013-03-12 [2dd0e3f](https://github.com/silverstripe/silverstripe-cms/commit/2dd0e3f) Restored duplicate and duplicated with children functionality, as in 2.4 See ticket #7602 (jean)
 * 2013-03-05 [5af35a8](https://github.com/silverstripe/sapphire/commit/5af35a8) Allow multiline comments in SS3 templates (miiihi)
 * 2013-02-19 [82dc98b](https://github.com/silverstripe/sapphire/commit/82dc98b) fixed styling bug with the text in the file upload drop area and moved allowed extensions up a tad (Jeremy Bridson)
 * 2013-02-05 [083b6b2](https://github.com/silverstripe/sapphire/commit/083b6b2) Upload-&gt;replaceFile setting (Ingo Schommer)

### Bugfixes

 * 2013-04-18 [8d26bdb](https://github.com/silverstripe/sapphire/commit/8d26bdb) We still need XML escaping on href attributes in HTML4Value (Hamish Friedlander)
 * 2013-04-17 [4d70daa](https://github.com/silverstripe/sapphire/commit/4d70daa) HiddenFields and VisibleFields should always return extraFields (uniun)
 * 2013-04-12 [685b82a](https://github.com/silverstripe/silverstripe-cms/commit/685b82a) #673 Do not prevent default browser behaviour when selecting page type on new page creation (jean)
 * 2013-04-12 [0dfc6d5](https://github.com/silverstripe/sapphire/commit/0dfc6d5) Fixed incorrect variable usage in generation of PhoneNumberField form fields (Damian Mooyman)
 * 2013-04-10 [29e6bd5](https://github.com/silverstripe/sapphire/commit/29e6bd5) Allow empty else- and else_if-blocks (s-m)
 * 2013-04-10 [9da57b0](https://github.com/silverstripe/sapphire/commit/9da57b0) Fixed broken ErrorPage icons in CMS view (Damian Mooyman)
 * 2013-04-09 [975c699](https://github.com/silverstripe/sapphire/commit/975c699) Edge case attempting to destroy uninitialized tabs (Loz Calver)
 * 2013-04-08 [da515b8](https://github.com/silverstripe/silverstripe-cms/commit/da515b8) Use SSViewer.theme_enabled in CMS logic (Ingo Schommer)
 * 2013-04-08 [c18f3fe](https://github.com/silverstripe/silverstripe-cms/commit/c18f3fe) Use onadd instead of onmatch on cms-add-form when creating new page #673 (jean)
 * 2013-04-07 [7881f60](https://github.com/silverstripe/sapphire/commit/7881f60) nested SelectionGroups should only hide first level (Will Rossiter)
 * 2013-04-06 [e619329](https://github.com/silverstripe/sapphire/commit/e619329) Decimal field change detection. (Will Rossiter)
 * 2013-04-06 [6972222](https://github.com/silverstripe/sapphire/commit/6972222) Ensure FieldList::push() doesn't eliminate key (Will Rossiter)
 * 2013-04-06 [1427a06](https://github.com/silverstripe/sapphire/commit/1427a06) remove_extension should work on parameterized extensions (Will Rossiter)
 * 2013-04-05 [acf2ff8](https://github.com/silverstripe/sapphire/commit/acf2ff8) Fix for #1487 (s-m)
 * 2013-04-05 [65cb182](https://github.com/silverstripe/sapphire/commit/65cb182) Don't sort when deleting records in ManyManyList::removeAll() (Sean Harvey)
 * 2013-04-05 [cfafa19](https://github.com/silverstripe/sapphire/commit/cfafa19) Disallow group removal when member is edited in groups view (Ingo Schommer)
 * 2013-04-05 [5119d9a](https://github.com/silverstripe/sapphire/commit/5119d9a) Only allow one concurrent ajax in TreeDropdownField (Ingo Schommer)
 * 2013-04-04 [da87614](https://github.com/silverstripe/sapphire/commit/da87614) Skip autofocus on TreeDropdownField (Ingo Schommer)
 * 2013-04-03 [6d59257](https://github.com/silverstripe/sapphire/commit/6d59257) Empty fields on SQLQuery-&gt;aggregate() with alias (Ingo Schommer)
 * 2013-04-02 [5a8a067](https://github.com/silverstripe/sapphire/commit/5a8a067) Consistently quote orderby in DataQuery-&gt;ensureSelectContainsOrderbyColumns() (Ingo Schommer)
 * 2013-04-01 [df4d742](https://github.com/silverstripe/sapphire/commit/df4d742) Saving of custom meta tags (fixes #8288) (Joseph Madden)
 * 2013-03-29 [3aced11](https://github.com/silverstripe/sapphire/commit/3aced11) GridFieldFilterHeader only filters on last filter (Stig Lindqvist)
 * 2013-03-28 [ff3b63f](https://github.com/silverstripe/sapphire/commit/ff3b63f) Remove unnecessary DISTINCT from ManyManyList-&gt;removeAll() (Ingo Schommer)
 * 2013-03-29 [f2b4b95](https://github.com/silverstripe/sapphire/commit/f2b4b95) Set ModelAdmin tab targets to avoid creating new panels (Andrew Short)
 * 2013-03-27 [c63d840](https://github.com/silverstripe/sapphire/commit/c63d840) fixed access to asset_preview_width in getFieldsForImage (g4b0)
 * 2013-03-27 [7121fc3](https://github.com/silverstripe/sapphire/commit/7121fc3) Config isolation in Director::test() (Ingo Schommer)
 * 2013-03-27 [f73a5c6](https://github.com/silverstripe/silverstripe-cms/commit/f73a5c6) VirtualPageTest memory errors due to Config API quirks (Ingo Schommer)
 * 2013-03-27 [19a8545](https://github.com/silverstripe/sapphire/commit/19a8545) update deprecated 'live' jquery to 'on' (Naomi Guyer)
 * 2013-03-26 [a415db9](https://github.com/silverstripe/sapphire/commit/a415db9) Clone Config_LRU incl. objects in array (Ingo Schommer)
 * 2013-03-26 [70144ad](https://github.com/silverstripe/sapphire/commit/70144ad) Groups should be able to have titles longer than 50 characters (Fixes: open/5611) (Will Rossiter)
 * 2013-03-25 [0ebd525](https://github.com/silverstripe/silverstripe-cms/commit/0ebd525) Unset "underneath page" title when switching to "top" in "add page" (Ingo Schommer)
 * 2013-03-25 [3f2b6a5](https://github.com/silverstripe/sapphire/commit/3f2b6a5) Don't silently unset ParentID in "add page" dialog (Ingo Schommer)
 * 2013-03-25 [0a283ea](https://github.com/silverstripe/sapphire/commit/0a283ea) Unset internal metadata on TreeDropdownField setValue() (Ingo Schommer)
 * 2013-03-25 [07d99a5](https://github.com/silverstripe/sapphire/commit/07d99a5) Fallback for Session.cookie_path (Ingo Schommer)
 * 2013-03-25 [fbb4d1c](https://github.com/silverstripe/silverstripe-installer/commit/fbb4d1c) Update Page/Page_Controller statics to match new 3.1 expectations. (Sam Minnee)
 * 2013-03-24 [27b0cda](https://github.com/silverstripe/sapphire/commit/27b0cda) Localized HtmlEditorField Tabs (a2nt)
 * 2013-03-24 [9b9f367](https://github.com/silverstripe/sapphire/commit/9b9f367) Database config values aren't escaped (Stephen Shkardoon)
 * 2013-03-22 [d3e4863](https://github.com/silverstripe/sapphire/commit/d3e4863) Incorrect parsing of T_STRING values in class spec parsing (Andrew Short)
 * 2013-03-22 [47edbfe](https://github.com/silverstripe/sapphire/commit/47edbfe) ConfigStaticManifest persisting access level after parsing a static (Hamish Friedlander)
 * 2013-03-21 [69ae1f3](https://github.com/silverstripe/sapphire/commit/69ae1f3) Clean cache on Config-&gt;remove() (Ingo Schommer)
 * 2013-03-21 [bb52f2a](https://github.com/silverstripe/sapphire/commit/bb52f2a) Allow FALSE in Config API, call remove() will NULL key on update() (Ingo Schommer)
 * 2013-03-20 [2787d36](https://github.com/silverstripe/sapphire/commit/2787d36) "Insert Link" and other TinyMCE loading bugs (fixes #8327) (Ingo Schommer)
 * 2013-03-20 [143317c](https://github.com/silverstripe/sapphire/commit/143317c) SQL Injection in CsvBulkLoader (fixes #6227) (Stephen Shkardoon)
 * 2013-03-19 [0d57f7b](https://github.com/silverstripe/sapphire/commit/0d57f7b) processAll method respects $preview flag (Daniel Hensby)
 * 2013-03-19 [3020576](https://github.com/silverstripe/sapphire/commit/3020576) Adding preview method to CsvBulkLoader (Daniel Hensby)
 * 2013-03-19 [9ac104b](https://github.com/silverstripe/sapphire/commit/9ac104b) $_COOKIES is not un-magic_quotes'd (Stephen Shkardoon)
 * 2013-03-19 [d9f4a36](https://github.com/silverstripe/sapphire/commit/d9f4a36) #8328 Expose previously selected values of TreeMultiSelectField so they are not wipped out when selecting more values at an higher level in hierarchy (jean)
 * 2013-03-18 [5c933b4](https://github.com/silverstripe/silverstripe-cms/commit/5c933b4) SilverStripeNavigator shows wrong message. (uniun)
 * 2013-03-18 [3543a93](https://github.com/silverstripe/sapphire/commit/3543a93) SplFixedArray causes segfaults in old versions of PHP (Hamish Friedlander)
 * 2013-03-18 [59e66f3](https://github.com/silverstripe/silverstripe-cms/commit/59e66f3) Ticket #8318 Append the HTML used for expanding/collapsing the site tree column in template instead of creating it on the fly with js (jean)
 * 2013-03-15 [cd27bf7](https://github.com/silverstripe/sapphire/commit/cd27bf7) Enforced requirement that ValidationException::getResult() is expected to consistently produce a valid ValidationResult object. (Damian Mooyman)
 * 2013-03-15 [412f58b](https://github.com/silverstripe/sapphire/commit/412f58b) #8322 Use POST instead of GET when using LeftAndMain::savetreenode so large site trees can be reorganised as well (jean)
 * 2013-03-14 [746904c](https://github.com/silverstripe/sapphire/commit/746904c) Respect previous tab choices in CMS on load (Ingo Schommer)
 * 2013-03-13 [53595dc](https://github.com/silverstripe/sapphire/commit/53595dc) Parsing docblock comments in ConfigStaticManifest (Hamish Friedlander)
 * 2013-03-13 [60b72ed](https://github.com/silverstripe/sapphire/commit/60b72ed) Parsing heredoc, nowdoc & comments in ConfigStaticManifest (Hamish Friedlander)
 * 2013-03-13 [2ba26ba](https://github.com/silverstripe/silverstripe-cms/commit/2ba26ba) 8316 Prevents browser default behaviour when changing the pagetypes if creating a new page (jean)
 * 2013-03-12 [dd6f33a](https://github.com/silverstripe/sapphire/commit/dd6f33a) Respect tree node limits, fix search result node display (Ingo Schommer)
 * 2013-03-12 [e6352df](https://github.com/silverstripe/sapphire/commit/e6352df) Static polution with informational fields (Hamish Friedlander)
 * 2013-03-12 [7f58730](https://github.com/silverstripe/sapphire/commit/7f58730) Avoid get_parent_class in ConfigStaticManifest (was loading all classes) (Hamish Friedlander)
 * 2013-03-11 [bb30c1e](https://github.com/silverstripe/sapphire/commit/bb30c1e) Preserve alpha channel when cropping (Fred Condo)
 * 2013-03-12 [252e6bc](https://github.com/silverstripe/sapphire/commit/252e6bc) Make multiple TemplateManifests not corrupt each other (Hamish Friedlander)
 * 2013-03-11 [2f16951](https://github.com/silverstripe/sapphire/commit/2f16951) ampersand escaping (g4b0)
 * 2013-03-09 [a965d3b](https://github.com/silverstripe/sapphire/commit/a965d3b) Fix grid field rendering when the list is null (ajshort)
 * 2013-03-07 [00d01aa](https://github.com/silverstripe/sapphire/commit/00d01aa) fixed file icon for uppercase file extensions (Zauberfisch)
 * 2013-03-07 [13b7386](https://github.com/silverstripe/sapphire/commit/13b7386) Removed XHTML XML declaration requirement (g4b0)
 * 2013-03-02 [b537ee2](https://github.com/silverstripe/sapphire/commit/b537ee2) Fix ManyManyList-&gt;removeAll() when filters are applied to the query (ajshort)
 * 2013-03-01 [9a1ccd8](https://github.com/silverstripe/sapphire/commit/9a1ccd8) Prevent opening preview when clicking the link for current page again (Loz Calver)
 * 2013-02-27 [eb2e0d7](https://github.com/silverstripe/silverstripe-cms/commit/eb2e0d7) Request object now has URL changed (Daniel Hensby)
 * 2013-02-27 [68ebc5d](https://github.com/silverstripe/silverstripe-cms/commit/68ebc5d) CMSMainTest to access batch_action config property properly (Hamish Friedlander)
 * 2013-02-27 [80bd38e](https://github.com/silverstripe/sapphire/commit/80bd38e) DataObjectSchemaGenerationTest trying to modify config statics directly (Hamish Friedlander)
 * 2013-02-26 [a8a10f8](https://github.com/silverstripe/sapphire/commit/a8a10f8) Transaction stub methods for better cross 2.x and 3.x compat (Ingo Schommer)
 * 2013-02-20 [a03d1e6](https://github.com/silverstripe/sapphire/commit/a03d1e6) CMS messages touch the bottom of the inputs (Daniel Hensby)
 * 2013-02-20 [a193666](https://github.com/silverstripe/sapphire/commit/a193666) handleAction methods should be protected now (Hamish Friedlander)
 * 2013-02-19 [4e36020](https://github.com/silverstripe/sapphire/commit/4e36020) UnsavedRelationList aren't checked (Daniel Hensby)
 * 2013-02-19 [1cf2259](https://github.com/silverstripe/sapphire/commit/1cf2259) Undefined var (Daniel Hensby)
 * 2013-02-18 [16d0c18](https://github.com/silverstripe/sapphire/commit/16d0c18) Find Form actions in CompositeFields for access checks (Ingo Schommer)
 * 2013-02-18 [8d32ae9](https://github.com/silverstripe/sapphire/commit/8d32ae9) setBody on SS_HTTPRequest is a function (Daniel Hensby)
 * 2013-02-17 [c7b0666](https://github.com/silverstripe/silverstripe-cms/commit/c7b0666) Escape page titles in CommentAdmin table listing (Ingo Schommer)
 * 2013-02-07 [54bc18b](https://github.com/silverstripe/sapphire/commit/54bc18b) fix for broken layout in insert media dialog - Trac #8232 (Jeremy Bridson)
 * 2013-01-15 [50995fb](https://github.com/silverstripe/sapphire/commit/50995fb) Undefined `$allowed_actions` overrides parent definitions, stricter handling of $allowed_actions on Extension (Ingo Schommer)
 * 2013-01-14 [f7cd316](https://github.com/silverstripe/sapphire/commit/f7cd316) Versioned_Version-&gt;relField() so fields can be used in GridField etc (Ingo Schommer)
 * 2013-01-06 [eecd348](https://github.com/silverstripe/sapphire/commit/eecd348) Keep Member.PasswordEncryption setting on empty passwords (Ingo Schommer)
 * 2012-10-10 [e2bf964](https://github.com/silverstripe/sapphire/commit/e2bf964) 7934 When lazy loading fields respect version of the record (jean)
 * 2012-10-05 [1ffbb8f](https://github.com/silverstripe/sapphire/commit/1ffbb8f) Exclude framework/dev from text collection (fixes #4754) (Ingo Schommer)
 * 2012-09-10 [17bd873](https://github.com/silverstripe/sapphire/commit/17bd873) 7853 Flush the content of drop down fields when closing html editor linker (links and images) (jean)