# 3.1.0-beta1 (unreleased) #

## Overview ##

### CMS

 * "Split view" editing with side-by-side preview of the edited website
 * Resizing of preview to common screen widths ("desktop", "tablet" and "smartphone")
 * Decluttered "Edit Page" buttons by moving minor actions into a "more options" panel
 * Auto-detect CMS changes and highlight the save button for better informancy
 * Display "last edited" and "last published" data for pages in CMS
 * CMS form fields now support help text through `setDescription()`, both inline and as tooltips
 * More legible and simplified tab and menu styling in the CMS

### Framework

 * `DataList` and `ArrayList` are now immutable, they'll return cloned instances on modification
 * Behaviour testing support through [Behat](http://behat.org), with CMS test coverage 
   (see the [SilverStripe Behat Extension]() for details)
 * Removed legacy table APIs (e.g. `TableListField`), use GridField instead
 * Editing of relation table data (`$many_many_extraFields`) in `GridField`
 * Optional integration with ImageMagick as a new image manipulation backend
 * Support for PHP 5.4's built-in webserver

## Upgrading

See [3.1.0 release notes](/changelogs/3.1.0)

## Changelog

### API Changes

 * 2012-12-17 [bbc8e06](https://github.com/silverstripe/sapphire/commit/bbc8e06) Show GridFieldEditButton even without edit permissions (for readonly forms) (Ingo Schommer)
 * 2012-12-17 [1848d7e](https://github.com/silverstripe/sapphire/commit/1848d7e) Check model permissions in GridField (Ingo Schommer)
 * 2012-12-14 [644cc79](https://github.com/silverstripe/sapphire/commit/644cc79) Removed methods previously deprecated in 3.0 (Ingo Schommer)
 * 2012-12-13 [6f9d01f](https://github.com/silverstripe/sapphire/commit/6f9d01f) FormField-&gt;setDescription() visible in default template (Ingo Schommer)
 * 2012-12-13 [559abec](https://github.com/silverstripe/sapphire/commit/559abec) Copying instance props on FormField readonly/disabled transformations (Ingo Schommer)
 * 2012-12-13 [2e164ea](https://github.com/silverstripe/silverstripe-cms/commit/2e164ea) Report::get_reports() returns native array (fixes #8096) (Ingo Schommer)
 * 2012-12-12 [27113f8](https://github.com/silverstripe/sapphire/commit/27113f8) Make DataList and ArrayList immutable (Hamish Friedlander)
 * 2012-12-10 [e6e47cb](https://github.com/silverstripe/sapphire/commit/e6e47cb) DB-specific comparisators in SearchFilter and DataList (Ingo Schommer)
 * 2012-12-11 [4d6d823](https://github.com/silverstripe/sapphire/commit/4d6d823) Allow ignoring persistent tab state through entwine property. (Mateusz Uzdowski)
 * 2012-12-04 [4fa2b0f](https://github.com/silverstripe/sapphire/commit/4fa2b0f) Support disabling/enabling of previews. (Mateusz Uzdowski)
 * 2012-12-03 [5fed5b9](https://github.com/silverstripe/sapphire/commit/5fed5b9) Moved email bounce handling to new 'emailbouncehandler' module (Ingo Schommer)
 * 2012-12-03 [fb076c0](https://github.com/silverstripe/sapphire/commit/fb076c0) Deprecated global email methods, moved to Mailer class (Ingo Schommer)
 * 2012-11-30 [548ad50](https://github.com/silverstripe/sapphire/commit/548ad50) Removed keyed arrays for title/value setting in SelectionGroup (Ingo Schommer)
 * 2012-11-29 [8f5acd7](https://github.com/silverstripe/sapphire/commit/8f5acd7) Move state to enwtine properties, provide API for preview. (Mateusz Uzdowski)
 * 2012-11-29 [47f41d8](https://github.com/silverstripe/silverstripe-cms/commit/47f41d8) Machine-friendly name for CMS states navigator (stages). (Mateusz Uzdowski)
 * 2012-11-26 [d4f13fe](https://github.com/silverstripe/sapphire/commit/d4f13fe) Refactor the CMS layouting to provide access to options. (Mateusz Uzdowski)
 * 2012-11-22 [fe08236](https://github.com/silverstripe/sapphire/commit/fe08236) Add action tabsets as a interface idiom. (Mateusz Uzdowski)
 * 2012-11-22 [26cc14a](https://github.com/silverstripe/silverstripe-cms/commit/26cc14a) Rework the CMS actions to use alternating buttons and drop-ups. (Mateusz Uzdowski)
 * 2012-11-15 [8b0bb8d](https://github.com/silverstripe/sapphire/commit/8b0bb8d) Replace deprecated FormField::createTag() with static create_tag() (Sean Harvey)
 * 2012-11-07 [b02b1e6](https://github.com/silverstripe/sapphire/commit/b02b1e6) Forward the editor events to underlying textarea. (Mateusz Uzdowski)
 * 2012-11-02 [683db8d](https://github.com/silverstripe/sapphire/commit/683db8d) Explicitly load project template files after modules (Will Rossiter)
 * 2012-10-30 [d54b1b4](https://github.com/silverstripe/sapphire/commit/d54b1b4) Removed permission checks from XML/JSON data formatters (Ingo Schommer)
 * 2012-10-12 [a3295e2](https://github.com/silverstripe/sapphire/commit/a3295e2) File-&gt;canEdit() returns TRUE by default (not checking CMS perms) (Ingo Schommer)
 * 2012-10-10 [b31188f](https://github.com/silverstripe/silverstripe-cms/commit/b31188f) Use late static binding for Object::has_extension() (Andrew O'Neil)
 * 2012-10-10 [0c8de0a](https://github.com/silverstripe/sapphire/commit/0c8de0a) Use late static binding for Object::has_extension() (Andrew O'Neil)
 * 2012-10-10 [48a9bcf](https://github.com/silverstripe/silverstripe-cms/commit/48a9bcf) Use late static binding for Object::remove_extension() (Andrew O'Neil)
 * 2012-10-10 [6dd6a5c](https://github.com/silverstripe/sapphire/commit/6dd6a5c) Use late static binding for Object::remove_extension() (Andrew O'Neil)
 * 2012-10-09 [1722f00](https://github.com/silverstripe/silverstripe-cms/commit/1722f00) add_extension() is now called directly on the class, instead of on Object (Andrew O'Neil)
 * 2012-10-09 [fdea532](https://github.com/silverstripe/sapphire/commit/fdea532) add_extension() is now called directly on the class, instead of on Object (Andrew O'Neil)
 * 2012-09-27 [39952f4](https://github.com/silverstripe/sapphire/commit/39952f4) Added 'onBeforeHTTPError' and 'onBeforeHTTPError&lt;code&gt;' extension points to RequestHandler::httpError(). (Sam Minnee)
 * 2012-09-26 [aa6f345](https://github.com/silverstripe/sapphire/commit/aa6f345) FormField::name_to_label() for unlabelled fields (Howard Grigg)
 * 2012-09-21 [cbd31e3](https://github.com/silverstripe/silverstripe-cms/commit/cbd31e3) Removed SiteTree.MetaTitle and MetaKeywords (Ingo Schommer)
 * 2012-09-21 [a3007b6](https://github.com/silverstripe/silverstripe-cms/commit/a3007b6) moved StaticCache / StaticPublisher to module. (Will Rossiter)
 * 2012-09-21 [e72114d](https://github.com/silverstripe/sapphire/commit/e72114d) Remove static main and dev/buildcache (Will Rossiter)
 * 2012-09-20 [6d696d5](https://github.com/silverstripe/sapphire/commit/6d696d5) Allow subgroups in the WHERE clause of a Data/SQLQuery (Simon Welsh)
 * 2012-09-20 [c49f756](https://github.com/silverstripe/sapphire/commit/c49f756) Allow use of :not, :nocase and :case modifiers to SearchFilters. (Simon Welsh)
 * 2012-09-06 [79b3f8a](https://github.com/silverstripe/sapphire/commit/79b3f8a) Add exclude() method to SearchFilters that excludes items that match the filter. (Simon Welsh)
 * 2012-09-06 [2faf7d1](https://github.com/silverstripe/sapphire/commit/2faf7d1) Allow using SearchFilters in DataList::exclude() (Simon Welsh)
 * 2012-07-05 [0fe515e](https://github.com/silverstripe/sapphire/commit/0fe515e) Deprecated Profiler class, removed related debug GET params (Ingo Schommer)
 * 2012-06-30 [78fdcc5](https://github.com/silverstripe/sapphire/commit/78fdcc5) DataList-&gt;leftJoin()/innerJoin() args no longer escaped (Simon Welsh)

### Features and Enhancements

 * 2012-12-13 [7e46290](https://github.com/silverstripe/sapphire/commit/7e46290) Date-&gt;Ago() with "less than a minute" support (Ingo Schommer)
 * 2012-12-13 [1ca3883](https://github.com/silverstripe/sapphire/commit/1ca3883) Tooltip and inline help text support for CMS form fields (Ingo Schommer)
 * 2012-11-22 [f4b080e](https://github.com/silverstripe/sapphire/commit/f4b080e) Side by side editing functionality - first cut (os#7412) (Mateusz Uzdowski)
 * 2012-11-15 [639f6e4](https://github.com/silverstripe/silverstripe-cms/commit/639f6e4) Side by side editing functionality - first cut (os#7412) (Naomi Guyer)
 * 2012-11-08 [c8136f5](https://github.com/silverstripe/sapphire/commit/c8136f5) Many-many relation data editing in GridFieldDetailForm (Ingo Schommer)
 * 2012-11-06 [a52514a](https://github.com/silverstripe/silverstripe-cms/commit/a52514a) Tab style consolidation and design consistency (Ingo Schommer)
 * 2012-11-06 [2d07567](https://github.com/silverstripe/sapphire/commit/2d07567) Tab style consolidation and design consistency (Ingo Schommer)
 * 2012-11-06 [dbbcd08](https://github.com/silverstripe/sapphire/commit/dbbcd08) Extend the ssui.button with alternate appearances. (Mateusz Uzdowski)
 * 2012-11-05 [411673e](https://github.com/silverstripe/sapphire/commit/411673e) general css enhancements (Paul Clarke)
 * 2012-11-03 [bbc4443](https://github.com/silverstripe/sapphire/commit/bbc4443) Allows setting of has_many and many_many relations before writing (Simon Welsh)
 * 2012-11-02 [26e5afc](https://github.com/silverstripe/sapphire/commit/26e5afc) Add new method "each" to SS_List and core implementors thereof (Justin Martin)
 * 2012-10-24 [d24b586](https://github.com/silverstripe/sapphire/commit/d24b586) Enable multiple image manipulation back-ends on the Image class (Justin Martin)
 * 2012-10-12 [5be3a4c](https://github.com/silverstripe/sapphire/commit/5be3a4c) DataList-&gt;filterAny() (Ingo Schommer)
 * 2012-10-08 [1711303](https://github.com/silverstripe/silverstripe-cms/commit/1711303) Enable SiteTree::$nested_urls by default (Ingo Schommer)
 * 2012-10-08 [38e7df2](https://github.com/silverstripe/sapphire/commit/38e7df2) Enable SiteTree::$nested_urls by default (Ingo Schommer)
 * 2012-10-05 [76e569a](https://github.com/silverstripe/silverstripe-cms/commit/76e569a) open/7886 added preview button to the settings page so that when a user changes the theme they can preview the change. (Jeremy Bridson)
 * 2012-10-05 [ad7383a](https://github.com/silverstripe/sapphire/commit/ad7383a) open/7886 added preview button to the settings page so that when a user changes the theme they can preview the change. (Jeremy Bridson)
 * 2012-10-04 [8108f7f](https://github.com/silverstripe/sapphire/commit/8108f7f) Relation search for GridFieldAddExistingAutocompleter (Ingo Schommer)
 * 2012-09-20 [a670e4c](https://github.com/silverstripe/sapphire/commit/a670e4c) open/7875 - added help labels to metadata fields on page content edit screen. (Jeremy Bridson)
 * 2012-09-20 [05d5bd7](https://github.com/silverstripe/silverstripe-cms/commit/05d5bd7) open/7875 - added help labels to metadata fields on page content edit screen. (Jeremy Bridson)
 * 2012-09-11 [1005571](https://github.com/silverstripe/sapphire/commit/1005571) Added support for PHP 5.4's built-in webserver. (Sam Minnee)
 * 2012-07-23 [f1db583](https://github.com/silverstripe/sapphire/commit/f1db583) Allow arguments to be passed to allowed_action checkers (Simon Welsh)
 * 2012-07-15 [6e2d6c2](https://github.com/silverstripe/sapphire/commit/6e2d6c2) Hide the search bar in Chosen dropdown fields when list is reasonably short. (unclecheese)
 * 2012-06-29 [ebb2458](https://github.com/silverstripe/sapphire/commit/ebb2458) Improving Cookie class to allow for extendability (Matt Lewis)

### Bugfixes

 * 2012-12-17 [6028cf1](https://github.com/silverstripe/sapphire/commit/6028cf1) ed panel spacing regressions from 544d2eb6 (Ingo Schommer)
 * 2012-12-17 [cc536f6](https://github.com/silverstripe/silverstripe-cms/commit/cc536f6) ed "last edited" display in CMS actions (Ingo Schommer)
 * 2012-12-17 [a823c38](https://github.com/silverstripe/sapphire/commit/a823c38) ed JS syntax error (Ingo Schommer)
 * 2012-12-16 [bf5590d](https://github.com/silverstripe/sapphire/commit/bf5590d) Fix side-by-side initial icon display issue in IE8. (Mateusz Uzdowski)
 * 2012-12-16 [8455686](https://github.com/silverstripe/sapphire/commit/8455686) Fix the re-layouting not being triggered in IE8. (Mateusz Uzdowski)
 * 2012-12-15 [22eeaa4](https://github.com/silverstripe/sapphire/commit/22eeaa4) Members should not be allowed to delete themselves (fixes #8121) (Ingo Schommer)
 * 2012-12-15 [b365714](https://github.com/silverstripe/sapphire/commit/b365714) Remove "delete" button from "My Profile" (fixes #8121) (Ingo Schommer)
 * 2012-12-15 [c2d31e5](https://github.com/silverstripe/silverstripe-cms/commit/c2d31e5) Hiding group selections in "Settings" (Ingo Schommer)
 * 2012-12-14 [d2c1d53](https://github.com/silverstripe/sapphire/commit/d2c1d53) ed UploadField-&gt;setDescription() handlgin (Ingo Schommer)
 * 2012-12-14 [74d6379](https://github.com/silverstripe/silverstripe-cms/commit/74d6379) ed regression in SiteTree-&gt;getCMSActions() (Ingo Schommer)
 * 2012-12-13 [a355e1d](https://github.com/silverstripe/sapphire/commit/a355e1d) Set visibility on login form methods to public. (Justin Martin)
 * 2012-12-13 [006790b](https://github.com/silverstripe/sapphire/commit/006790b) ed IE7 GridField "add row" alignment issue (Ingo Schommer)
 * 2012-12-13 [0ba51c1](https://github.com/silverstripe/sapphire/commit/0ba51c1) to allow buttons to align inline (fixes #8099) (Paul Clarke)
 * 2012-12-13 [bdc3e91](https://github.com/silverstripe/sapphire/commit/bdc3e91) ed wrong floating on GridField certain buttons (Ingo Schommer)
 * 2012-12-13 [bd59f84](https://github.com/silverstripe/sapphire/commit/bd59f84) Make sure you can only remove items from a DataList that are actually in it (Hamish Friedlander)
 * 2012-12-13 [9979b11](https://github.com/silverstripe/sapphire/commit/9979b11) Make sure ArrayList#limit uses clone so for subclasses it returns instances of same subclass (Hamish Friedlander)
 * 2012-12-12 [546762e](https://github.com/silverstripe/silverstripe-cms/commit/546762e) use of DataList#innerJoin expecting it to be mutable (Hamish Friedlander)
 * 2012-12-12 [c0a1226](https://github.com/silverstripe/sapphire/commit/c0a1226) fix and code clean up (Paul Clarke)
 * 2012-12-12 [5d93f8d](https://github.com/silverstripe/sapphire/commit/5d93f8d) fix preview note "Website preview" (Paul Clarke)
 * 2012-12-11 [0f60ca7](https://github.com/silverstripe/sapphire/commit/0f60ca7) Confirmed Password Field now copies attributes to child fields. (Justin Martin)
 * 2012-12-11 [9803459](https://github.com/silverstripe/sapphire/commit/9803459) ed SelectionGroupTest (Ingo Schommer)
 * 2012-12-10 [084acc0](https://github.com/silverstripe/silverstripe-cms/commit/084acc0) ed Behat tests for preview feature (Ingo Schommer)
 * 2012-12-10 [0fd6d14](https://github.com/silverstripe/sapphire/commit/0fd6d14) ed Behat steps for preview feature (Ingo Schommer)
 * 2012-12-04 [4d106aa](https://github.com/silverstripe/sapphire/commit/4d106aa) Fixed unintentional ParentID reset in "add page" form (Ingo Schommer)
 * 2012-12-04 [b8c656b](https://github.com/silverstripe/sapphire/commit/b8c656b) ed cms extension docs to remove zzz_admin workaround (Ingo Schommer)
 * 2012-12-04 [65002f6](https://github.com/silverstripe/sapphire/commit/65002f6) GD::greyscale did not correctly preserve alpha component of images Added test cases to test greyscale operation across various image formats Replaced various magic numbers with IMAGETYPE_XXX definitions (Damian Mooyman)
 * 2012-12-03 [f9a5601](https://github.com/silverstripe/silverstripe-cms/commit/f9a5601) Enforce "add page" restrictions, improve UI (fixes #7879) (Ingo Schommer)
 * 2012-12-03 [a63a9f0](https://github.com/silverstripe/silverstripe-cms/commit/a63a9f0) removed class cms-panel-link as it was calling loadPanel to be called twice trac 8041 (Kirk Mayo)
 * 2012-12-03 [da1a6e7](https://github.com/silverstripe/sapphire/commit/da1a6e7) Unable to return to site tree admin from Preview mode trac 8063 (Kirk Mayo)
 * 2012-11-30 [0808a1c](https://github.com/silverstripe/sapphire/commit/0808a1c) ed JS syntax error (Ingo Schommer)
 * 2012-11-30 [dbaf407](https://github.com/silverstripe/sapphire/commit/dbaf407) ed help text alignment for checkbox and grid fields (Ingo Schommer)
 * 2012-11-30 [2614171](https://github.com/silverstripe/sapphire/commit/2614171) Deep cloning for DateTimeField (Ingo Schommer)
 * 2012-11-30 [20a5bc1](https://github.com/silverstripe/sapphire/commit/20a5bc1) iOS safari navigation bug (fixes #8039) (Kirk Mayo)
 * 2012-11-29 [7d0e10f](https://github.com/silverstripe/sapphire/commit/7d0e10f) Extends too generic (Naomi Guyer)
 * 2012-11-27 [414c006](https://github.com/silverstripe/sapphire/commit/414c006) Restore GD class to avoid breaking GD::set_default_quality() calls (Ingo Schommer)
 * 2012-11-26 [670c579](https://github.com/silverstripe/silverstripe-cms/commit/670c579) Namespaces for CmsFormsContext and CmsUiContext are wrong (Kirk Mayo)
 * 2012-11-23 [76b99e4](https://github.com/silverstripe/silverstripe-cms/commit/76b99e4) ed tests without assertions (Ingo Schommer)
 * 2012-11-16 [4651e9b](https://github.com/silverstripe/sapphire/commit/4651e9b) Fixing ToggleField to work correctly with jQuery (Sean Harvey)
 * 2012-11-15 [94b37db](https://github.com/silverstripe/silverstripe-cms/commit/94b37db) ing AssetAdmin to use static FormField::create_tag() (Sean Harvey)
 * 2012-11-15 [1edfeef](https://github.com/silverstripe/sapphire/commit/1edfeef) Remove extraneous layout calls. (Mateusz Uzdowski)
 * 2012-11-12 [4fab9b8](https://github.com/silverstripe/silverstripe-cms/commit/4fab9b8) Incorrect html nesting of breadcrumbs (Naomi Guyer)
 * 2012-11-12 [a933847](https://github.com/silverstripe/sapphire/commit/a933847) Incorrect html nesting of breadcrumbs (Naomi Guyer)
 * 2012-11-12 [9d74c99](https://github.com/silverstripe/sapphire/commit/9d74c99) ArrayList now discards keys of the array passed in and keeps the numerically indexed array sequential. This fixes FirstLast and EvenOdd in templates, and makes ArrayList more consistent, as several methods already discarded the keys. (Andrew O'Neil)
 * 2012-11-11 [af2ac1d](https://github.com/silverstripe/sapphire/commit/af2ac1d) include ImagickBackend only when Imagick installed (Will Rossiter)
 * 2012-11-07 [91b69bf](https://github.com/silverstripe/sapphire/commit/91b69bf) ed tab alignment and padding (Ingo Schommer)
 * 2012-11-05 [7ae73ea](https://github.com/silverstripe/sapphire/commit/7ae73ea) Border at top of tabs when no subtabs (Naomi Guyer)
 * 2012-11-02 [f2a709d](https://github.com/silverstripe/sapphire/commit/f2a709d) DataObject::write overwrites Created on first write (Justin Martin)
 * 2012-11-02 [95b5f65](https://github.com/silverstripe/sapphire/commit/95b5f65) GridField add existing auto complete has no max height (fixes #7965) (Naomi Guyer)
 * 2012-11-01 [a651d73](https://github.com/silverstripe/sapphire/commit/a651d73) DataObject::__construct() now accepts stdClass for $record (Justin Martin)
 * 2012-11-02 [2dabaeb](https://github.com/silverstripe/sapphire/commit/2dabaeb) File Uploading Notifications (fixes #7883) (Naomi Guyer)
 * 2012-11-01 [eb23f50](https://github.com/silverstripe/sapphire/commit/eb23f50) Site Tree checkboxes and refactoring (Naomi Guyer)
 * 2012-11-01 [2a67715](https://github.com/silverstripe/sapphire/commit/2a67715) One too many brackets in _style.scss (Naomi Guyer)
 * 2012-10-30 [0883226](https://github.com/silverstripe/sapphire/commit/0883226) ed merge errors in CMSProfileController (Ingo Schommer)
 * 2012-10-23 [0d642af](https://github.com/silverstripe/silverstripe-cms/commit/0d642af) Filter in asset grid appears in incorrect place (Naomi Guyer)
 * 2012-10-17 [8a7f9ed](https://github.com/silverstripe/sapphire/commit/8a7f9ed) ed empty string always on scaffolded enum fields (icecaster)
 * 2012-10-16 [d61f16d](https://github.com/silverstripe/silverstripe-cms/commit/d61f16d) File Uploading Notifications (fixes #7883) (Naomi Guyer)
 * 2012-10-10 [fbfff8d](https://github.com/silverstripe/sapphire/commit/fbfff8d) 7934 When lazy loading fields respect version of the record (jean)
 * 2012-09-27 [39792de](https://github.com/silverstripe/silverstripe-cms/commit/39792de) Use RequestHandler::httpError() for all HTTP errors. (Sam Minnee)
 * 2012-09-27 [b92f759](https://github.com/silverstripe/silverstripe-cms/commit/b92f759) ing test to be less fragile (selects the input ID directly instead of holder) (Sean Harvey)
 * 2012-09-27 [e9ce89e](https://github.com/silverstripe/sapphire/commit/e9ce89e) ing broken FulltextSearchableTest (Sean Harvey)
 * 2012-09-24 [0470219](https://github.com/silverstripe/sapphire/commit/0470219) Output the title of the task instead of Array when listing in the CLI (Simon Welsh)
 * 2012-09-17 [b6c1a64](https://github.com/silverstripe/sapphire/commit/b6c1a64) ed link to RC3 changelog (Sean Harvey)
 * 2012-09-04 [6b6571c](https://github.com/silverstripe/silverstripe-cms/commit/6b6571c) Only rely on request var ParentID, instead of using both $this-&gt;currentPage() and the request var. This will hopefully fix issues around the parent ID getting lost. (Andrew O'Neil)
 * 2012-08-23 [cd61b61](https://github.com/silverstripe/sapphire/commit/cd61b61) Use array_intersect() with expected values so that the order matches. (Simon Welsh)
 * 2012-08-21 [cbdc3bf](https://github.com/silverstripe/sapphire/commit/cbdc3bf) ed bug in Travis matrix definition (Sam Minnee)
 * 2012-08-21 [597bc08](https://github.com/silverstripe/sapphire/commit/597bc08) ed bug in Travis exclusion of 5.4/SQlite and 5.4/PostgreSQL (Sam Minnee)
 * 2012-08-15 [c621a6d](https://github.com/silverstripe/sapphire/commit/c621a6d) fixed trac 7665 - CMS Menu header now changes height depending on the name of the admin and greeting message. position and height were being set inline so added !important to override this. (Jeremy Bridson)
 * 2012-08-14 [0e08840](https://github.com/silverstripe/sapphire/commit/0e08840) ed Travis CI and make it use SQLite (Sam Minnee)
 * 2012-08-14 [50b4d80](https://github.com/silverstripe/sapphire/commit/50b4d80) ed bugs in Travis CI set-up (Sam Minnee)
 * 2012-07-23 [c058f97](https://github.com/silverstripe/sapphire/commit/c058f97) Allow using instances for search filters. (Andrew Short)
 * 2012-07-17 [dbc862e](https://github.com/silverstripe/sapphire/commit/dbc862e) Attempt to create log path before writing file (Simon Elvery)
 * 2012-07-10 [c91e855](https://github.com/silverstripe/sapphire/commit/c91e855) resolve errors with commits from (#572) (Will Rossiter)
 * 2012-07-09 [0ef0c9c](https://github.com/silverstripe/sapphire/commit/0ef0c9c) removed text shadow off confirmation message links trac 7637 (Jeremy Bridson)
 * 2012-07-06 [2a9a4be](https://github.com/silverstripe/sapphire/commit/2a9a4be) ed nested tab styling in other CMS interfaces. (Andrew Short)
 * 2012-07-06 [7ff2a79](https://github.com/silverstripe/sapphire/commit/7ff2a79) links in profiling documentation. (Will Rossiter)
 * 2012-07-01 [a67b964](https://github.com/silverstripe/sapphire/commit/a67b964) improve Director::makeRelative() to ignore  SSL changes. (Tim Klein)
 * 2012-07-01 [9f6eeb4](https://github.com/silverstripe/sapphire/commit/9f6eeb4) insert javascript requirements before the first inline script. (Simon Welsh)
 * 2012-07-01 [9babb01](https://github.com/silverstripe/sapphire/commit/9babb01) ensure that permissions_for_member() accounts for denied permissions. (Will Rossiter)
 * 2012-06-29 [e050540](https://github.com/silverstripe/sapphire/commit/e050540) Director::is_absolute_url() now ignores query and fragment strings (Simon Welsh)
 * 2012-06-25 [606d86a](https://github.com/silverstripe/sapphire/commit/606d86a) DateField javascript fails when it is included in a GroupField (Jeremy Shipman)

### Other

 * 2012-12-17 [7950584](https://github.com/silverstripe/sapphire/commit/7950584) SimpleXML string casting in tests for older PHPUnit (Ingo Schommer)
 * 2012-12-17 [546d202](https://github.com/silverstripe/sapphire/commit/546d202) Don't complain about pre-replaced YAML fixture relations (Ingo Schommer)
 * 2012-12-17 [407a19c](https://github.com/silverstripe/sapphire/commit/407a19c) Beta changelog links (Ingo Schommer)
 * 2012-12-17 [c1bd143](https://github.com/silverstripe/sapphire/commit/c1bd143) Tab spacing (regression from 2d075671) (Ingo Schommer)
 * 2012-12-17 [375c33e](https://github.com/silverstripe/sapphire/commit/375c33e) Wider sidebar to accommodate "add" and "edit" buttons (Ingo Schommer)
 * 2012-12-17 [58d316e](https://github.com/silverstripe/silverstripe-cms/commit/58d316e) Moving "edit tree" button next to "add new" (fixes #8119) (Ingo Schommer)
 * 2012-12-17 [9cfa7b7](https://github.com/silverstripe/sapphire/commit/9cfa7b7) Wider side panel to fit "add" and "edit" button (Ingo Schommer)
 * 2012-12-17 [17908b6](https://github.com/silverstripe/sapphire/commit/17908b6) Revert CMS button style (regression from fe08236) (Ingo Schommer)
 * 2012-12-17 [3da41ef](https://github.com/silverstripe/sapphire/commit/3da41ef) Permission docs (Ingo Schommer)
 * 2012-12-15 [5b2cc19](https://github.com/silverstripe/silverstripe-cms/commit/5b2cc19) Added placeholder text to group listboxes (Ingo Schommer)
 * 2012-12-14 [e6bf199](https://github.com/silverstripe/sapphire/commit/e6bf199) Less far-future date assertions, seems to throw off some PHP installs (Ingo Schommer)
 * 2012-12-14 [4f5b3fa](https://github.com/silverstripe/sapphire/commit/4f5b3fa) Readd SQlite to travis builds, having it fail harms TDD (Ingo Schommer)
 * 2012-12-14 [90084bb](https://github.com/silverstripe/sapphire/commit/90084bb) Separate PHPCS run on travis, don't fail whole build for it (Ingo Schommer)
 * 2012-12-14 [681a024](https://github.com/silverstripe/sapphire/commit/681a024) DOC Removed link to missing 'extending-the-cms.md' (Stig Lindqvist)
 * 2012-12-14 [244bc97](https://github.com/silverstripe/sapphire/commit/244bc97) Don't register a PGSQL failure as a Travis build failure. (Sam Minnee)
 * 2012-12-14 [b65180a](https://github.com/silverstripe/sapphire/commit/b65180a) Changelog update for grouped CMS buttons (Ingo Schommer)
 * 2012-12-13 [1d470fe](https://github.com/silverstripe/silverstripe-cms/commit/1d470fe) Removed duplciate success status feedback on CMS save/publish (Ingo Schommer)
 * 2012-12-13 [aed58a5](https://github.com/silverstripe/sapphire/commit/aed58a5) Loading indicator for "more options" buttons (Ingo Schommer)
 * 2012-12-13 [7dd224d](https://github.com/silverstripe/sapphire/commit/7dd224d) Made GridField font size settings less cryptic (Ingo Schommer)
 * 2012-12-13 [abf1ee9](https://github.com/silverstripe/sapphire/commit/abf1ee9) Suppress jQuery UI's borders around tabs in the CMS (Ingo Schommer)
 * 2012-12-13 [2369cc4](https://github.com/silverstripe/sapphire/commit/2369cc4) Moved group member listing utility buttons after field (Ingo Schommer)
 * 2012-12-13 [236e335](https://github.com/silverstripe/sapphire/commit/236e335) Permission list styling improvements (#8100) (Joel Edwards)
 * 2012-12-13 [f4128a0](https://github.com/silverstripe/silverstripe-cms/commit/f4128a0) Revert "BUG removed class cms-panel-link as it was calling loadPanel to be called twice trac 8041" (Ingo Schommer)
 * 2012-12-12 [611c3f1](https://github.com/silverstripe/silverstripe-cms/commit/611c3f1) Added travis environment info output (Ingo Schommer)
 * 2012-12-12 [441bb5f](https://github.com/silverstripe/sapphire/commit/441bb5f) Added travis environment info output (Ingo Schommer)
 * 2012-12-12 [6100eb9](https://github.com/silverstripe/sapphire/commit/6100eb9) Remove or comment magic numbers, whitespace (Naomi Guyer)
 * 2012-12-11 [40b5366](https://github.com/silverstripe/silverstripe-installer/commit/40b5366) Updated composer.json (Ingo Schommer)
 * 2012-12-11 [ed11970](https://github.com/silverstripe/sapphire/commit/ed11970) Updated composer.json (Ingo Schommer)
 * 2012-12-11 [4cd166a](https://github.com/silverstripe/silverstripe-cms/commit/4cd166a) Updated composer.json (Ingo Schommer)
 * 2012-12-11 [df41fcd](https://github.com/silverstripe/silverstripe-cms/commit/df41fcd) Skip SearchFormTest if DB driver doesn't support fulltext (Ingo Schommer)
 * 2012-12-11 [d92258d](https://github.com/silverstripe/sapphire/commit/d92258d) Allow calling SSViewer_Scope on empty sets (Ingo Schommer)
 * 2012-12-10 [d5dcecf](https://github.com/silverstripe/sapphire/commit/d5dcecf) Disable change tracking for preview state switch (Ingo Schommer)
 * 2012-12-09 [fc5dd29](https://github.com/silverstripe/sapphire/commit/fc5dd29) Add codesniffer that ensures indentation is with tabs. (Simon Welsh)
 * 2012-12-09 [b0121b5](https://github.com/silverstripe/sapphire/commit/b0121b5) Add codesniffer that ensures indentation is with tabs. (Simon Welsh)
 * 2012-12-06 [a9004b9](https://github.com/silverstripe/silverstripe-cms/commit/a9004b9) Restore numbering to navigator items so we can use iterator. (Mateusz Uzdowski)
 * 2012-12-06 [dbee4a1](https://github.com/silverstripe/sapphire/commit/dbee4a1) Clean up the side-by-side code. (Naomi Guyer)
 * 2012-12-06 [747346b](https://github.com/silverstripe/sapphire/commit/747346b) Ability to rotate the mobile preview in side-by-side preview. (Paul Clarke)
 * 2012-12-05 [5cef05e](https://github.com/silverstripe/sapphire/commit/5cef05e) Separate out ActionTabSet functionality into a new file & clean up. (Naomi Guyer)
 * 2012-12-05 [35cbe28](https://github.com/silverstripe/silverstripe-cms/commit/35cbe28) Re-add preview button for IE&lt;=7. Side-by-side disabled for these. (Naomi Guyer)
 * 2012-12-04 [98e824b](https://github.com/silverstripe/silverstripe-cms/commit/98e824b) Avoid duplicating ReportAdmin search params (fixes #8046) (Ingo Schommer)
 * 2012-12-04 [00f1ba4](https://github.com/silverstripe/sapphire/commit/00f1ba4) Side-by-side preview browser compatibility fixes. (Naomi Guyer)
 * 2012-12-04 [230182f](https://github.com/silverstripe/silverstripe-cms/commit/230182f) Remove preview button from history section. (Mateusz Uzdowski)
 * 2012-12-04 [fa3ef8c](https://github.com/silverstripe/sapphire/commit/fa3ef8c) Side-by-side preview initialisation and navigation fixes. (Mateusz Uzdowski)
 * 2012-12-04 [aaae8c9](https://github.com/silverstripe/silverstripe-cms/commit/aaae8c9) Explicitly mark the section as previewable. (Mateusz Uzdowski)
 * 2012-12-03 [8ce2728](https://github.com/silverstripe/sapphire/commit/8ce2728) Replace the state selector switch to support more than 2 states. (Naomi Guyer)
 * 2012-11-30 [2cd46ff](https://github.com/silverstripe/silverstripe-cms/commit/2cd46ff) Use new SelectionGroup_Item API in "add page" UI (Ingo Schommer)
 * 2012-11-30 [963f02e](https://github.com/silverstripe/sapphire/commit/963f02e) Using new description style in MemberDateTimeOptionSetField (Ingo Schommer)
 * 2012-11-30 [255b4c4](https://github.com/silverstripe/sapphire/commit/255b4c4) UploadField-&gt;setDescription() support, removed extraneous "title" attrs (Ingo Schommer)
 * 2012-11-30 [212c427](https://github.com/silverstripe/sapphire/commit/212c427) Pass setDescription() through to sub-fields in DatetimeField and PhoneNumberField (Ingo Schommer)
 * 2012-11-30 [ee797e4](https://github.com/silverstripe/sapphire/commit/ee797e4) More CSS fixes for the ActionTabSets. (Naomi Guyer)
 * 2012-11-30 [618e639](https://github.com/silverstripe/sapphire/commit/618e639) Refactor and comment TabSet.js (Naomi Guyer)
 * 2012-11-29 [027a41a](https://github.com/silverstripe/silverstripe-cms/commit/027a41a) Consistent naming for root breadcrumb on page controllers (fixes #8057) (Ingo Schommer)
 * 2012-11-29 [235e8c8](https://github.com/silverstripe/sapphire/commit/235e8c8) CSS fixes for the ActionTabSet. (Naomi Guyer)
 * 2012-11-29 [a80aa3c](https://github.com/silverstripe/sapphire/commit/a80aa3c) Provide new save icon for the use in the framework. (Naomi Guyer)
 * 2012-11-29 [772961c](https://github.com/silverstripe/silverstripe-cms/commit/772961c) Add a secondary side-by-side state selector to the edit form (Mateusz Uzdowski)
 * 2012-11-28 [7bd200f](https://github.com/silverstripe/silverstripe-cms/commit/7bd200f) Re-adding usage of $TRAVIS_BRANCH, fixing wrong 3.0 dependency (Ingo Schommer)
 * 2012-11-27 [09f382d](https://github.com/silverstripe/silverstripe-cms/commit/09f382d) Composer require framework at 'dev-master' (Ingo Schommer)
 * 2012-11-27 [9312c70](https://github.com/silverstripe/sapphire/commit/9312c70) Side-by-side preview options fixes. (Naomi Guyer)
 * 2012-11-27 [715b62f](https://github.com/silverstripe/sapphire/commit/715b62f) Updating chosen dependency (Naomi Guyer)
 * 2012-11-27 [0711c32](https://github.com/silverstripe/silverstripe-cms/commit/0711c32) Add side-by-side translation context. (Naomi Guyer)
 * 2012-11-22 [477cf6b](https://github.com/silverstripe/sapphire/commit/477cf6b) Removing redundant DatabaseAdmin::testinstall() (Sean Harvey)
 * 2012-11-22 [544d2eb](https://github.com/silverstripe/sapphire/commit/544d2eb) Side-by-side preview options styling. (Paul Clarke)
 * 2012-11-19 [3f2ddbb](https://github.com/silverstripe/sapphire/commit/3f2ddbb) Future-proof the submitForm for use with forms without validation. (Mateusz Uzdowski)
 * 2012-11-16 [8168a7d](https://github.com/silverstripe/sapphire/commit/8168a7d) Remove deprecated DBField::create(), use create_field() instead (Sean Harvey)
 * 2012-11-16 [b3d5b68](https://github.com/silverstripe/sapphire/commit/b3d5b68) Remove deprecated SQLQuery::setWhere() multiple arguments (Sean Harvey)
 * 2012-11-16 [a2bd378](https://github.com/silverstripe/sapphire/commit/a2bd378) Remove deprecated ArrayList::getRange(), use limit() instead (Sean Harvey)
 * 2012-11-16 [7042d87](https://github.com/silverstripe/sapphire/commit/7042d87) Remove deprecated Object::set_uninherited() (Sean Harvey)
 * 2012-11-16 [d13b067](https://github.com/silverstripe/sapphire/commit/d13b067) Remove deprecated HTTP::getMimeType() use get_mime_type() instead (Sean Harvey)
 * 2012-11-16 [a46838c](https://github.com/silverstripe/sapphire/commit/a46838c) Removed deprecated Folder::findOrMake(), use find_or_make() instead (Sean Harvey)
 * 2012-11-16 [d1c5cd1](https://github.com/silverstripe/sapphire/commit/d1c5cd1) Removing unused entities from en.yml (Sean Harvey)
 * 2012-11-16 [4c73f23](https://github.com/silverstripe/silverstripe-cms/commit/4c73f23) Removing deprecated FileList as it relies on TableListField (Sean Harvey)
 * 2012-11-16 [4ea5bc5](https://github.com/silverstripe/sapphire/commit/4ea5bc5) adding notes about deprecated things in the core (Sean Harvey)
 * 2012-11-16 [4330ecf](https://github.com/silverstripe/sapphire/commit/4330ecf) Removing redundant templates (moved to legacytablefields module) (Sean Harvey)
 * 2012-11-16 [6a868e7](https://github.com/silverstripe/sapphire/commit/6a868e7) Removing deprecated prototype/behaviour libraries (Sean Harvey)
 * 2012-11-16 [77337ae](https://github.com/silverstripe/sapphire/commit/77337ae) Removing deprecated TableListField and subclasses (Sean Harvey)
 * 2012-11-16 [aeef4d6](https://github.com/silverstripe/sapphire/commit/aeef4d6) Removing deprecated JS from AjaxUniqueTextField (Sean Harvey)
 * 2012-11-15 [26a3c1c](https://github.com/silverstripe/sapphire/commit/26a3c1c) Re-adding Debug::caller() which was inadvertently removed in 9eca2d6 (Sean Harvey)
 * 2012-11-15 [cef087f](https://github.com/silverstripe/silverstripe-cms/commit/cef087f) Removed deprecated SiteTree::TreeTitle(), use getTreeTitle() instead (Sean Harvey)
 * 2012-11-15 [d236bb5](https://github.com/silverstripe/silverstripe-cms/commit/d236bb5) Removed deprecated SiteTree::prepopuplate_permission_cache() (Sean Harvey)
 * 2012-11-15 [33884ac](https://github.com/silverstripe/silverstripe-cms/commit/33884ac) Removed deprecated ContentController::LangAttributes() (Sean Harvey)
 * 2012-11-15 [555ecd7](https://github.com/silverstripe/silverstripe-cms/commit/555ecd7) Removed deprecated SiteTreeDecorator, use SiteTreeExtension instead (Sean Harvey)
 * 2012-11-15 [41efeed](https://github.com/silverstripe/sapphire/commit/41efeed) Update javascript/GridField.js (Vitaliy)
 * 2012-11-15 [35bcf69](https://github.com/silverstripe/silverstripe-cms/commit/35bcf69) Removed deprecated Register::register() and unregister() (Sean Harvey)
 * 2012-11-15 [8c3ecab](https://github.com/silverstripe/sapphire/commit/8c3ecab) Removed deprecated ToggleCompositeField::startClosed() (Sean Harvey)
 * 2012-11-15 [4c803a2](https://github.com/silverstripe/sapphire/commit/4c803a2) Removed deprecated arguments of row, cols to TextareaField (Sean Harvey)
 * 2012-11-15 [4d11080](https://github.com/silverstripe/sapphire/commit/4d11080) Remove deprecated rows and columns argument support from HtmlEditorField (Sean Harvey)
 * 2012-11-15 [b3b071a](https://github.com/silverstripe/sapphire/commit/b3b071a) Removing deprecated FormField functions (Sean Harvey)
 * 2012-11-15 [0d659a5](https://github.com/silverstripe/sapphire/commit/0d659a5) Removing deprecated FormField::Name(), use getName() instead (Sean Harvey)
 * 2012-11-15 [c99ed7d](https://github.com/silverstripe/sapphire/commit/c99ed7d) Extending deprecation of legacy table fields to 3.1 (Sean Harvey)
 * 2012-11-15 [e1c5f08](https://github.com/silverstripe/sapphire/commit/e1c5f08) Removing deprecated container class argument to DataObject::get() (Sean Harvey)
 * 2012-11-15 [3a198c3](https://github.com/silverstripe/sapphire/commit/3a198c3) Removing deprecated DataObject::databaseFields() and customDatabaseFields() (Sean Harvey)
 * 2012-11-15 [e4088fe](https://github.com/silverstripe/sapphire/commit/e4088fe) Removing deprecated instance_get_one() and instance_get() (Sean Harvey)
 * 2012-11-15 [a8d779b](https://github.com/silverstripe/sapphire/commit/a8d779b) Removing deprecated DataObject::buildDataObjectSet() (Sean Harvey)
 * 2012-11-15 [dde820d](https://github.com/silverstripe/sapphire/commit/dde820d) Extend deprecation of DataObject::Aggregate() and RelationshipAggregate() (Sean Harvey)
 * 2012-11-15 [0db33f7](https://github.com/silverstripe/sapphire/commit/0db33f7) Removing DataObject::buildSQL() and extendedSQL(), use DataList instead (Sean Harvey)
 * 2012-11-15 [651d4b3](https://github.com/silverstripe/sapphire/commit/651d4b3) Removing DataObject::getAllFields(), use toMap() instead (Sean Harvey)
 * 2012-11-15 [5f852ae](https://github.com/silverstripe/sapphire/commit/5f852ae) Removing deprecated DataObject::setComponent() (Sean Harvey)
 * 2012-11-15 [3108dea](https://github.com/silverstripe/sapphire/commit/3108dea) Removing deprecated DataList::limit() arguments (Sean Harvey)
 * 2012-11-15 [68bb748](https://github.com/silverstripe/sapphire/commit/68bb748) Removing join() on DataList/DataQuery (Sean Harvey)
 * 2012-11-15 [b43b023](https://github.com/silverstripe/sapphire/commit/b43b023) Remove deprecated security token methods on Form (Sean Harvey)
 * 2012-11-15 [6382013](https://github.com/silverstripe/sapphire/commit/6382013) Remove deprecated Form::FormEncType(), use getEncType() instead (Sean Harvey)
 * 2012-11-15 [4e355bd](https://github.com/silverstripe/sapphire/commit/4e355bd) Removing deprecated methods on Form (Sean Harvey)
 * 2012-11-15 [2080867](https://github.com/silverstripe/sapphire/commit/2080867) Removing deprecated arguments to FileField for setting folder name (Sean Harvey)
 * 2012-11-15 [a9d7c9e](https://github.com/silverstripe/sapphire/commit/a9d7c9e) Removing deprecated variables from FileField (Sean Harvey)
 * 2012-11-15 [0a5d43f](https://github.com/silverstripe/sapphire/commit/0a5d43f) Removing deprecated CompositeField::FieldSet(), use FieldList() instead (Sean Harvey)
 * 2012-11-15 [6448cd7](https://github.com/silverstripe/sapphire/commit/6448cd7) Removing deprecated Validator javascript methods (Sean Harvey)
 * 2012-11-15 [5c983a2](https://github.com/silverstripe/sapphire/commit/5c983a2) emove deprecated StringField::Lower() and Upper() methods (Sean Harvey)
 * 2012-11-15 [9e7bdb3](https://github.com/silverstripe/sapphire/commit/9e7bdb3) Removing deprecated Text::EscapeXML(), use DBField-&gt;XML() instead (Sean Harvey)
 * 2012-11-15 [f41650c](https://github.com/silverstripe/sapphire/commit/f41650c) Remove deprecated i18n::include_locale_file() (Sean Harvey)
 * 2012-11-15 [587d669](https://github.com/silverstripe/sapphire/commit/587d669) Removing deprecated PasswordEncryptor::compare() method (Sean Harvey)
 * 2012-11-15 [f122b10](https://github.com/silverstripe/sapphire/commit/f122b10) Remove deprecated Group::addToGroupByName() (Sean Harvey)
 * 2012-11-15 [d038cd7](https://github.com/silverstripe/sapphire/commit/d038cd7) Removing deprecated tests (Sean Harvey)
 * 2012-11-15 [0d79897](https://github.com/silverstripe/sapphire/commit/0d79897) Removing deprecated ArrayData::getArray() (Sean Harvey)
 * 2012-11-15 [de2509c](https://github.com/silverstripe/sapphire/commit/de2509c) Removing deprecated SimpleImageField (Sean Harvey)
 * 2012-11-15 [6ce33d5](https://github.com/silverstripe/sapphire/commit/6ce33d5) Removing deprecated ImageFormAction (Sean Harvey)
 * 2012-11-15 [8156f0f](https://github.com/silverstripe/sapphire/commit/8156f0f) Removing deprecated ImageField, use UploadField instead (Sean Harvey)
 * 2012-11-15 [594faf7](https://github.com/silverstripe/sapphire/commit/594faf7) Removing deprecated FileIFrameField, use UploadField instead (Sean Harvey)
 * 2012-11-15 [5a98cdd](https://github.com/silverstripe/sapphire/commit/5a98cdd) Removing deprecated File::TreeTitle(), use File::getTreeTitle() instead (Sean Harvey)
 * 2012-11-15 [e52db56](https://github.com/silverstripe/sapphire/commit/e52db56) Removing deprecated validator functions on Upload (Sean Harvey)
 * 2012-11-15 [9eca2d6](https://github.com/silverstripe/sapphire/commit/9eca2d6) Removing deprecated Debug functions, use SS_Log and SS_Backtrace instead (Sean Harvey)
 * 2012-11-15 [b6870ad](https://github.com/silverstripe/sapphire/commit/b6870ad) Removing deprecated Core.php functions (Sean Harvey)
 * 2012-11-15 [b5ee9f9](https://github.com/silverstripe/sapphire/commit/b5ee9f9) Removing ClassInfo::is_subclass_of(), use is_subclass_of() instead (Sean Harvey)
 * 2012-11-15 [78311c9](https://github.com/silverstripe/sapphire/commit/78311c9) Remove deprecated PaginatedList::getPageLimits() and setPageLimits() (Sean Harvey)
 * 2012-11-15 [63983ad](https://github.com/silverstripe/sapphire/commit/63983ad) Remove deprecated RequestHandler::isAjax(), use SS_HTTPRequest-&gt;isAjax() instead (Sean Harvey)
 * 2012-11-15 [491057f](https://github.com/silverstripe/sapphire/commit/491057f) Remove deprecated Director dev/test server functions (Sean Harvey)
 * 2012-11-15 [66d8ff9](https://github.com/silverstripe/sapphire/commit/66d8ff9) Remove deprecated Director static functions (Sean Harvey)
 * 2012-11-15 [de0ade9](https://github.com/silverstripe/sapphire/commit/de0ade9) Remove deprecated Director::urlParam() and Director::urlParams() (Sean Harvey)
 * 2012-11-15 [6718814](https://github.com/silverstripe/sapphire/commit/6718814) Remove deprecated PartialMatchFilter, use PartialMatchFilter instead (Sean Harvey)
 * 2012-11-15 [4c3b804](https://github.com/silverstripe/sapphire/commit/4c3b804) Remove deprecated ComponentSet, use ManyManyList or HasManyList instead (Sean Harvey)
 * 2012-11-15 [0a046af](https://github.com/silverstripe/sapphire/commit/0a046af) Remove deprecated DataObjectDecorator, use DataExtension instead (Sean Harvey)
 * 2012-11-15 [a371db4](https://github.com/silverstripe/sapphire/commit/a371db4) Remove deprecated DataObjectSet, use DataList or ArrayList instead (Sean Harvey)
 * 2012-11-15 [0673f27](https://github.com/silverstripe/sapphire/commit/0673f27) Remove deprecated FieldSet, use FieldList instead (Sean Harvey)
 * 2012-11-15 [6a9617b](https://github.com/silverstripe/sapphire/commit/6a9617b) Remove deprecated LeftAndMainDecorator, use LeftAndMainExtension instead (Sean Harvey)
 * 2012-11-10 [d006c08](https://github.com/silverstripe/silverstripe-cms/commit/d006c08) Reverts test code committed in a52514a3 (Simon Welsh)
 * 2012-11-08 [0fe9379](https://github.com/silverstripe/silverstripe-cms/commit/0fe9379) Composer branch alias from dev-master to 3.1 (Ingo Schommer)
 * 2012-11-08 [bde6344](https://github.com/silverstripe/sapphire/commit/bde6344) Composer branch alias from dev-master to 3.1 (Ingo Schommer)
 * 2012-11-06 [ada4210](https://github.com/silverstripe/sapphire/commit/ada4210) Tabs docs for CMS (Ingo Schommer)
 * 2012-11-07 [078a8e9](https://github.com/silverstripe/sapphire/commit/078a8e9) Adding note about Object::add_extension() and has_extension() changes (Sean Harvey)
 * 2012-11-06 [f988ae3](https://github.com/silverstripe/sapphire/commit/f988ae3)  ENHANCEMENT Message colours updated (Paul Clarke)
 * 2012-11-05 [f30759e](https://github.com/silverstripe/silverstripe-installer/commit/f30759e) Updating favicon (Sean Harvey)
 * 2012-11-01 [f9e32f5](https://github.com/silverstripe/silverstripe-cms/commit/f9e32f5) Added composer.json (Ingo Schommer)
 * 2012-11-01 [43cd54b](https://github.com/silverstripe/sapphire/commit/43cd54b) Added composer.json (Ingo Schommer)
 * 2012-10-23 [84851c9](https://github.com/silverstripe/sapphire/commit/84851c9) Remove sub navigation for "Files" (fixes 7956) (Naomi Guyer)
 * 2012-10-23 [92e4b4f](https://github.com/silverstripe/sapphire/commit/92e4b4f) Remove sub navigation for "Files" (fixes 7956) (Naomi Guyer)
 * 2012-10-16 [f365134](https://github.com/silverstripe/sapphire/commit/f365134) Added 2.4.8-rc1 changelog (Ingo Schommer)
 * 2012-10-08 [e3a27ea](https://github.com/silverstripe/sapphire/commit/e3a27ea) CMS member profile now is no longer in a popup (#7880) (Saophalkun Ponlu)
 * 2012-10-03 [fb5e488](https://github.com/silverstripe/sapphire/commit/fb5e488) Line length fixes (Ingo Schommer)
 * 2012-09-21 [7f1b6cf](https://github.com/silverstripe/sapphire/commit/7f1b6cf) HTTPRequest and HTTPResponse now return $this on all setters MINOR: also added some docs (Zauberfisch)
 * 2012-09-21 [5df519c](https://github.com/silverstripe/sapphire/commit/5df519c) Removed SiteTree.MetaTitle and MetaKeywords usage (Ingo Schommer)
 * 2012-09-21 [4506e92](https://github.com/silverstripe/silverstripe-cms/commit/4506e92) Adds Travis testing to the CMS (Simon Welsh)
 * 2012-08-21 [9f4fb13](https://github.com/silverstripe/sapphire/commit/9f4fb13) Added PHP 5.4 + MySQL to build grid (Sam Minnee)
 * 2012-08-21 [866d9a9](https://github.com/silverstripe/sapphire/commit/866d9a9) Updated Travis-CI configuration to have a 3 database build grid. (Sam Minnee)
 * 2012-08-14 [2dadc77](https://github.com/silverstripe/sapphire/commit/2dadc77) Revert "Make PHPUnit bootstrap add flush=1" (Sam Minnee)
 * 2012-08-14 [4d1c2ed](https://github.com/silverstripe/sapphire/commit/4d1c2ed) Make PHPUnit bootstrap add flush=1 (Sam Minnee)
 * 2012-08-14 [8d92046](https://github.com/silverstripe/sapphire/commit/8d92046) Added support for Travis CI (Sam Minnee)
 * 2012-08-01 [f5b25d2](https://github.com/silverstripe/sapphire/commit/f5b25d2) Make the list used for autocomplete search results settable. (Andrew Short)
 * 2012-07-17 [9a5baaf](https://github.com/silverstripe/sapphire/commit/9a5baaf) Don't capture form submits to new windows. (Andrew Short)