# 3.0.0-beta2 #

## Overview ##

### CMS ###
 
 * A large number of bugfixes in beta1.
 * Improvements to media management and insertion, including "insert from web""
 * Improvements to batch actions
 * List view for pages
 * The reports section is back
 * Improved usability on the tree view when editing page content.
 * Widget system has been turned into a module.
 
### Framework ###

 * A large number of bugfixes in beta1.
 * SilverStripe now requires PHP 5.3+, and makes of the features introduced in that version.
 * SilverStripe doesn't throw `E_STRICT` errors now.
 * New syntax for querying the ORM, e.g., `Member::get()->byID(5)`.
 * Restored i18n support in the templates, with a new & improved syntax.
 * Moved i18n translation tools to getlocalization.com

## Still to come ##

A non-exhaustive, high-level list of features we haven’t addressed yet:
 
 * Move SilverStripe classes into PHP namespaces.
 * Gallery view for files.
 * New batch action system with interactive dialogs.
 * SQL Server and PostgreSQL core support.
 * Usability improvements based on feedback from user testing.
 * Performance fixes, especially for Internet Explorer.

A beta3 release is expected some time in May.
 
## Upgrading ##

See [3.0.0](/changelogs/3.0.0) for previous details.
Note that you'll get PHP notice-level errors automatically
when using deprecated functionality (through the new `Deprecation` class).

## Changelog ##

### API Changes

 * 2012-04-20 [8e48e6e](https://github.com/silverstripe/sapphire/commit/8e48e6e) Allow &lt;classname&gt;::get(), eg, Member::get()-&gt;byID(5) (Sam Minnee)
 * 2012-04-18 [8a72b32](https://github.com/silverstripe/silverstripe-cms/commit/8a72b32) Moved Widget API to new module (https://github.com/silverstripe/silverstripe-widgets), incl. WidgetArea and WidgetAreaEditor classes (Ingo Schommer)
 * 2012-04-18 [a44916d](https://github.com/silverstripe/sapphire/commit/a44916d) Don't use $tinymce_lang lookup in i18n::get_lang_from_locale(), as it mixes locales with langs and hence breaks language fallbacks in _t() (e.g. "pt_BR" returns "pt_br", rather than "pt") (Ingo Schommer)
 * 2012-04-17 [0f7dd79](https://github.com/silverstripe/silverstripe-cms/commit/0f7dd79) Removed $controller context from SiteTree-&gt;CMSTreeClasses(), now handled through closures in the specific LeftAndMain usage instead (to handle separate contexts for links and determining "current page") (Ingo Schommer)
 * 2012-04-16 [6aeac37](https://github.com/silverstripe/silverstripe-cms/commit/6aeac37) Combined "Pages" and "Edit Page" into a single menu entry ENHANCEMENT Namespaced tree search parameters in CMSMain, in order to detect more reliably if a filter has been applied. Changing page search form to standard pushState behaviour, same as ModelAdmin (for both tree and list view). MINOR Refactored list view loading (Ingo Schommer)
 * 2012-04-16 [ad2a21c](https://github.com/silverstripe/sapphire/commit/ad2a21c) getSysTempDir() is now deprecated, use sys_get_temp_dir() instead! (Sean Harvey)
 * 2012-04-14 [fca2c20](https://github.com/silverstripe/sapphire/commit/fca2c20) Removed $priority arguments from _t(), use module priorities instead. ENHANCEMENT Refactored i18nTextCollector collection logic alongside $priority removal, from regex to (slightly more maintainable) PHP tokenizer. Using var_export() for generating PHP, which auto-escapes strings more robustly. ENHANCEMENT Refactored i18nTextCollector into pluggable writers (in preparation of new YML output format) (Ingo Schommer)
 * 2012-04-13 [8ba9c3c](https://github.com/silverstripe/sapphire/commit/8ba9c3c) Removed $params argument to DataObject-&gt;getCMSFields(), please use FormScaffolder directly (fixes #7135) (Ingo Schommer)
 * 2012-04-13 [42e6ae2](https://github.com/silverstripe/sapphire/commit/42e6ae2) add validation extension hook to DataExtension (Mateusz Uzdowski)
 * 2012-04-13 [6db8f85](https://github.com/silverstripe/sapphire/commit/6db8f85) Enable E_STRICT, but include DebugView, Log classes as these are not always guaranteed to be loaded by ClassLoader at the time a strict error is issued. (Sean Harvey)
 * 2012-04-12 [621b2e1](https://github.com/silverstripe/sapphire/commit/621b2e1) deprecate DataObject::setComponent, no longer does anything. (Mateusz Uzdowski)
 * 2012-04-12 [2b8e14f](https://github.com/silverstripe/sapphire/commit/2b8e14f) Fixing CompositeField/SelectionGroup performReadonlyTransformation and performDisabledTransformation to be consistent and conform with parent FormField. $trans argument is no longer allowed, just uses DisabledTransformation or ReadonlyTransformation instead. (Sean Harvey)
 * 2012-04-11 [bdb312c](https://github.com/silverstripe/sapphire/commit/bdb312c) DBField::hasValue() conflicts with ViewableData::hasValue(), use DBField::exists() instead. (Andrew O'Neil)
 * 2012-04-10 [55bbda3](https://github.com/silverstripe/silverstripe-cms/commit/55bbda3) Removed AdvancedSearchForm, extend SearchForm for custom advanced search functionality instead. (Sean Harvey)
 * 2012-04-07 [0d031a5](https://github.com/silverstripe/sapphire/commit/0d031a5) Use Config for registering default password encryptors (Stig Lindqvist)
 * 2012-04-05 [a44b67b](https://github.com/silverstripe/sapphire/commit/a44b67b) Moved RequestHandler-&gt;isAjax() to SS_HTTPRequest-&gt;isAjax() (Ingo Schommer)
 * 2012-03-30 [dbc4be3](https://github.com/silverstripe/sapphire/commit/dbc4be3) Removed Services_JSON library, as we use the built-in json functions instead. (Sean Harvey)
 * 2012-03-30 [8ae474b](https://github.com/silverstripe/sapphire/commit/8ae474b) Remove use of Services_JSON and replace with json_encode() and json_decode() API CHANGE Convert::json2array() will convert nested JSON structures to array as well for easier traversal, instead of array with nested objects. (Sean Harvey)
 * 2012-03-24 [2576944](https://github.com/silverstripe/sapphire/commit/2576944) Added DataObject::relField(), which pushes the "relation dot syntax" code of TableListField/GridField back to the model. BUGFIX: Made DataObject::relObject() more flexible; allowable thanks to new ORM. (Sam Minnee)
 * 2012-03-14 [1827dc6](https://github.com/silverstripe/silverstripe-cms/commit/1827dc6) Removed SiteTree-&gt;HomepageForDomain and related functionality ($write_homepage_map and generate_homepage_domain_map()), use new 'homepagefordomain' module instead (fixes #6902) (Ingo Schommer)
 * 2011-11-26 [bd23a07](https://github.com/silverstripe/sapphire/commit/bd23a07) Using Zend_Translate with YAML translation files, replacing the $lang global and PHP files in the /lang folders. (Ingo Schommer)

### Features and Enhancements

 * 2012-04-19 [23c3fb8](https://github.com/silverstripe/sapphire/commit/23c3fb8) EmailField now uses type="email", which has the benefit of allowing email validation when using the required="required" attribute. If using an old browser, the "email" type will fallback to "text" (Sean Harvey)
 * 2012-04-19 [7850499](https://github.com/silverstripe/silverstripe-cms/commit/7850499) Part of fix to #7010. Change to some gridfield calls to setDisplayFields and friends. (Robert Curry)
 * 2012-04-19 [842784c](https://github.com/silverstripe/sapphire/commit/842784c) Fixes #7010. Move DisplayFields, FieldCasting and FieldFormatting functions from GridField to GridFieldDataColumns. (Robert Curry)
 * 2012-04-19 [4cf8db3](https://github.com/silverstripe/sapphire/commit/4cf8db3) Remove use of deprecated extraStatics in core files (Sean Harvey)
 * 2012-04-18 [ca853d7](https://github.com/silverstripe/silverstripe-cms/commit/ca853d7) Renamed "Content" tab in SiteTree-&gt;getCMSFields() to "Main Content" to distinguish it from the top-level "Content" tag (Ingo Schommer)
 * 2012-04-18 [503fa0a](https://github.com/silverstripe/silverstripe-cms/commit/503fa0a) Updated YML translations from translate.ss.org, removed unapproved langs with little or no translations, updated master strings, fixed line break problem in lang files generated by i18nYMLConverter module (Ingo Schommer)
 * 2012-04-18 [92054fb](https://github.com/silverstripe/sapphire/commit/92054fb) Updated YML translations from translate.ss.org, removed unapproved langs with little or no translations, updated master strings, fixed line break problem in lang files generated by i18nYMLConverter module (Ingo Schommer)
 * 2012-04-18 [1e25637](https://github.com/silverstripe/silverstripe-cms/commit/1e25637), [330dd30](https://github.com/silverstripe/sapphire/commit/330dd30) Trac#7166 - styled the new combined tree and edit view. (Jeremy Bridson)
 * 2012-04-17 [761bae3](https://github.com/silverstripe/sapphire/commit/761bae3) Support for anonymous functions instead of eval() in Hierarchy-&gt;getSiteTreeAsUL() (Ingo Schommer)
 * 2012-04-17 [d6eb1b6](https://github.com/silverstripe/sapphire/commit/d6eb1b6) Added .cms-panel-deferred for lazy loading of CMS panels (for performance reasons) (Ingo Schommer)
 * 2012-04-17 [a393d39](https://github.com/silverstripe/sapphire/commit/a393d39) Anonymous function support in GridField-&gt;setFieldFormatting() (Ingo Schommer)
 * 2012-04-17 [5603fbe](https://github.com/silverstripe/sapphire/commit/5603fbe) Fixes #7059. Add test for allowedMaxFileNumber to UploadFieldTest. (Robert Curry)
 * 2012-04-17 [e262a29](https://github.com/silverstripe/sapphire/commit/e262a29) move code introspection functions to the silverstripe-codeviz module (Mateusz Uzdowski)
 * 2012-04-16 [64300ca](https://github.com/silverstripe/sapphire/commit/64300ca) fixed issues with overflow between tabs and breadcrumbs in cms-content-header (Jeremy Bridson)
 * 2012-04-16 [3ff6002](https://github.com/silverstripe/sapphire/commit/3ff6002) Always use sys_get_temp_dir() which will return the system temp folder for PHP 5.2+, since we don't support older versions we don't need to patch around this any longer. (Sean Harvey)
 * 2012-04-15 [ce097a7](https://github.com/silverstripe/sapphire/commit/ce097a7) If there are no test failures, but incomplete tests, mark summary of test run as "ok but incomplete" in yellow for CliTestReporter (Sean Harvey)
 * 2012-04-14 [fc18b2c](https://github.com/silverstripe/sapphire/commit/fc18b2c) TestReporter now reports incomplete tests properly (Sean Harvey)
 * 2012-04-14 [8949dfa](https://github.com/silverstripe/sapphire/commit/8949dfa) Replaced locations of sapphire with $ModulePath(framework) in templates, based off Controller which implements TemplateGlobalProvider (Sean Harvey)
 * 2012-04-14 [07d2d52](https://github.com/silverstripe/sapphire/commit/07d2d52) populate FormField:: on the fly based on class name of field rather than requiring explict  definition. (Will Rossiter)
 * 2012-04-14 [cbcee57](https://github.com/silverstripe/sapphire/commit/cbcee57) New i18nTextCollector_Writer_RailsYaml (Ingo Schommer)
 * 2012-04-14 [907568b](https://github.com/silverstripe/sapphire/commit/907568b) move hard coded template HTML for composite field and field group out to separate template files. (Will Rossiter)
 * 2012-04-13 [2dc0e72](https://github.com/silverstripe/silverstripe-cms/commit/2dc0e72) Caching expensive CMSMain-&gt;SiteTreeHints() call on disk (Ingo Schommer)
 * 2012-04-13 [be97535](https://github.com/silverstripe/sapphire/commit/be97535) add an infinite-loop check as validation in Hierarchy (os4399) (Mateusz Uzdowski)
 * 2012-04-13 [6a7668f](https://github.com/silverstripe/sapphire/commit/6a7668f) Trac 6882 - created include template for back button and altered the templates accordingly (Jeremy Bridson)
 * 2012-04-13 [4443d00](https://github.com/silverstripe/silverstripe-cms/commit/4443d00) Trac 6882 - created include for back button and altered the templates accordingly (Jeremy Bridson)
 * 2012-04-13 [8b0dafb](https://github.com/silverstripe/sapphire/commit/8b0dafb) Change PHP version requirements. Part of #7131. (Robert Curry)
 * 2012-04-13 [3e69c0d](https://github.com/silverstripe/silverstripe-installer/commit/3e69c0d) Change PHP version requirements in comments. Part of #7131. (Robert Curry)
 * 2012-04-13 [521742a](https://github.com/silverstripe/sapphire/commit/521742a) Split arguments passed to SSViewer into underlay and overlay arguments to control precedence. Also fixes breakage of SecurityAdmin (Hamish Friedlander)
 * 2012-04-12 [b025b95](https://github.com/silverstripe/sapphire/commit/b025b95) Lazy-loading image and link dialogs for HtmlEditorField, to avoid unnecessary processing overhead on initial CMS load (also means they'll never get loaded if not required, e.g. in ReportAdmin) (Ingo Schommer)
 * 2012-04-12 [ae5bd7d](https://github.com/silverstripe/sapphire/commit/ae5bd7d) refer to cache statics explicitly via DataObject (os6175) (Mateusz Uzdowski)
 * 2012-04-12 [203bfc9](https://github.com/silverstripe/silverstripe-cms/commit/203bfc9) replacing ReportAdmin report listing paginator with a new footer GridField component (Julian Seidenberg)
 * 2012-04-11 [e4a043a](https://github.com/silverstripe/sapphire/commit/e4a043a) Allow arguments to be passed to templates via an array passed to SSViewer#process and via keyword=value pairs in the &lt;% include %&gt; tag (Hamish Friedlander)
 * 2012-04-11 [6536259](https://github.com/silverstripe/silverstripe-cms/commit/6536259) SSF-124 make tab select pages list view if the current url is 'listchildren' otherwise use the default action defined in TabSet.js (Normann Lou)
 * 2012-04-11 [84388a4](https://github.com/silverstripe/sapphire/commit/84388a4) SSF-124 - changed how the border radius was applied on the gridfield header. border radius is now applied to the first and last th in the first row in &lt;thead&gt;. (Jeremy Bridson)
 * 2012-04-11 [4f23ac1](https://github.com/silverstripe/sapphire/commit/4f23ac1) Installer styling, moving away from blackcandy (Paul Clarke)
 * 2012-04-10 [1e0b843](https://github.com/silverstripe/sapphire/commit/1e0b843) refactoring code for making a link an ajax/history link. Removing the selector that targets .crumb and only applying the selector that turns links with cms-panel-link into ajax enabled links. Adding the cms-panel-link to those links that already have the crumb class. (Julian Seidenberg)
 * 2012-04-10 [dc01b74](https://github.com/silverstripe/silverstripe-cms/commit/dc01b74) SS-124 duplicate "Add New" and "Batch Action" into page list view (Normann Lou)
 * 2012-04-10 [5a18e3b](https://github.com/silverstripe/silverstripe-cms/commit/5a18e3b) SSF-124 making the links in the list view ajax history links, so they don't refresh the whole browser window (Julian Seidenberg)
 * 2012-04-10 [4a36b1e](https://github.com/silverstripe/silverstripe-cms/commit/4a36b1e) SSF-124 finished ajax version of admin/pages/listchildren/ID in Pages admin (Normann Lou)
 * 2012-04-10 [b268070](https://github.com/silverstripe/sapphire/commit/b268070) removed border and added blue link color to page titles. (Jeremy Bridson)
 * 2012-04-10 [e0b4294](https://github.com/silverstripe/sapphire/commit/e0b4294) SSF-124 - styled the pages list view. (Jeremy Bridson)
 * 2012-04-10 [26cec90](https://github.com/silverstripe/sapphire/commit/26cec90) SSF-124 make GridFieldSortableHeader to show the extra classes for each of the header field. (Normann Lou)

...

 * 2012-04-05 [14c3fd7](https://github.com/silverstripe/sapphire/commit/14c3fd7) SSF-168 refactoring print button so that it opens print view in a new window. This is useful for debugging and also useful for when someone wants to use the print view not for printing, but for viewing a clean version of a gridfield without the surrounding CMS, using the view for copying and pasting into another app, for example. (Julian Seidenberg)
 * 2012-04-05 [7d98734](https://github.com/silverstripe/silverstripe-cms/commit/7d98734) SSF-124 customise displayed fields of page list view, add children list view links (Normann Lou)
 * 2012-04-05 [f101595](https://github.com/silverstripe/silverstripe-cms/commit/f101595) SSF-124 first version of tree list view added (Normann Lou)
 * 2012-04-05 [206c61f](https://github.com/silverstripe/sapphire/commit/206c61f) SSF-168 - styled report admin gridfield (Jeremy Bridson)
 * 2012-04-05 [44e6434](https://github.com/silverstripe/silverstripe-cms/commit/44e6434) SSF-168 adding breadcrumbs to ReportAdmin (Julian Seidenberg)
 * 2012-04-05 [697ffb8](https://github.com/silverstripe/sapphire/commit/697ffb8) fixed styling on "installing SilverStripe" page. (Jeremy Bridson)
 * 2012-04-05 [c1f6f20](https://github.com/silverstripe/sapphire/commit/c1f6f20) added logo to header on ss3 install page - plus compass regenerated icon sprites. (Jeremy Bridson)
 * 2012-04-04 [4c76c85](https://github.com/silverstripe/silverstripe-cms/commit/4c76c85) Use GridFields to show reports in the ReportAdmin (Andrew O'Neil)
 * 2012-04-04 [7740bb3](https://github.com/silverstripe/sapphire/commit/7740bb3) SSF-168 moved print and csv export buttons to the top of the grid (Felipe Skroski)
 * 2012-04-04 [4ffef20](https://github.com/silverstripe/sapphire/commit/4ffef20) SSF-168 updated print styles to the datagrid (Felipe Skroski)
 * 2012-04-04 [875eef9](https://github.com/silverstripe/sapphire/commit/875eef9) Styled the php5 required page and fixed a couple of styling issues on the install page in IE. (Jeremy Bridson)
 * 2012-04-04 [a48254a](https://github.com/silverstripe/silverstripe-cms/commit/a48254a) styling added to delete install files warning box (Jeremy Bridson)
 * 2012-04-03 [63b23a2](https://github.com/silverstripe/sapphire/commit/63b23a2) incorporating "simple" theme into the the SS3 Install - styling the install page to fit with the "simple" theme (Jeremy Bridson)
 * 2012-04-03 [d71b04f](https://github.com/silverstripe/sapphire/commit/d71b04f) make gridfield status applied with header filter and header sort before print (Normann Lou)
 * 2012-04-03 [ba02e50](https://github.com/silverstripe/sapphire/commit/ba02e50) added GridFieldPrintButton compoonent (Normann Lou)
 * 2012-04-03 [00b904b](https://github.com/silverstripe/sapphire/commit/00b904b) make gridfield status applied with header filter and header sort before export (Normann Lou)
 * 2012-04-03 [fe28058](https://github.com/silverstripe/silverstripe-cms/commit/fe28058) renaming SSReportTest to Report test so it matches the name of Report.php (Julian Seidenberg)
 * 2012-04-03 [f1e0951](https://github.com/silverstripe/sapphire/commit/f1e0951) allow each dialog pop to have their own extra class. (Normann Lou)
 * 2012-03-30 [f34e58f](https://github.com/silverstripe/sapphire/commit/f34e58f) Enabled History.pushState() support in IE via onhashchange fallbacks (#7002) (Ingo Schommer)
 * 2012-03-30 [c0fd9bf](https://github.com/silverstripe/sapphire/commit/c0fd9bf) SSF-38 - Styled in-content file upload dialog box. Also added fixes for cms-content-header box-shadow. (Jeremy Bridson)
 * 2012-03-29 [ca83d84](https://github.com/silverstripe/sapphire/commit/ca83d84) SSF-38 added new template for the upload field that is used within a page image insertion dialog box. This upload field is slightly different from the one used in Files. E.g. it uses smaller fonts (h4 instead of h3) (Julian Seidenberg)
 * 2012-03-29 [9f9dc25](https://github.com/silverstripe/sapphire/commit/9f9dc25) SSF-38 initial rearranging of the insert image form to allow uploads as well as choosing an image from the CMS (and you can pick and choose from both) (Julian Seidenberg)
 * 2012-03-29 [c1b248e](https://github.com/silverstripe/silverstripe-cms/commit/c1b248e) SiteTree-&gt;getStatusFlags() which makes SiteTree-&gt;getTreeTitle() extensible (Normann Lou)
 * 2012-03-28 [3ae0ac7](https://github.com/silverstripe/sapphire/commit/3ae0ac7) Rightlick submenu styles and ability to add page with pagetype (Wolf Vollprecht)
 * 2012-03-27 [de2832e](https://github.com/silverstripe/sapphire/commit/de2832e) Allow Object::create() to be called with late static binding. (Andrew O'Neil)
 * 2012-03-27 [7c9a130](https://github.com/silverstripe/silverstripe-cms/commit/7c9a130) Sort extension names by alphabetical order in CMSFileAddController::getEditForm() ENHANCEMENT Ensure _t() used for "Allowed extensions" english text. (Sean Harvey)
 * 2012-03-27 [9e54124](https://github.com/silverstripe/silverstripe-cms/commit/9e54124) Indicate which file extensions are allowed to be uploaded when choosing a file to upload. (Sean Harvey)
 * 2012-03-26 [c9aa0e7](https://github.com/silverstripe/sapphire/commit/c9aa0e7) Before preforming an image resize, make sure it's actually required. (Simon Elvery)
 * 2012-03-26 [fd7f2eb](https://github.com/silverstripe/sapphire/commit/fd7f2eb) Use of Object::create('GridField') for Roles grid in SecurityAdmin, to be consistent with Members and Groups grid instantiation. MINOR Removing comments referring to CTF (Sean Harvey)
 * 2012-03-25 [fca60b7](https://github.com/silverstripe/sapphire/commit/fca60b7) Addition of ModelAdmin::getExportFields() which allows ModelAdmin classes to customise which fields should be exported. Defaults to the summary fields from the model class definition. (Sean Harvey)
 * 2012-03-25 [4bcd44a](https://github.com/silverstripe/sapphire/commit/4bcd44a) GridFieldExportButton now supports dot syntax for column sources through DataObject::relField() (Sean Harvey)
 * 2012-03-24 [e01b0aa](https://github.com/silverstripe/sapphire/commit/e01b0aa) PjaxResponseNegotiator for more structured partial ajax refreshes, applied in CMS and GridField. Also fixes issues with history.pushState() and pseudo-redirects on form submissions (e.g. from page/add to page/edit/show/&lt;new-record-id&gt;) (Sam Minnee)
 * 2012-03-24 [ffdf548](https://github.com/silverstripe/sapphire/commit/ffdf548) Adding missing MemberImportForm to SecurityAdmin, putting each importer into Users and Groups tab for context instead of Import tab, and fixing styling to be close to how it was in SS 2.4. (Sean Harvey)
 * 2012-03-20 [02c8019](https://github.com/silverstripe/sapphire/commit/02c8019) Introduce Database::prepStringForDB(), used by DBField::prepValueForDB() and StringField::prepValueForDB() to ensure the field value is escaped correctly for the database. This means databases like MSSQL can introduce an "N" prefix (marking text as unicode to be saved correctly) by overloading the prepStringForDB method. MySQL, PostgreSQL and SQLite3 operate as usual. (Sean Harvey)
 * 2012-03-19 [a18b9bd](https://github.com/silverstripe/silverstripe-cms/commit/a18b9bd) Flyout menu to directly choose the pagetype one wants to add. (Wolf Vollprecht)
 * 2012-03-16 [43d8c08](https://github.com/silverstripe/sapphire/commit/43d8c08) added cursor:pointer to arrows in the pages tree (Trac #6930) (jbridson)
 * 2012-03-16 [62ef8a2](https://github.com/silverstripe/sapphire/commit/62ef8a2) replaced text "Toggle Formatting Help" with a ? icon on edit profile Popup - Trac #6904 (jbridson)
 * 2012-03-15 [f5a91cb](https://github.com/silverstripe/sapphire/commit/f5a91cb) SS_Map_Iterator::rewind() SS_Map_Iterator::current() will return the titleField if there's a method of the same name (same behaviour as DataObjectSet::map() from SS 2.4) (Sean Harvey)
 * 2012-03-14 [5ce1dc1](https://github.com/silverstripe/sapphire/commit/5ce1dc1) Allow setting folderName to Upload in UploadField using setFolderName() (Sean Harvey)
 * 2012-03-14 [7f60ced](https://github.com/silverstripe/sapphire/commit/7f60ced) Allow disabling of File::updateFilesystem() which is useful for manually managing the filesystem paths instead. Defaults to on, but useful to turn off when loading File records in a YAML fixture for test data. (Sean Harvey)
 * 2011-11-27 [0a0be63](https://github.com/silverstripe/sapphire/commit/0a0be63) Added $exclusive flag to SS_ClassLoader-&gt;pushManifest() to allow for multiple manifests co-existing (useful for tests which rely on core classes but also want to test their own manifests) (Ingo Schommer)
 * 2011-04-12 [45c7dfd](https://github.com/silverstripe/sapphire/commit/45c7dfd) tests for new i18n syntax (Julian Seidenberg)

### Bugfixes

 * 2012-04-20 [13865cb](https://github.com/silverstripe/sapphire/commit/13865cb) Don't filter out attributes that are '0' (Simon Welsh)
 * 2012-04-20 [ee53df3](https://github.com/silverstripe/sapphire/commit/ee53df3) Removed assumption in GridFieldDataColumnsTest that Member would always have the same summary fields. (Robert Curry)
 * 2012-04-19 [80facbd](https://github.com/silverstripe/sapphire/commit/80facbd) Ensure merging correctly (Sean Harvey)
 * 2012-04-19 [63d91f9](https://github.com/silverstripe/sapphire/commit/63d91f9) Fixing broken labels in UploadField (Sean Harvey)
 * 2012-04-19 [9d36048](https://github.com/silverstripe/sapphire/commit/9d36048) Fixed a few references to non-existent $request variable. (Sam Minnee)
 * 2012-04-18 [14895a2](https://github.com/silverstripe/sapphire/commit/14895a2) Only call TinyMCE.init() once per window load (actual editor creation happens through new tinymce.Editor() (Ingo Schommer)
 * 2012-04-18 [ccb941e](https://github.com/silverstripe/sapphire/commit/ccb941e) Fixed places where Object::get_static() was being used. Replace with Config system instead. (Sean Harvey)
 * 2012-04-18 [4c6be29](https://github.com/silverstripe/sapphire/commit/4c6be29) Removing use of deprecated Object static functions like get_static(), set_static(), uninherited() etc. Replace with equivalent Config system get(), update() (Sean Harvey)
 * 2012-04-18 [926daa2](https://github.com/silverstripe/sapphire/commit/926daa2) Revert remove of function_exists() check for mcrypt in 7d84aff01e, as we don't expect mcrypt to actually be available, since fallbacks in RandomGenerator are available. (Sean Harvey)
 * 2012-04-18 [90ae0ed](https://github.com/silverstripe/sapphire/commit/90ae0ed) reverting back to Ingo's text collector from code, but using the parser to get from templates. Adding special case for _t functions in code that have an array in them. Fixing unit tests for all this. (Julian Seidenberg)
 * 2012-04-18 [a9e7de0](https://github.com/silverstripe/sapphire/commit/a9e7de0) make UploadField aware of relations to derived classes (os7140) (Mateusz Uzdowski)
 * 2012-04-18 [47d7392](https://github.com/silverstripe/sapphire/commit/47d7392) remove unnecessary write from uploading routine (Mateusz Uzdowski)
 * 2012-04-18 [a2c9c40](https://github.com/silverstripe/sapphire/commit/a2c9c40) fixed asserts and file cleanup (Mateusz Uzdowski)
 * 2012-04-18 [02abc42](https://github.com/silverstripe/sapphire/commit/02abc42) fixed unwanted box shadow on cms-panel-header when side panel is collapsed (Jeremy Bridson)
 * 2012-04-18 [0da62b9](https://github.com/silverstripe/sapphire/commit/0da62b9) fixing i18n _t function breaking out of when correct translation found (Julian Seidenberg)
 * 2012-04-18 [5e5c5de](https://github.com/silverstripe/sapphire/commit/5e5c5de) Fixed inconsistency in common_languages reference to Portuguese (#4911) (Sam Minnee)
 * 2012-04-18 [364d413](https://github.com/silverstripe/sapphire/commit/364d413) Send plaintext email as text/plain if there are no attachments. (#4603) (Sam Minnee)
 * 2012-04-18 [b075dc9](https://github.com/silverstripe/sapphire/commit/b075dc9) Fixes #6943 (Naomi Guyer)
 * 2012-04-18 [cc7a012](https://github.com/silverstripe/sapphire/commit/cc7a012) Use the copy of symfony-yaml bundled with Zend_Translate to prevent class conflicts.  Remove now-unnecessary symonfy-yaml thirdparty lib. (Sam Minnee)
 * 2012-04-17 [5bb31c4](https://github.com/silverstripe/sapphire/commit/5bb31c4) Stop "Insert Link" or "Insert Image" header disappearing inside the HtmlEditorField toolbar when clicking a link type (Sean Harvey)
 * 2012-04-17 [705a29d](https://github.com/silverstripe/sapphire/commit/705a29d) fix the ClassInfo::allClasses to fetch manifest data directly (Mateusz Uzdowski)
 * 2012-04-17 [f3137e5](https://github.com/silverstripe/sapphire/commit/f3137e5) Fixed regression where image and link popups don't open (Sean Harvey)
 * 2012-04-17 [de08c05](https://github.com/silverstripe/sapphire/commit/de08c05) Fixing reference to moved editor_plugin_src.js in HtmlEditorConfig settings (Sean Harvey)
 * 2012-04-17 [59663f9](https://github.com/silverstripe/sapphire/commit/59663f9) fix up some E_STRICT errors (Mateusz Uzdowski)
 * 2012-04-17 [5f73643](https://github.com/silverstripe/sapphire/commit/5f73643) Hardcoding locales in installer, because we can't include i18n properly, and including core/Core.php is too much. (Sean Harvey)
 * 2012-04-16 [192237c](https://github.com/silverstripe/sapphire/commit/192237c) fixes to i18n Unit Tests (Julian Seidenberg)
 * 2012-04-16 [e91c609](https://github.com/silverstripe/sapphire/commit/e91c609) fixed broken filter header styling in users (Jeremy Bridson)
 * 2012-04-16 [5686392](https://github.com/silverstripe/sapphire/commit/5686392) Fixes #7071. Change gridfield tests to not assume ids are always in order of addition. (Robert Curry)
 * 2012-04-16 [6ca7294](https://github.com/silverstripe/sapphire/commit/6ca7294) Fixed broken path, should be RailsYAML not RailsYaml (Sean Harvey)
 * 2012-04-16 [b34be81](https://github.com/silverstripe/sapphire/commit/b34be81) normalise the config file, PCRE does not handle Windows/Mac linebreaks (os7133) (Mateusz Uzdowski)
 * 2012-04-16 [dc0031c](https://github.com/silverstripe/sapphire/commit/dc0031c) Fixed broken installer trying to include i18n thirdparty Zend libs, which depends on Core.php being included first because include paths are setup there first. This has the effect of removing redundant code in the installer like temp path discovery, as Core takes care of that for us. (Sean Harvey)
 * 2012-04-15 [edaed5e](https://github.com/silverstripe/sapphire/commit/edaed5e) If SS_Backtrace::get_rendered_backtrace() has $plainText argument to TRUE, ensure there is no HTML in the output. (Sean Harvey)
 * 2012-04-14 [7e3a698](https://github.com/silverstripe/sapphire/commit/7e3a698) Fixed missing $properties arg to DatalessField::SmallFieldHolder (Sean Harvey)
 * 2012-04-14 [7df26fd](https://github.com/silverstripe/sapphire/commit/7df26fd) fix missing TabSet template from previous changes and selection group using wrong holder. (Will Rossiter)
 * 2012-04-13 [20aeb76](https://github.com/silverstripe/sapphire/commit/20aeb76) fixed overflow issues in cms-content-header with back button / breadcrumbs / tabs (Jeremy Bridson)
 * 2012-04-13 [7ae9f8a](https://github.com/silverstripe/sapphire/commit/7ae9f8a) match_function had been partially refactored to take $value as an argument rather than from the instance variable, but that hadnt been completed, causing problems with E_STRICT. This completes that refactoring. (Hamish Friedlander)
 * 2012-04-12 [9e95ba0](https://github.com/silverstripe/sapphire/commit/9e95ba0) Disable performance intensive Zend_Locale::isLocale() valiations in Zend_Translate_Adapter, which is only used for i18n class in SilverStripe core, so a controlled environment where valid locales are assumed (Ingo Schommer)
 * 2012-04-12 [8ea2460](https://github.com/silverstripe/sapphire/commit/8ea2460) make internal DataObject caches more consistent (os6175) (Mateusz Uzdowski)
 * 2012-04-12 [5186a0c](https://github.com/silverstripe/sapphire/commit/5186a0c) remove unnecessary setComponent call - no longer used (os6175) (Mateusz Uzdowski)
 * 2012-04-12 [aedadeb](https://github.com/silverstripe/sapphire/commit/aedadeb) adjust the cache flush and reset functions to cover all caches (os6175) (Mateusz Uzdowski)
 * 2012-04-12 [0dd4d43](https://github.com/silverstripe/sapphire/commit/0dd4d43) php-peg E_STRICT fixes (Sean Harvey)
 * 2012-04-12 [6b3d890](https://github.com/silverstripe/silverstripe-cms/commit/6b3d890) Fixed broken test LeftAndMain caused by createTag being called statically in AssetAdmin, when it shouldn't be (Sean Harvey)
 * 2012-04-12 [865cde0](https://github.com/silverstripe/sapphire/commit/865cde0) FormField::name_to_label() is now declared as static as it was never used as an instance method API CHANGE FormField::validate() $validator argument is now required for FormField classes (Sean Harvey)
 * 2012-04-12 [42988ec](https://github.com/silverstripe/sapphire/commit/42988ec) Argument hinting of FormField instance for TabSet::push() to comply with parent CompositeField::push() for E_STRICT compliance (Sean Harvey)
 * 2012-04-12 [fd3de51](https://github.com/silverstripe/sapphire/commit/fd3de51) Use of Link() in security classes now refers to $this-&gt;controller instead of calling the instance method Link statically (which isn't allowed for E_STRICT compliance.) (Sean Harvey)
 * 2012-04-12 [6b40377](https://github.com/silverstripe/sapphire/commit/6b40377) Time::setValue() now conforms to DBField::setValue() for E_STRICT compliance. (Sean Harvey)
 * 2012-04-12 [41433f1](https://github.com/silverstripe/sapphire/commit/41433f1) Fixing FulltextSearchable and Hierarchy to conform to the parent DataExtension for E_STRICT compliance. (Sean Harvey)
 * 2012-04-12 [a9f9505](https://github.com/silverstripe/sapphire/commit/a9f9505) File::ini2bytes() is now declared as static, as it was never an instance method (Sean Harvey)
 * 2012-04-12 [4c1aba8](https://github.com/silverstripe/sapphire/commit/4c1aba8) Object::get_extensions() is now declared as static, as it was never an instance method (Sean Harvey)
 * 2012-04-12 [452a507](https://github.com/silverstripe/sapphire/commit/452a507) remove form auto-detection from the generic JS state handler. (Mateusz Uzdowski)
 * 2012-04-12 [5e567cb](https://github.com/silverstripe/silverstripe-cms/commit/5e567cb) Declare StaticPublisher::set_static_publisher_theme() and StaticPublisher::static_publisher_theme() as static, since they're only called statically. This is a fix for E_STRICT compliance. (Sean Harvey)
 * 2012-04-12 [0daa76d](https://github.com/silverstripe/sapphire/commit/0daa76d) Issue #7113: Recalculate itemIteratorCount when popping viewer state. (Robert Curry)
 * 2012-04-11 [03a8aa5](https://github.com/silverstripe/silverstripe-cms/commit/03a8aa5) Only load existing languages in custom TinyMCE plugins to avoid the tinymce_gzip.php logic stalling (fixes #7035) (Mateusz Uzdowski)
 * 2012-04-11 [21bf409](https://github.com/silverstripe/sapphire/commit/21bf409) Pass arguments through to subtemplates when rendering those too (Hamish Friedlander)
 * 2012-04-11 [ca4e8e1](https://github.com/silverstripe/silverstripe-cms/commit/ca4e8e1) Fixed sort order of files and images GridField (Sam Minnee)
 * 2012-04-11 [adf658c](https://github.com/silverstripe/sapphire/commit/adf658c) Removed obsolete field File.Sort (Sam Minnee)
 * 2012-04-11 [81cc214](https://github.com/silverstripe/silverstripe-cms/commit/81cc214) SSF-124 remove one of the duplicated 'Any' options which also cause that search on the second 'Any' broke. (Normann Lou)
 * 2012-04-11 [35da0e9](https://github.com/silverstripe/silverstripe-cms/commit/35da0e9) SS-124 SearchForm clear button fixed (Normann Lou)
 * 2012-04-11 [778fd28](https://github.com/silverstripe/silverstripe-cms/commit/778fd28) Trac #6854 / #7115 - aligned action buttons in filter panel with the designs. (Jeremy Bridson)
 * 2012-04-11 [98399f7](https://github.com/silverstripe/sapphire/commit/98399f7) Trac #6854 / #7115 - fixed styling issues with filter panel across CMS - fixed the issue with the width of the date fields - aligned action buttons in filter panel with the designs. (Jeremy Bridson)
 * 2012-04-11 [240627b](https://github.com/silverstripe/silverstripe-cms/commit/240627b) Adding RedirectorPage.js to cms module (was in sapphire) and fixing to use entwine/jquery instead of old behaviour (Sean Harvey)
 * 2012-04-11 [75c5134](https://github.com/silverstripe/sapphire/commit/75c5134) Fix Money::setValue() using old api (Andrew O'Neil)
 * 2012-04-11 [8b44955](https://github.com/silverstripe/silverstripe-cms/commit/8b44955) Removed double check of find_old_page() in ModelAsController (Sean Harvey)
 * 2012-04-11 [c5aa074](https://github.com/silverstripe/sapphire/commit/c5aa074) Fix E_STRICT errors not being reported (Andrew O'Neil)
 * 2012-04-11 [6218aae](https://github.com/silverstripe/silverstripe-cms/commit/6218aae) SSF-124 the $filterOn pass-as-reference variable name should be consist with where its value is altered so as the variable is correctly assigned (Normann Lou)
 * 2012-04-11 [7c44e95](https://github.com/silverstripe/silverstripe-cms/commit/7c44e95) SSF-124 the $filterOn pass-as-reference variable name should be consist with where its value is altered so as the variable is correctly assigned MINOR SSF-124 correct inline document (Normann Lou)
 * 2012-04-11 [3d05666](https://github.com/silverstripe/silverstripe-cms/commit/3d05666) SSF-124 filter on a value only if this value is not an empty string (Normann Lou)
 * 2012-04-11 [2857737](https://github.com/silverstripe/sapphire/commit/2857737) SSF-124 / Trac#7105 - fixed issue with gridfield columns being too narrow. (Jeremy Bridson)
 * 2012-04-11 [213a08a](https://github.com/silverstripe/sapphire/commit/213a08a) Ensure site works if executed in a chrooted enviornment where BASE_PATH is '/'. (#4069) (Sam Minnee)
 * 2012-04-10 [a64715b](https://github.com/silverstripe/sapphire/commit/a64715b) Calling tinyMCE.init() in sync with entwine rules to avoid uncached loading interfereing with call order (fixes #6877) (Ingo Schommer)
 * 2012-04-10 [69e819a](https://github.com/silverstripe/silverstripe-cms/commit/69e819a) Moved 'rollback' logic back from CMSPageHistoryController to CMSMain (used in edit mode as well), removed unnecessary performRollback(), and introduced PJAX response handling to ensure the edit view is loaded correctly regardless of context (edit or history mode) (fixes #7108) (Ingo Schommer)
 * 2012-04-10 [f021b9e](https://github.com/silverstripe/silverstripe-cms/commit/f021b9e) Writing version in SiteTree-&gt;doRestoreToStage, regression from 9451993d (fixes #7107) (Ingo Schommer)
 * 2012-04-10 [6671ae7](https://github.com/silverstripe/sapphire/commit/6671ae7) SSF-124 remove $extraClass in the sortable header of GridField, simply add an 'col-$getName' as the distinguishable class for each column header, so as not to lose the css selector (Normann Lou)
 * 2012-04-10 [54905b0](https://github.com/silverstripe/sapphire/commit/54905b0) fixed width of dropdowns in filter side menu. (Jeremy Bridson)
 * 2012-04-10 [df38971](https://github.com/silverstripe/sapphire/commit/df38971) SSF-124 - fixed width of column and positioning of show children arrow in ie7 (Jeremy Bridson)
 * 2012-04-10 [bfb81fb](https://github.com/silverstripe/silverstripe-cms/commit/bfb81fb) SSF-124 fix issue that listchildren links for third level pages lost default ajax event bind (Normann Lou)
 * 2012-04-10 [97482f8](https://github.com/silverstripe/silverstripe-cms/commit/97482f8) Fix Breadcrumbs in ReportAdmin (Andrew O'Neil)
 * 2012-04-10 [93f1696](https://github.com/silverstripe/silverstripe-cms/commit/93f1696) SSF-124 linking to the correct page edit form in the list view (Julian Seidenberg)
 * 2012-04-10 [4a3a6d5](https://github.com/silverstripe/sapphire/commit/4a3a6d5) SSF-124 - removed styles to fix color of th text. (Jeremy Bridson)
 * 2012-04-10 [9183890](https://github.com/silverstripe/sapphire/commit/9183890) SSF-168 fixing Webkit rendering issue that would display elements outside of an absolute positioned layout, breaking the layout in the reportadmin section. The fix is to hide to container that breaks the layout and use js to move the required elements out of the container when the CMS needs them. (Julian Seidenberg)
 * 2012-04-10 [8292075](https://github.com/silverstripe/sapphire/commit/8292075) consolidated the btn_icons folder with the btn_icon folder in ../sapphire/admin/images (Jeremy Bridson)
 * 2012-04-10 [1176d8d](https://github.com/silverstripe/sapphire/commit/1176d8d) consolidated the btn_icons folder with the btn_icon folder in ../sapphire/admin/images (Jeremy Bridson)
 * 2012-04-10 [75c0937](https://github.com/silverstripe/sapphire/commit/75c0937) removed reference to compass generated sprite and added direct reference to the png file. (Jeremy Bridson)
 * 2012-04-10 [cb09ff7](https://github.com/silverstripe/sapphire/commit/cb09ff7) removed reference to compass generated sprite and added direct reference to the png file. (Jeremy Bridson)
 * 2012-04-10 [8df5cd7](https://github.com/silverstripe/silverstripe-cms/commit/8df5cd7) SSF-168 fixing "print" and "export to CSV" button in Report Admin (Julian Seidenberg)
 * 2012-04-10 [9356302](https://github.com/silverstripe/sapphire/commit/9356302) SSF-168 adding Grid field print header default of null (Julian Seidenberg)
 * 2012-04-10 [1742b4b](https://github.com/silverstripe/sapphire/commit/1742b4b) Fixed loading/saving regressions due to new PJAX logic introduced in e01b0aa3d03de2 (Ingo Schommer)
 * 2012-04-05 [e212e8c](https://github.com/silverstripe/sapphire/commit/e212e8c) fixed a couple of minor bugs - X-scrolling to 9999em on ModelAdmin and padding on active tabs in pages. (Jeremy Bridson)
 * 2012-04-05 [6f89fe0](https://github.com/silverstripe/sapphire/commit/6f89fe0) Show/hide correct fields when inserting a link in HtmlEditorField (Sean Harvey)
 * 2012-04-05 [ea377b6](https://github.com/silverstripe/silverstripe-cms/commit/ea377b6) fixing URL suggestion when changing the name of a page (Julian Seidenberg)
 * 2012-04-05 [8f5ec54](https://github.com/silverstripe/silverstripe-cms/commit/8f5ec54) SSF-124 remove Notice level message (Normann Lou)
 * 2012-04-05 [68aa59b](https://github.com/silverstripe/silverstripe-cms/commit/68aa59b) SSF-168 fixing rendering issue in Chrome, which displays extra control at the bottom of the window in a report that is of a certain length (Julian Seidenberg)
 * 2012-04-05 [6c697e5](https://github.com/silverstripe/sapphire/commit/6c697e5) SSF-38 - fixed the issue with the size of the popup being to large on-load - added overflow scroll. Altered the header and tabs to match the style of edit profile. (Jeremy Bridson)
 * 2012-04-05 [b1e286c](https://github.com/silverstripe/silverstripe-cms/commit/b1e286c) SSF-168 fixing bug in report admin where back button didn't work (Julian Seidenberg)
 * 2012-04-05 [64d0cba](https://github.com/silverstripe/sapphire/commit/64d0cba) SSF-38 hiding the insert image controls when editing an already inserted image. (Julian Seidenberg)
 * 2012-04-04 [076f1a8](https://github.com/silverstripe/sapphire/commit/076f1a8) Fixed GridField edit link appearing 9999px off screen, should not be visible as the icon replaces the link text. (Sean Harvey)
 * 2012-04-04 [029f833](https://github.com/silverstripe/silverstripe-cms/commit/029f833) use getName() for FormField object since Name() has been deprecated in SilverStripe 3 (Normann Lou)
 * 2012-04-04 [7f8a682](https://github.com/silverstripe/sapphire/commit/7f8a682) SSF-38 fixing the "Choose files from your computer" upload field (Julian Seidenberg)
 * 2012-04-04 [070c9c2](https://github.com/silverstripe/silverstripe-cms/commit/070c9c2) Removed used of deprecated Name() method in AssetAdmin (Sean Harvey)
 * 2012-04-04 [95cdfd7](https://github.com/silverstripe/sapphire/commit/95cdfd7) destroy $item in the scope of where $item is defined for GridFieldPrintButton-&gt;generatePrintData. (Normann Lou)
 * 2012-04-03 [cebe2fc](https://github.com/silverstripe/sapphire/commit/cebe2fc) removed header from edit profile popup and restyled broken tabs - still needs a proper fix after beta II. (Jeremy Bridson)

...

 * 2012-04-03 [5c3c3cb](https://github.com/silverstripe/sapphire/commit/5c3c3cb) SSF-38 removing the z-index on the TabSet so that the upload button works in the HtmlEditorField insert image lightbox. (Julian Seidenberg)
 * 2012-04-02 [a2979f0](https://github.com/silverstripe/sapphire/commit/a2979f0) Ensure that origLayoutClasses is always an array when considered empty, as join() will be called later and causes a JS error on an empty string. (Sean Harvey)
 * 2012-04-02 [8926741](https://github.com/silverstripe/sapphire/commit/8926741) When inserting an image in HtmlEditorField, don't append "px" as the width and height attributes only accept a number without a unit (Sean Harvey)
 * 2012-03-30 [6c91aa0](https://github.com/silverstripe/sapphire/commit/6c91aa0) Force referer via "BackURL" POST data in CMS to work around IE problems with sending the base URL as the referer instead of the actual one (#7002) (Ingo Schommer)
 * 2012-03-30 [1091c7b](https://github.com/silverstripe/sapphire/commit/1091c7b) Don't replace pushState() if emulated, as it will re-load the new URL via ajax, effectively duplicating every request in IE (#7002) (Ingo Schommer)
 * 2012-03-30 [e6aa9ae](https://github.com/silverstripe/sapphire/commit/e6aa9ae) Fixed History.js library handling of relative URLs combined with a base URL (was causing infinite loops, e.g. /admin/#/admin/admin/admin/security) (#7002) (Ingo Schommer)
 * 2012-03-30 [c518a19](https://github.com/silverstripe/sapphire/commit/c518a19) Replaced logic for checking external URLs in CMS Menu with more stable jQuery Mobile codebase (fixes problems on IE not loading menu entries via ajax) (#7002) (Ingo Schommer)
 * 2012-03-30 [58433d3](https://github.com/silverstripe/sapphire/commit/58433d3) Tidied up relObject() behaviour on DataLists to restore broken SearchContext functionality. (Sam Minnee)
 * 2012-03-30 [2110906](https://github.com/silverstripe/sapphire/commit/2110906) SSF-38 making the entwine selector for the upload field more specific, so it doesn't apply to every upload field in the CMS. Also, handling the case of uploading multiple files at once (Julian Seidenberg)
 * 2012-03-28 [1a81c3d](https://github.com/silverstripe/sapphire/commit/1a81c3d) The SilverStripe installer throwing warning on settings that was legit. (Stig Lindqvist)
 * 2012-03-27 [7a27832](https://github.com/silverstripe/sapphire/commit/7a27832) fix the field generated by choser with 0 width in an iFrame popup (Normann Lou)
 * 2012-03-27 [97aa2c8](https://github.com/silverstripe/sapphire/commit/97aa2c8) adjusted padding so that content aligns properly on the add page panel Trac #6990 (jbridson)
 * 2012-03-27 [9a301e3](https://github.com/silverstripe/sapphire/commit/9a301e3) Empty error message on renaming a page and confirming url is changed accordingly (Normann Lou)
 * 2012-03-27 [1311ba2](https://github.com/silverstripe/silverstripe-cms/commit/1311ba2) Empty error message on renaming a page and confirming url is changed accordingly (trac ticket 7068) (Normann Lou)
 * 2012-03-27 [c02b441](https://github.com/silverstripe/sapphire/commit/c02b441) Using DateField "dmyfields" option, if you set empty day/month/year values, valueObj on DateField will contain erroneous values. Check that all the value inputs aren't null or empty values BEFORE calling Zend_Date on the value. (Sean Harvey)
 * 2012-03-27 [66f537d](https://github.com/silverstripe/sapphire/commit/66f537d) when apply a bugfix patch, there is one missing variable missing, add it. (Normann Lou)
 * 2012-03-27 [10f030d](https://github.com/silverstripe/silverstripe-cms/commit/10f030d) When adding a top level folder in AssetAdmin, ensure you are taken back to the top level folder view. Currently there is a non-object error adding a root level folder. (Sean Harvey)
 * 2012-03-26 [bd95bca](https://github.com/silverstripe/sapphire/commit/bd95bca) Nested Group records should be removed, along with the parent. (Sean Harvey)
 * 2012-03-25 [ec02ab6](https://github.com/silverstripe/sapphire/commit/ec02ab6) Fixed FulltextSearchable checking DB::getConn() unncessarily for MySQL, as Database::requireTable() will only apply create_table_options to the database adapter they're set for. Replace Object::add_static_var usage (deprecated) with the new config system instead. (Sean Harvey)
 * 2012-03-24 [42b7ab1](https://github.com/silverstripe/silverstripe-cms/commit/42b7ab1) Prevent JS errors when widget area is loaded (note: doesn't actually fix it fully yet) (Sam Minnee)
 * 2012-03-24 [f5f655b](https://github.com/silverstripe/sapphire/commit/f5f655b) Show a correct growl message when ajax returns a JS error rather than HTTP error. (Sam Minnee)
 * 2012-03-24 [21d52d3](https://github.com/silverstripe/sapphire/commit/21d52d3) #7018 This stops an infinite loop when Depreciation::notice is called from set_dev_servers(). This doesn't stop people from setting $dev_servers directly (not that it is used in the core code anywhere). (Gareth Foster)
 * 2012-03-24 [39742f5](https://github.com/silverstripe/sapphire/commit/39742f5) #7036 refresh CMS panel when adding a new file (Will Rossiter)
 * 2012-03-24 [dee3939](https://github.com/silverstripe/sapphire/commit/dee3939) Fix the broken perform readonly transformation which was always showing NO (#6453) (Nicolaas)
 * 2012-03-24 [71f37b9](https://github.com/silverstripe/sapphire/commit/71f37b9) #6840 Fix navigation highlights on LeftAndMain (Will Rossiter)
 * 2012-03-24 [fa999ca](https://github.com/silverstripe/sapphire/commit/fa999ca) TableListField should only include CSS from the cms if the cms exists. (Simon Welsh)
 * 2012-03-24 [e81f11a](https://github.com/silverstripe/silverstripe-installer/commit/e81f11a) Correct location of bootstrap file so phpunit CLI works. (#7001) (Sam Minnee)
 * 2012-03-24 [39d3761](https://github.com/silverstripe/sapphire/commit/39d3761) #6934 allow whole TreeDropdownField to be clicked (Will Rossiter)
 * 2012-03-24 [767aef9](https://github.com/silverstripe/sapphire/commit/767aef9) Don't call strpos() with an empty delimiter, mb_strpos() is more strict about this (#6751) (Sam Minnee)
 * 2012-03-21 [ac8a05f](https://github.com/silverstripe/sapphire/commit/ac8a05f) Make sure the translation function doesn't try to include missing locale files over and over again. (Simon Elvery)
 * 2012-03-21 [86ef281](https://github.com/silverstripe/sapphire/commit/86ef281) #7019 Fix SQL error when building database after adding a Member DataExtension in non-dev mode (Andrew O'Neil)
 * 2012-03-19 [f85f30a](https://github.com/silverstripe/sapphire/commit/f85f30a) DropdownField with SS_Map as the source should use empty string as the value, and the empty string text as the title, not the other way around. (Sean Harvey)
 * 2012-03-19 [31d4629](https://github.com/silverstripe/sapphire/commit/31d4629) removed the float from the li (checkboxes) in members permissions... fixed layout issues Trac #6958 (jbridson)
 * 2012-03-19 [83be1a8](https://github.com/silverstripe/sapphire/commit/83be1a8) removed unnecessary horizontal line from new members page and replaced cms-help-toggle text with ?icon Trac #6956 (jbridson)
 * 2012-03-19 [1d5065f](https://github.com/silverstripe/sapphire/commit/1d5065f) Removed reference to non-existence function Form::handleAction(). (Sam Minnee)
 * 2012-03-19 [a2c1858](https://github.com/silverstripe/sapphire/commit/a2c1858) Return a 404, not a 500, if an invalid action is asked for on a RequestHandler. (Sam Minnee)
 * 2012-03-19 [9bb3104](https://github.com/silverstripe/silverstripe-cms/commit/9bb3104) fixed padding issues with navigation tabs on Asset Admin (jbridson)
 * 2012-03-19 [6fb95e0](https://github.com/silverstripe/sapphire/commit/6fb95e0) fixed padding issues with navigation tabs across the CMS (jbridson)
 * 2012-03-19 [067204d](https://github.com/silverstripe/sapphire/commit/067204d) Prevent 500 error when a HEAD request is sent to its action URL. (Sam Minnee)
 * 2012-03-17 [b9ab70a](https://github.com/silverstripe/sapphire/commit/b9ab70a) Don't try setting the value attribute on DropdownField or its subclasses. (Simon Welsh)
 * 2012-03-16 [064a36e](https://github.com/silverstripe/sapphire/commit/064a36e) fixed alignment of create and delete buttons across the CMS - Trac #6955 (jbridson)
 * 2012-03-16 [1a66ecd](https://github.com/silverstripe/sapphire/commit/1a66ecd) fixed styling issues on edit profile dialog popup - Trac #6819 (jbridson)
 * 2012-03-15 [fc9e065](https://github.com/silverstripe/sapphire/commit/fc9e065) Don't show "Import" header if ImportForm isn't available in ModelAdmin_Tools template (Sean Harvey)
 * 2012-03-15 [069d711](https://github.com/silverstripe/sapphire/commit/069d711) Remove stray scrolling and zooming glitches on iPad. (Sam Minnee)
 * 2012-03-14 [2555ccb](https://github.com/silverstripe/sapphire/commit/2555ccb) Qualify join table in ON clause in ManyManyList to avoid ambiguous column names (Ingo Schommer)
 * 2012-03-14 [687a1ca](https://github.com/silverstripe/sapphire/commit/687a1ca) Don't include has_many/many_many relationships in DataObject-&gt;scaffoldFormFields() when the record doesn't have an ID yet - as the scaffolded GridFieldAddExistingAutocompleter component assumes the component has an ID to query against  (fixes #5723) (Ingo Schommer)
 * 2012-03-13 [ddcf979](https://github.com/silverstripe/silverstripe-cms/commit/ddcf979) Trac Ticket #7015 - removed unnecessary scrollbars from files and images filter and increased height of search field to accommodate the dropdown. (jbridson)
 * 2012-03-13 [bdb832e](https://github.com/silverstripe/silverstripe-cms/commit/bdb832e) SSF-30 - Fixed dropdown cutoff in all browsers. (jbridson)
 * 2012-03-11 [5954774](https://github.com/silverstripe/sapphire/commit/5954774) Use UTC consistently across all tests for date/time calculations (Fred Condo)
 * 2012-03-09 [5b4f83a](https://github.com/silverstripe/sapphire/commit/5b4f83a) #6853 Necessary styles required to complement work on same-indexed commit in cms project (Russell Michell)
 * 2011-12-04 [0e0e5dd](https://github.com/silverstripe/sapphire/commit/0e0e5dd) Ensuring that every locale (and its lang part) are registered as languages in i18n::include_by_locale() to avoid expensive re-parsing on subsequent i18n::_t() calls to the same locale (Ingo Schommer)
 * 2011-04-14 [f926242](https://github.com/silverstripe/sapphire/commit/f926242) fixed a template so it can parsed by the new parser (Julian Seidenberg)

### Minor changes

 * 2012-04-20 [33ae836](https://github.com/silverstripe/sapphire/commit/33ae836) Lowered 5.3.10 recommendation to 5.3.4 (Sam Minnee)
 * 2012-04-20 [82ca56d](https://github.com/silverstripe/sapphire/commit/82ca56d) Remove .svn folder (Simon Welsh)
 * 2012-04-19 [baae13c](https://github.com/silverstripe/sapphire/commit/baae13c) Fixing default en string for FROMCOMPUTER (Sean Harvey)
 * 2012-04-19 [2b5a906](https://github.com/silverstripe/sapphire/commit/2b5a906) Doc anchors so we can link to sections from other release notes (Ingo Schommer)
 * 2012-04-19 [3616fb0](https://github.com/silverstripe/sapphire/commit/3616fb0) Documentation for new Config system and DataExtension/extraStatics when upgrading (Sean Harvey)
 * 2012-04-18 [0e071c9](https://github.com/silverstripe/silverstripe-cms/commit/0e071c9) Fixed tests broken by recent CMS search and breadcrumbs changes (Ingo Schommer)
 * 2012-04-18 [1b3a634](https://github.com/silverstripe/silverstripe-cms/commit/1b3a634) Fixed hardcoded links from admin/page to admin/pages (Ingo Schommer)
 * 2012-04-18 [e4c3368](https://github.com/silverstripe/sapphire/commit/e4c3368) Pointer to new widget module location in docs (Ingo Schommer)
 * 2012-04-18 [4fd7573](https://github.com/silverstripe/silverstripe-cms/commit/4fd7573) Consistent link method names: LeftAndMain-&gt;PreviewLink() changed to LinkPreview() (Ingo Schommer)
 * 2012-04-18 [d8bb1b2](https://github.com/silverstripe/sapphire/commit/d8bb1b2) Consistent link method names: LeftAndMain-&gt;PreviewLink() changed to LinkPreview() (Ingo Schommer)
 * 2012-04-18 [ed5110d](https://github.com/silverstripe/sapphire/commit/ed5110d) Self-closing input tab in HIddenField to keep broadest markup compliance by default (Ingo Schommer)
 * 2012-04-18 [1408198](https://github.com/silverstripe/sapphire/commit/1408198) Fixing display of tree checkboxes (Ingo Schommer)
 * 2012-04-18 [57ee9bf](https://github.com/silverstripe/sapphire/commit/57ee9bf) Removed unnecessary jquery.livequery include from CMS, its still processing in the background = performance overhead (Ingo Schommer)
 * 2012-04-18 [e40455f](https://github.com/silverstripe/sapphire/commit/e40455f) Fixed tabset/breadcrumb tabular styling, avoid tabs overflowing into hidden space (still needs more work to fix properly) (Ingo Schommer)
 * 2012-04-18 [f26951c](https://github.com/silverstripe/sapphire/commit/f26951c) Don't try to remove editor containers before they exist (Ingo Schommer)
 * 2012-04-18 [16e950c](https://github.com/silverstripe/sapphire/commit/16e950c) Tidy up of code formatting in TestRunner MINOR Fixing up old ObjectStaticTest and merging into ConfigTest (Sean Harvey)
 * 2012-04-18 [93fcb86](https://github.com/silverstripe/sapphire/commit/93fcb86) removing unused file (Julian Seidenberg)
 * 2012-04-18 [7710cf5](https://github.com/silverstripe/sapphire/commit/7710cf5) updating the documentation (Julian Seidenberg)
 * 2012-04-18 [5d7f6a0](https://github.com/silverstripe/sapphire/commit/5d7f6a0) add some comments to UploadField (Mateusz Uzdowski)
 * 2012-04-18 [fb3b03f](https://github.com/silverstripe/sapphire/commit/fb3b03f) Remove support for PHP &lt;5.3.2 (Andrew O'Neil)
 * 2012-04-18 [180a305](https://github.com/silverstripe/sapphire/commit/180a305) Whitespace cleanup ticket 6943 (Naomi Guyer)
 * 2012-04-18 [14c0796](https://github.com/silverstripe/sapphire/commit/14c0796) Remove checks for PHP &lt; 5.3.2, as it's no longer supported (Andrew O'Neil)
 * 2012-04-18 [d1c500a](https://github.com/silverstripe/silverstripe-cms/commit/d1c500a) Remove checks for PHP &lt;5.3.2, as it's no longer supported (Andrew O'Neil)
 * 2012-04-17 [65fc81f](https://github.com/silverstripe/sapphire/commit/65fc81f) Removed Group-&gt;CMSTreeClasses(), no longer shown as a tree (Ingo Schommer)
 * 2012-04-17 [473d3a6](https://github.com/silverstripe/sapphire/commit/473d3a6) Fixed controller contexts in LeftAndMain-&gt;SiteTreeAsUL() - needs different context for edit links and determining "current page" (not applicable for CMSPagesController) (Ingo Schommer)
 * 2012-04-17 [35d4cd3](https://github.com/silverstripe/sapphire/commit/35d4cd3) PJAX support for .cms-panel-link (Ingo Schommer)
 * 2012-04-17 [75da9fd](https://github.com/silverstripe/silverstripe-cms/commit/75da9fd) Renamed .ss-tabset to .cms-tabset in CMS templates in order to have more entwine flexibility (Ingo Schommer)
 * 2012-04-17 [84b0a7d](https://github.com/silverstripe/sapphire/commit/84b0a7d) Renamed .ss-tabset to .cms-tabset in cms templates to distinguish entwine selectors and add extra functionality (cookies, re-selecting tab, panel loading) (Ingo Schommer)
 * 2012-04-17 [3777761](https://github.com/silverstripe/sapphire/commit/3777761) Ignore aborted ajax requests in CMS notifications (Ingo Schommer)
 * 2012-04-17 [5813a94](https://github.com/silverstripe/sapphire/commit/5813a94) Cleaning up spaces and replace with tabs (Sean Harvey)
 * 2012-04-16 [0ef5d0b](https://github.com/silverstripe/sapphire/commit/0ef5d0b) Moved tree filtering in LeftAndMain from SiteTreeAsUL() into getSiteTreeFor() to allow filtering the initial tree (via GET parameters), rather than just through getsubtree() (Ingo Schommer)
 * 2012-04-16 [9b2b39a](https://github.com/silverstripe/sapphire/commit/9b2b39a) More specific tree links, to ensure correct CMSMain subclass is used (Ingo Schommer)
 * 2012-04-16 [ee70e0a](https://github.com/silverstripe/sapphire/commit/ee70e0a) Fixed returns of Form-&gt;unsetValidator() (Ingo Schommer)
 * 2012-04-16 [6bee103](https://github.com/silverstripe/sapphire/commit/6bee103) Removed hardcoded children entries from CMS Menu (and record setting logic), as the related controllers have been merged to be accessible under the same top-level menu (Ingo Schommer)
 * 2012-04-16 [51b5120](https://github.com/silverstripe/sapphire/commit/51b5120) Documentation about renaming sapphire to framework (Sean Harvey)
 * 2012-04-16 [bbf04ee](https://github.com/silverstripe/sapphire/commit/bbf04ee) Removed function_exists() checks which aren't necessary for PHP 5.2+ (Sean Harvey)
 * 2012-04-16 [1aa919d](https://github.com/silverstripe/sapphire/commit/1aa919d) Fixed broken SecurityTest, missing entry in en.yml for ERRORWRONGCRED (Sean Harvey)
 * 2012-04-16 [e6007c2](https://github.com/silverstripe/sapphire/commit/e6007c2) Removed redundant system temp path discovery in tiny_mce_gzip, juse use sys_get_temp_dir() instead which is always available. (Sean Harvey)
 * 2012-04-16 [4a30707](https://github.com/silverstripe/sapphire/commit/4a30707) Fixed tests (Sean Harvey)
 * 2012-04-16 [d0984ec](https://github.com/silverstripe/sapphire/commit/d0984ec) Line break after sentence of message (Sean Harvey)
 * 2012-04-16 [a89228e](https://github.com/silverstripe/sapphire/commit/a89228e) Fix deprecation notice when saving user settings (Andrew O'Neil)
 * 2012-04-16 [4057956](https://github.com/silverstripe/silverstripe-cms/commit/4057956) Use ajax to load reports (Andrew O'Neil)
 * 2012-04-16 [3b9f993](https://github.com/silverstripe/sapphire/commit/3b9f993) Use config system for cms title, rather than eval. (Andrew O'Neil)
 * 2012-04-16 [fb5f948](https://github.com/silverstripe/silverstripe-cms/commit/fb5f948) Fix Pages title (Andrew O'Neil)
 * 2012-04-15 [7ce1572](https://github.com/silverstripe/sapphire/commit/7ce1572) Stability fixes on new tokenizer implementation of i18nTextCollector, allowing to specify writer and locale arguments on task execution (Ingo Schommer)
 * 2012-04-15 [1334711](https://github.com/silverstripe/sapphire/commit/1334711) Removed outdated docs about missing template iterators (Ingo Schommer)
 * 2012-04-15 [d9e7408](https://github.com/silverstripe/silverstripe-cms/commit/d9e7408) Removed empty language defynition (Ingo Schommer)
 * 2012-04-15 [6e13512](https://github.com/silverstripe/sapphire/commit/6e13512) Fixed up some language mappings in i18n (slightly different locales exported from getlocalization.com) (Ingo Schommer)
 * 2012-04-15 [ef5e639](https://github.com/silverstripe/sapphire/commit/ef5e639) Don't break on empty YAML files (Ingo Schommer)
 * 2012-04-15 [ce1ed8e](https://github.com/silverstripe/silverstripe-cms/commit/ce1ed8e) Using SS locale notation for new YAML files (underscore instead of dashed) (Ingo Schommer)
 * 2012-04-15 [a452b6a](https://github.com/silverstripe/sapphire/commit/a452b6a) Using SS locale notation for new YAML files (underscore instead of dashed) (Ingo Schommer)
 * 2012-04-15 [c649fa3](https://github.com/silverstripe/sapphire/commit/c649fa3) Workaround for duplicate require_once calls of same class in two locations (SS core and Zend_Translate_RailsYAML) (Ingo Schommer)
 * 2012-04-15 [d3b63da](https://github.com/silverstripe/sapphire/commit/d3b63da) Allowing to flush translation cache through ?flush=1 (Ingo Schommer)
 * 2012-04-15 [d57e864](https://github.com/silverstripe/sapphire/commit/d57e864) Fixed tests related to i18nLegacyAdapter changes (Ingo Schommer)
 * 2012-04-15 [ebe75fe](https://github.com/silverstripe/sapphire/commit/ebe75fe) Update locations to server requirements page (Sean Harvey)
 * 2012-04-15 [515a2cc](https://github.com/silverstripe/sapphire/commit/515a2cc) Updating old URLs in installer, show message about creating admin account (Sean Harvey)
 * 2012-04-15 [e71b8d6](https://github.com/silverstripe/sapphire/commit/e71b8d6) Installer cleanups, removing references to old "command line installation" which is no longer supported. MINOR Removed stray semi-colon when showing version in installer template. (Sean Harvey)
 * 2012-04-15 [befbd3e](https://github.com/silverstripe/sapphire/commit/befbd3e) remove reference to sapphire in CMSVersion (Will Rossiter)
 * 2012-04-15 [4718f14](https://github.com/silverstripe/silverstripe-cms/commit/4718f14) look for framework version in framework path rather than CMS path (Will Rossiter)
 * 2012-04-15 [39966a8](https://github.com/silverstripe/silverstripe-installer/commit/39966a8) Ensure "phing update_modules" updates from master, not 2.4.5 (that is done in the 2.4 branch) (Sean Harvey)
 * 2012-04-15 [effc654](https://github.com/silverstripe/sapphire/commit/effc654) Moved ModulePath to GenericTemplateGlobalProvider (Sean Harvey)
 * 2012-04-15 [f57a763](https://github.com/silverstripe/sapphire/commit/f57a763) Ensure incomplete tests also have a backtrace (Sean Harvey)
 * 2012-04-14 [d7973ea](https://github.com/silverstripe/sapphire/commit/d7973ea) Don't show warning if running tests (Sean Harvey)
 * 2012-04-14 [b2d602f](https://github.com/silverstripe/sapphire/commit/b2d602f) Formatting code text properly in changelog (Sean Harvey)
 * 2012-04-14 [448a729](https://github.com/silverstripe/silverstripe-installer/commit/448a729) Removed unused rewritetest.php (Sean Harvey)
 * 2012-04-14 [b755ab6](https://github.com/silverstripe/sapphire/commit/b755ab6) Update docs about sapphire rename, ModulePath template variable (Sean Harvey)
 * 2012-04-14 [3450bad](https://github.com/silverstripe/silverstripe-installer/commit/3450bad) Tweaking words on framework missing (Sean Harvey)
 * 2012-04-14 [01e0ce7](https://github.com/silverstripe/sapphire/commit/01e0ce7) Ensure assertions of RequirementsTest use "framework" as the FRAMEWORK_DIR, otherwise assertions of require() calls in RequirementsTest_Conditionals template fail (Sean Harvey)
 * 2012-04-14 [d4750c2](https://github.com/silverstripe/silverstripe-cms/commit/d4750c2) group ShowInMenus and ShowInSearch check boxes. Fixes #6901 (Will Rossiter)
 * 2012-04-14 [8531525](https://github.com/silverstripe/silverstripe-cms/commit/8531525) remove $template var as sapphire/07d2d52 will pick this up automatically (Will Rossiter)
 * 2012-04-14 [f238fa4](https://github.com/silverstripe/sapphire/commit/f238fa4) Fallbacks for _register_database path when FRAMEWORK_PATH isn't available yet (during installation) (Sean Harvey)
 * 2012-04-14 [c45027d](https://github.com/silverstripe/sapphire/commit/c45027d) Fix tests to check against dynamic FRAMEWORK_DIR and $project instead of hardcoding these checks (Sean Harvey)
 * 2012-04-14 [6405c44](https://github.com/silverstripe/sapphire/commit/6405c44) Enable the highest level of error_reporting() in install, to be consistent with Core.php (Sean Harvey)
 * 2012-04-14 [de258e8](https://github.com/silverstripe/silverstripe-cms/commit/de258e8) Updated lang file based on new YML generation (Ingo Schommer)
 * 2012-04-14 [f61dbfd](https://github.com/silverstripe/sapphire/commit/f61dbfd) Updated lang file to new generated YML format (Ingo Schommer)
 * 2012-04-14 [d44f6b3](https://github.com/silverstripe/sapphire/commit/d44f6b3) Removed deprecated usage of $priority argument in _t() calls (Ingo Schommer)
 * 2012-04-13 [52e69dd](https://github.com/silverstripe/silverstripe-cms/commit/52e69dd) Removed usage of deprecated $priority argument for _t() (Ingo Schommer)
 * 2012-04-13 [d9c4aa8](https://github.com/silverstripe/silverstripe-cms/commit/d9c4aa8) Using new DataObject::fieldLabels() caching in SiteTree (Ingo Schommer)
 * 2012-04-13 [b81863c](https://github.com/silverstripe/sapphire/commit/b81863c) Caching DataObject-&gt;fieldLabels() in memory, to avoid _t() being called excessively through fieldLabel() (Ingo Schommer)
 * 2012-04-13 [3002598](https://github.com/silverstripe/sapphire/commit/3002598) Hardcoding correct module priorities in i18n.php (Ingo Schommer)
 * 2012-04-13 [3572b31](https://github.com/silverstripe/sapphire/commit/3572b31) Default app title when SiteConfig object is not present (fixes #7114) (Ingo Schommer)
 * 2012-04-13 [dc0168d](https://github.com/silverstripe/silverstripe-cms/commit/dc0168d) Removed $params argument to DataObject-&gt;getCMSFields(), please use FormScaffolder directly (fixes #7135) (Ingo Schommer)
 * 2012-04-13 [0f8a699](https://github.com/silverstripe/sapphire/commit/0f8a699) Passing rendered form to renderWith() call, underlying logic changed (see #7136) (Ingo Schommer)

...

 * 2012-04-13 [b127419](https://github.com/silverstripe/silverstripe-cms/commit/b127419) HTML5 for BlankPage.ss default template (Ingo Schommer)
 * 2012-04-13 [fc5592e](https://github.com/silverstripe/sapphire/commit/fc5592e) PHP-PEG is now triple licensed under BSD, MPL and GPL by request (Hamish Friedlander)
 * 2012-04-13 [aa14a51](https://github.com/silverstripe/sapphire/commit/aa14a51) Temporarily disabled E_STRICT until we can solve Debug issues with SS error handler (Sean Harvey)
 * 2012-04-13 [1e2d816](https://github.com/silverstripe/sapphire/commit/1e2d816) HTML5 for BlankPage.ss default template (Ingo Schommer)
 * 2012-04-12 [e91d490](https://github.com/silverstripe/silverstripe-cms/commit/e91d490) Using loadPanel() rather than removed duplicate loadForm() method (Ingo Schommer)
 * 2012-04-12 [e2df1f4](https://github.com/silverstripe/sapphire/commit/e2df1f4) Removed $('.cms-content').loadForm(), its very similar to loadPanel() - accepts callbacks, but that's not specific to forms. Listen to 'afterstatechange' rather than 'loadform' events (Ingo Schommer)
 * 2012-04-12 [9b79827](https://github.com/silverstripe/silverstripe-cms/commit/9b79827) Decoupling dialog logic from tinymce_ssbuttons plugin to allow for lazy loaded dialogs (Ingo Schommer)
 * 2012-04-12 [c73b800](https://github.com/silverstripe/sapphire/commit/c73b800) Removed usage of deprecated Object::uninherited_static() in core, improves CMS loading speed in live mode by ~3.5% (Ingo Schommer)
 * 2012-04-12 [0fd7ce6](https://github.com/silverstripe/sapphire/commit/0fd7ce6) Added PJAX and ajax redirect documentation to cms-archirecture reference guide (Ingo Schommer)
 * 2012-04-12 [5cfbac6](https://github.com/silverstripe/sapphire/commit/5cfbac6) Fixed PJAX panel loading when .cms-content is a split panel with tree and form view (regression caused by 452a507cc9f) (Ingo Schommer)
 * 2012-04-12 [f26d0bc](https://github.com/silverstripe/silverstripe-cms/commit/f26d0bc) Removed SideReportsForm JS logic, interface element no longer exists (Ingo Schommer)
 * 2012-04-12 [b8e86ae](https://github.com/silverstripe/silverstripe-cms/commit/b8e86ae) Add newline to end of files without one (Simon Welsh)
 * 2012-04-12 [9fdcf34](https://github.com/silverstripe/sapphire/commit/9fdcf34) Updated PHP requirement in docs (#7129) (Sam Minnee)
 * 2012-04-12 [f07258f](https://github.com/silverstripe/sapphire/commit/f07258f) Update @package values to match renaming sapphire (Simon Welsh)
 * 2012-04-12 [b52c6b4](https://github.com/silverstripe/sapphire/commit/b52c6b4) Testing extended dates (very far in the past and future) in DateTest (Sean Harvey)
 * 2012-04-12 [77c95b3](https://github.com/silverstripe/sapphire/commit/77c95b3) Hamish is all class. ;-) (Sam Minnee)
 * 2012-04-12 [360e9df](https://github.com/silverstripe/sapphire/commit/360e9df) fix typo (Mateusz Uzdowski)
 * 2012-04-12 [52710eb](https://github.com/silverstripe/silverstripe-cms/commit/52710eb) Added SHOW_DELETED_PAGES Polish translation. (#4407) (Sam Minnee)
 * 2012-04-12 [aa659a2](https://github.com/silverstripe/sapphire/commit/aa659a2) Fixed classname displayed in Hierarchy::markChildren() error. (#4406) (Sam Minnee)
 * 2012-04-12 [852ffcf](https://github.com/silverstripe/sapphire/commit/852ffcf) MemberDatetimeOptionsetField::validate() now passes in $validator argument instead of getting it from the form, which is how other FormFields work like CompositeField (Sean Harvey)
 * 2012-04-12 [3c70ea4](https://github.com/silverstripe/sapphire/commit/3c70ea4) Fixing broken test MemberDatetimeOptionsetFieldTest, passing in null for $validator argument (Sean Harvey)
 * 2012-04-12 [8369cde](https://github.com/silverstripe/sapphire/commit/8369cde) Code formatting in EmailField (Sean Harvey)
 * 2012-04-12 [1e61b76](https://github.com/silverstripe/sapphire/commit/1e61b76) ConfirmedPasswordField::validate() now passes in $validator argument instead of getting it from the form, which is how other FormFields work like CompositeField (Sean Harvey)
 * 2012-04-12 [859f7ad](https://github.com/silverstripe/sapphire/commit/859f7ad) TableField_Item::Fields() now conforms to parent TableListField_Item::Fields() for E_STRICT compliance (Sean Harvey)
 * 2012-04-12 [9cf1686](https://github.com/silverstripe/sapphire/commit/9cf1686) Code formatting fixes for CurrencyField (Sean Harvey)
 * 2012-04-12 [9a9cebb](https://github.com/silverstripe/sapphire/commit/9a9cebb) Versioned::add_to_class() now conforms to parent DataExtension::add_to_class() with $args being optional (default to null). This is for E_STRICT compliance. (Sean Harvey)
 * 2012-04-12 [972dfee](https://github.com/silverstripe/sapphire/commit/972dfee) Fixing E_STRICT compliance in simpletest (Sean Harvey)
 * 2012-04-12 [9bd7068](https://github.com/silverstripe/sapphire/commit/9bd7068) Fixed class documentation for CompositeDBField (Sean Harvey)
 * 2012-04-12 [630bfcc](https://github.com/silverstripe/sapphire/commit/630bfcc) error_reporting() now defaults to E_ALL | E_STRICT which means strict errors are now reported *unless* the site is in live mode (which supresses everything except fatal errors and warnings) (Sean Harvey)
 * 2012-04-12 [695ae71](https://github.com/silverstripe/sapphire/commit/695ae71) Issue #7113: Add test for nested loops. (Robert Curry)
 * 2012-04-12 [8325d73](https://github.com/silverstripe/silverstripe-cms/commit/8325d73) Fixing method signatures not compliant with the parent (Sean Harvey)
 * 2012-04-12 [74b341e](https://github.com/silverstripe/silverstripe-cms/commit/74b341e) Fixed stray newline at the top of CMSMain (Sean Harvey)
 * 2012-04-11 [ae4119e](https://github.com/silverstripe/silverstripe-installer/commit/ae4119e) Consistent styling of install-sapphiremissing.html (admittedly a bit pointless, since the new styles are placed in sapphire) (Ingo Schommer)
 * 2012-04-11 [70a3ca4](https://github.com/silverstripe/silverstripe-installer/commit/70a3ca4) Removed special treatment of blackcandy in build scripts (Ingo Schommer)
 * 2012-04-11 [6a10ed1](https://github.com/silverstripe/sapphire/commit/6a10ed1) Added TinyMCE language pack (Ingo Schommer)
 * 2012-04-11 [a3d99b0](https://github.com/silverstripe/sapphire/commit/a3d99b0) Resetting Security::$database_is_ready state during tests (regression from a9509a610de28) (Ingo Schommer)
 * 2012-04-11 [ca24120](https://github.com/silverstripe/sapphire/commit/ca24120) Install screen visual tweaks, more visible disabled state on install button, conditional version number (to avoid it showing without a version), referencing new theme in install screen, using new layout in install progress screen as well (Ingo Schommer)
 * 2012-04-11 [363dc9a](https://github.com/silverstripe/silverstripe-cms/commit/363dc9a) Searching both Title and Filename in AssetAdmin (fixes #7013, see pull request #71) (Ingo Schommer)
 * 2012-04-12 [a9509a6](https://github.com/silverstripe/sapphire/commit/a9509a6) Security::database_is_ready() check are doing duplicate DB queries for Members. (Stig Lindqvist)
 * 2012-04-11 [5c33632](https://github.com/silverstripe/sapphire/commit/5c33632) When Up called and we are at the top of the scope, throw a useful error, not just an index undefined error (Hamish Friedlander)
 * 2012-04-11 [556950d](https://github.com/silverstripe/sapphire/commit/556950d) Add some basic docs on new include feature (Hamish Friedlander)
 * 2012-04-11 [40ca21e](https://github.com/silverstripe/sapphire/commit/40ca21e) Remove bugfix that is (a) unnessecary because the key is already just sha hashes, underscores and numbers and (b) broken because it strips the open and close quotes from the key (Hamish Friedlander)
 * 2012-04-11 [12b30ff](https://github.com/silverstripe/silverstripe-cms/commit/12b30ff) Fix E_STRICT warnings (Andrew O'Neil)
 * 2012-04-11 [716ff9d](https://github.com/silverstripe/sapphire/commit/716ff9d) Ensure all form fields have FieldHolder() with identical signature to FormField::FieldHolder(). Fixes E_STRICT warnings. (Andrew O'Neil)
 * 2012-04-11 [142a073](https://github.com/silverstripe/sapphire/commit/142a073) Fix E_STRICT warning in SSViewer (Andrew O'Neil)
 * 2012-04-11 [4be59a8](https://github.com/silverstripe/sapphire/commit/4be59a8) Ensure all form fields Field() method has the same signature as FormField::Field(). Fixes E_STRICT warnings. (Andrew O'Neil)
 * 2012-04-11 [bfb99ae](https://github.com/silverstripe/silverstripe-cms/commit/bfb99ae) SSF-124 move the trunk of html code (commented out) to the position of the third tab so if it is commented in someday, it wont break the default selected tab. (Normann Lou)
 * 2012-04-11 [d368f36](https://github.com/silverstripe/sapphire/commit/d368f36) Remove default paramenter from handleRequest() so it complies with the interface correctly. Fixes E_STRICT warning. (Andrew O'Neil)
 * 2012-04-11 [daab8f4](https://github.com/silverstripe/sapphire/commit/daab8f4) Consistently use DataObjectInterface for saveInto() on FormField subclasses. Fixes E_STRICT notice (Andrew O'Neil)
 * 2012-04-11 [f811103](https://github.com/silverstripe/sapphire/commit/f811103) Remove redundant setDisabled() methods - this method already exists in FormField. Fixes E_STRICT notice. (Andrew O'Neil)
 * 2012-04-11 [4d97e88](https://github.com/silverstripe/sapphire/commit/4d97e88) Removed useless Security_login.js file which doesn't have any content and isn't used anywhere. (Sean Harvey)
 * 2012-04-11 [3e307e0](https://github.com/silverstripe/sapphire/commit/3e307e0) Removing old remains of NumericField.js validation which was removed in 9f3344b355d973b4864f461876f19471f5f4beba (Sean Harvey)
 * 2012-04-11 [1cf2e2c](https://github.com/silverstripe/silverstripe-cms/commit/1cf2e2c) SSF-124 added missing ";" for keep SilverStripe Code Convention (Normann Lou)
 * 2012-04-11 [7213d2b](https://github.com/silverstripe/silverstripe-cms/commit/7213d2b) Clarified meaning of SiteTree:: (Sam Minnee)
 * 2012-04-11 [da9dfca](https://github.com/silverstripe/sapphire/commit/da9dfca) Removed RedirectorPage.js (has been moved to cms module where RedirectorPage.php resides) (Sean Harvey)
 * 2012-04-11 [afdac50](https://github.com/silverstripe/silverstripe-cms/commit/afdac50) SSF-124 correct inline document for a newly added routine. (Normann Lou)
 * 2012-04-11 [501c8f3](https://github.com/silverstripe/sapphire/commit/501c8f3) Fix E_STRICT notices in php-peg (Andrew O'Neil)
 * 2012-04-11 [7900da4](https://github.com/silverstripe/silverstripe-cms/commit/7900da4) SSF-168 add Pagination to the report list so it show the bottom bar (Normann Lou)
 * 2012-04-11 [b58183f](https://github.com/silverstripe/sapphire/commit/b58183f) Trac #7116 - added a set width to dropdowns in filter side panel for IE8 (Jeremy Bridson)
 * 2012-04-10 [39208d1](https://github.com/silverstripe/silverstripe-cms/commit/39208d1) i18n for revert confirmation messages, improved wording (Ingo Schommer)
 * 2012-04-10 [33d58c5](https://github.com/silverstripe/sapphire/commit/33d58c5) Notes about removal of AdvancedSearchForm (Sean Harvey)
 * 2012-04-10 [3390ea3](https://github.com/silverstripe/sapphire/commit/3390ea3) Updating tree nodes on each state change, rather than just listening to form reloads (Ingo Schommer)
 * 2012-04-10 [15e16f1](https://github.com/silverstripe/sapphire/commit/15e16f1) Retaining correct PJAX selector on (fake) redirects after form submissions (Ingo Schommer)
 * 2012-04-10 [d914ee0](https://github.com/silverstripe/silverstripe-cms/commit/d914ee0) Fixing ereg functions with preg in SideReport and Widget (Sean Harvey)
 * 2012-04-10 [2f1b7c1](https://github.com/silverstripe/sapphire/commit/2f1b7c1) Removed references to ereg as comments (Sean Harvey)
 * 2012-04-10 [4b2326c](https://github.com/silverstripe/sapphire/commit/4b2326c) Fixed use of split which is deprecated (Sean Harvey)
 * 2012-04-10 [9e72753](https://github.com/silverstripe/sapphire/commit/9e72753) SSF-65 fix a broken image link in the document file. (Normann Lou)
 * 2012-04-10 [6c9a3ba](https://github.com/silverstripe/sapphire/commit/6c9a3ba) Fixed failing tests on pgsql (Sean Harvey)
 * 2012-04-10 [3ea847a](https://github.com/silverstripe/sapphire/commit/3ea847a) changed white-space:nowrap so that it applies to all td in the gridfield. (Jeremy Bridson)
 * 2012-04-10 [c57d8a8](https://github.com/silverstripe/sapphire/commit/c57d8a8) regenerating compass icons (Julian Seidenberg)
 * 2012-04-10 [2c5c3ee](https://github.com/silverstripe/sapphire/commit/2c5c3ee) regenerating compass icons (Julian Seidenberg)
 * 2012-04-10 [3222e2d](https://github.com/silverstripe/silverstripe-cms/commit/3222e2d) removing report registration as now no longer necessary (Julian Seidenberg)
 * 2012-04-09 [85a898e](https://github.com/silverstripe/sapphire/commit/85a898e) Don't assume existence of cms/ folder in LeftAndMain-&gt;CMSVersion() (regression from earlier code) (Ingo Schommer)
 * 2012-04-09 [c2f7bf4](https://github.com/silverstripe/sapphire/commit/c2f7bf4) Fixed FormField::create() usage (Ingo Schommer)
 * 2012-04-07 [5e79e81](https://github.com/silverstripe/sapphire/commit/5e79e81) ConfigManifest cache fixes (Stig Lindqvist)
 * 2012-04-05 [4524d1c](https://github.com/silverstripe/silverstripe-cms/commit/4524d1c) Fixed usage of deprecated Form-&gt;dataFieldByName() (Ingo Schommer)
 * 2012-04-05 [a6c586a](https://github.com/silverstripe/silverstripe-cms/commit/a6c586a) Using new PjaxResponseNegotiator in CMSMain (Ingo Schommer)
 * 2012-04-05 [aebbb10](https://github.com/silverstripe/sapphire/commit/aebbb10) Skip processing in CMS on empty ajax responses, as they're usually a pseudo redirect (via X-ControllerURL) (Ingo Schommer)
 * 2012-04-05 [72985b6](https://github.com/silverstripe/sapphire/commit/72985b6) Artificially triggering onsubmit event on CMS form buttons rather than calling submitForm() method, in order to give forms like .cms-add-form the option to overload its behaviour (Ingo Schommer)
 * 2012-04-05 [f97804b](https://github.com/silverstripe/sapphire/commit/f97804b) Fixed specificity of .add-form behaviour (Ingo Schommer)
 * 2012-04-05 [3341a18](https://github.com/silverstripe/silverstripe-cms/commit/3341a18) Using SS_HTTPRequest-&gt;isAjax() instead of deprecated RequestHandler API (Ingo Schommer)
 * 2012-04-05 [50e50f7](https://github.com/silverstripe/silverstripe-cms/commit/50e50f7) SSF-124 remove debug info (Normann Lou)
 * 2012-04-05 [a85301b](https://github.com/silverstripe/sapphire/commit/a85301b) css files regenerating from sass (Jeremy Bridson)
 * 2012-04-05 [e43d0b4](https://github.com/silverstripe/silverstripe-cms/commit/e43d0b4) SSF-168 adding additional class to grid field that displays all reports (Julian Seidenberg)
 * 2012-04-05 [c3d1c3c](https://github.com/silverstripe/sapphire/commit/c3d1c3c) update added compass generated css file (Normann Lou)
 * 2012-04-05 [4392751](https://github.com/silverstripe/sapphire/commit/4392751) SSF-168 added compass generated css file (Normann Lou)
 * 2012-04-05 [a946096](https://github.com/silverstripe/sapphire/commit/a946096) SSF-168 code convention correction MINOR: SSF-168 add _t()'s where necessory in GridField print view (Normann Lou)
 * 2012-04-04 [40d7312](https://github.com/silverstripe/sapphire/commit/40d7312) Using late static binding instead of Object::create() calls (Ingo Schommer)
 * 2012-04-04 [de573e0](https://github.com/silverstripe/silverstripe-cms/commit/de573e0) Using late static binding instead of Object::create() calls (Ingo Schommer)
 * 2012-04-04 [721184c](https://github.com/silverstripe/sapphire/commit/721184c) SSF-297 add more available information to GridField print view (Normann Lou)
 * 2012-04-04 [2f3949a](https://github.com/silverstripe/sapphire/commit/2f3949a) add 'print button' to Member list and data list of ModelAdmin (Normann Lou)
 * 2012-04-03 [68db977](https://github.com/silverstripe/sapphire/commit/68db977) Provide a setter for heading level on HeaderField object. (Simon Elvery)
 * 2012-04-03 [fac2664](https://github.com/silverstripe/sapphire/commit/fac2664) add 'edit-profile-popup' as extra popup class (Normann Lou)
 * 2012-04-03 [f8a6db8](https://github.com/silverstripe/sapphire/commit/f8a6db8) Temporarily reverted X-ControllerURL push state, as the header doesn't get set correctly in LeftAndMain::handleRequest() correctly. This fixes saving pages until X-ControllerURL has been corrected. (Sean Harvey)
 * 2012-04-03 [3abd264](https://github.com/silverstripe/silverstripe-installer/commit/3abd264) Setting new default theme in standard mysite/_config.php (Ingo Schommer)
 * 2012-04-03 [349019e](https://github.com/silverstripe/sapphire/commit/349019e) Adjusted wording based on E_DEPRECATED and E_USER_DEPRECATED error levels. (Sean Harvey)
 * 2012-04-02 [c30a5a1](https://github.com/silverstripe/sapphire/commit/c30a5a1) added spaces to css. (Jeremy Bridson)
 * 2012-03-31 [68aaae8](https://github.com/silverstripe/sapphire/commit/68aaae8) Update docs and version checking for PHP 5.3+ (Sean Harvey)
 * 2012-03-31 [58e912d](https://github.com/silverstripe/sapphire/commit/58e912d) Removed check for PHP versions less than 5.2 in Cookie (Sean Harvey)
 * 2012-03-31 [db65704](https://github.com/silverstripe/sapphire/commit/db65704) Removed PHP 5.2 check in DateTest (Sean Harvey)
 * 2012-03-31 [c52f75e](https://github.com/silverstripe/sapphire/commit/c52f75e) Add notes on upgrading for Convert::json2array() changes (Sean Harvey)
 * 2012-03-31 [18a1cc1](https://github.com/silverstripe/sapphire/commit/18a1cc1) update docs to fix issues raised via comments. MINOR: remove section on comments. (Will Rossiter)
 * 2012-03-30 [ac6f9e9](https://github.com/silverstripe/sapphire/commit/ac6f9e9) Normalize trailing slashes in X-ControllerURL handling to avoid double requests caused by SS_HTTPRequest modifying the original URL (removing trailing slash etc) (Ingo Schommer)
 * 2012-03-30 [c2b7416](https://github.com/silverstripe/sapphire/commit/c2b7416) Moved X-ControllerURL handling into global ajax response handlers to avoid code duplication (Ingo Schommer)
 * 2012-03-30 [0414e42](https://github.com/silverstripe/sapphire/commit/0414e42) Keep X-ControllerURL canonical by not re-constructing with question mark if there's no GET string (caused duplicate HTML5 pushState requests) (Ingo Schommer)
 * 2012-03-30 [7c1b40d](https://github.com/silverstripe/sapphire/commit/7c1b40d) Added 'updateCMSFields' hook to File (fixes #7091) (Ingo Schommer)
 * 2012-03-30 [83adffd](https://github.com/silverstripe/sapphire/commit/83adffd) Fixed var names in LeftAndMain.js (Ingo Schommer)
 * 2012-03-30 [3f4aba5](https://github.com/silverstripe/sapphire/commit/3f4aba5) Avoid breaking IE on CMS ajax responses which don't contain CSS class names (splitting on NULL) (#7002) (Ingo Schommer)
 * 2012-03-30 [ded3fd8](https://github.com/silverstripe/silverstripe-cms/commit/ded3fd8) Fixed broken test from json changes (Sean Harvey)
 * 2012-03-30 [98e197a](https://github.com/silverstripe/sapphire/commit/98e197a) SSF-38 renaming the PageUploadField template to HtmlEditorField_UploadField (Julian Seidenberg)
 * 2012-03-30 [196ec03](https://github.com/silverstripe/sapphire/commit/196ec03) changing template to make delete icon appear in the list of uploaded files (Julian Seidenberg)
 * 2012-03-30 [63ff91e](https://github.com/silverstripe/sapphire/commit/63ff91e) Documentation for CMS tree and new SiteTree-&gt;getStatusFlags() (Normann Lou)
 * 2012-03-29 [29d7a9a](https://github.com/silverstripe/sapphire/commit/29d7a9a) SSF-38 adding some additional classes to delete button (Julian Seidenberg)
 * 2012-03-29 [e67a777](https://github.com/silverstripe/sapphire/commit/e67a777) SSF-38 adding class for delete button on template (Julian Seidenberg)
 * 2012-03-29 [94e21d1](https://github.com/silverstripe/sapphire/commit/94e21d1) SSF-38 i18n of some of the form (Julian Seidenberg)
 * 2012-03-28 [c56176c](https://github.com/silverstripe/sapphire/commit/c56176c) Updated 'from-source' installation to use new 'simple' theme (which also fixes the problem of checking out 'blackcandy' sub themes via git into overlapping repository paths) (Ingo Schommer)
 * 2012-03-28 [c3ad420](https://github.com/silverstripe/silverstripe-installer/commit/c3ad420) Updated new-project script to use "simple" theme (Ingo Schommer)
 * 2012-03-27 [66093f7](https://github.com/silverstripe/sapphire/commit/66093f7) Fixed one-off button height inconsistencies (fixes #6980) (Ingo Schommer)
 * 2012-03-27 [87fbb72](https://github.com/silverstripe/sapphire/commit/87fbb72) Fixing 1px gap between nav tree and page header (Ingo Schommer)
 * 2012-03-27 [6d423fe](https://github.com/silverstripe/sapphire/commit/6d423fe) Moved AssetUploadField iframe margins into iframe body itself to avoid width conflicts, override default .cms overflow behaviour to ensure the iframe content as a whole stays scrollable (fixes #7003) (Ingo Schommer)
 * 2012-03-27 [3ef3a6d](https://github.com/silverstripe/sapphire/commit/3ef3a6d) Shrinking GridField button column to fit, rather than hardcoding a width for it that depends on the amount and styling of buttons in the table (Ingo Schommer)
 * 2012-03-27 [efc30fd](https://github.com/silverstripe/sapphire/commit/efc30fd) Removed setRightTitle() special case (and too specific styling) from Group-&gt;getCMSFields(), implemented title attribute for chosen.js drop downs instead (to be styled with more friendly title popovers) (Ingo Schommer)
 * 2012-03-27 [cf014dc](https://github.com/silverstripe/sapphire/commit/cf014dc) Replaced use of deprecated split() with preg_split() and fixed use of "&new Class()" which is deprecated in PHP 5.3 ENHANCEMENT E_DEPRECATED and E_USER_DEPRECATED are now handled as notice level errors in Debug. (Sean Harvey)
 * 2012-03-27 [1ab7686](https://github.com/silverstripe/silverstripe-cms/commit/1ab7686) Remove use of deprecated ereg_replace() and use preg_replace() instead. (Sean Harvey)
 * 2012-03-27 [c3cae28](https://github.com/silverstripe/sapphire/commit/c3cae28) added default flag to SCSS to allow variables to be overridden (Will Rossiter)
 * 2012-03-27 [b92e4e0](https://github.com/silverstripe/sapphire/commit/b92e4e0) Removed PHP 5.1 check for PasswordEncryptor, use hash() always as PHP 5.1 is no longer supported. (Sean Harvey)
 * 2012-03-27 [fec5497](https://github.com/silverstripe/sapphire/commit/fec5497) Removed old array_fill_keys() replacement for PHP 5.1, which is no longer supported. (Sean Harvey)
 * 2012-03-27 [0ea9451](https://github.com/silverstripe/silverstripe-cms/commit/0ea9451) Fixes to method arguments in cms classes for E_STRICT support. (Sean Harvey)
 * 2012-03-27 [e097f6e](https://github.com/silverstripe/sapphire/commit/e097f6e) Fixes to method arguments in core classes for E_STRICT support. API CHANGE Remove abstract static function and just use static functions in Authenticator (PHP 5.3+ doesn't support abstract static functions) (Sean Harvey)

...

 * 2012-03-27 [a95b11d](https://github.com/silverstripe/sapphire/commit/a95b11d) Updated chosen.js from 0.9.7 to 0.9.8 while still maintaining local fixes (Normann Lou)
 * 2012-03-27 [8166c26](https://github.com/silverstripe/silverstripe-cms/commit/8166c26) Fixed grammar in "Foldername" popup when adding a folder in AssetAdmin. Should be "Folder name". (Sean Harvey)
 * 2012-03-26 [41df04f](https://github.com/silverstripe/silverstripe-installer/commit/41df04f) Added reset.css include to Page.php in order to fix inclusion order in new default theme (Ingo Schommer)
 * 2012-03-24 [7db3b8e](https://github.com/silverstripe/sapphire/commit/7db3b8e) Raise deprecation errors in the same way as notice-level errors. (Sam Minnee)
 * 2012-03-24 [e9f650a](https://github.com/silverstripe/sapphire/commit/e9f650a) tighten up tree spacing (Will Rossiter)
 * 2012-03-24 [f8082e4](https://github.com/silverstripe/sapphire/commit/f8082e4) Add newline to end of files without one (Simon Welsh)
 * 2012-03-24 [a39231f](https://github.com/silverstripe/silverstripe-cms/commit/a39231f) add icon to ajax button in AssetAdmin (Will Rossiter)
 * 2012-03-24 [06dd79f](https://github.com/silverstripe/sapphire/commit/06dd79f) remove console.log (Will Rossiter)
 * 2012-03-24 [673dd7d](https://github.com/silverstripe/sapphire/commit/673dd7d) Remove unused AssetTableField js file (Simon Welsh)
 * 2012-03-24 [2f8148d](https://github.com/silverstripe/silverstripe-cms/commit/2f8148d) Move definition of CMS_DIR and CMS_PATH into cms/_config.php (Simon Welsh)
 * 2012-03-24 [4be8ab0](https://github.com/silverstripe/sapphire/commit/4be8ab0) Move definition of CMS_DIR and CMS_PATH into cms/_config.php (Simon Welsh)
 * 2012-03-24 [ebec3ba](https://github.com/silverstripe/sapphire/commit/ebec3ba) fix alignment of cms logo to panel title (Will Rossiter)
 * 2012-03-24 [769995c](https://github.com/silverstripe/sapphire/commit/769995c) Fix reference to class that was renamed in modeladmin docs (Sean Harvey)
 * 2012-03-23 [3a91a97](https://github.com/silverstripe/sapphire/commit/3a91a97) Fixed grammatical error in GridFieldDeleteAction class documentation (Sean Harvey)
 * 2012-03-23 [98cc25a](https://github.com/silverstripe/sapphire/commit/98cc25a) Tidy up of class documentation for GridFieldDeleteAction (Sean Harvey)
 * 2012-03-23 [239b4a0](https://github.com/silverstripe/sapphire/commit/239b4a0) Rename argument to GridFieldDeleteAction to match the property name $removeRelation MINOR Tidy up coding standards in GridFieldDeleteAction (Sean Harvey)
 * 2012-03-23 [ff4c820](https://github.com/silverstripe/sapphire/commit/ff4c820) Class documentation for GridFieldDeleteAction (Sean Harvey)
 * 2012-03-23 [4da42f2](https://github.com/silverstripe/sapphire/commit/4da42f2) Revert folderName change to UploadField (already exists on FileField parent) (Sean Harvey)
 * 2012-03-22 [236f267](https://github.com/silverstripe/sapphire/commit/236f267) changed the heading 'add pages' to add page trac #7026 (jbridson)
 * 2012-03-22 [c6bfd0a](https://github.com/silverstripe/silverstripe-cms/commit/c6bfd0a) changed the heading 'add pages' to add page trac #7026 (jbridson)
 * 2012-03-20 [fea3a4e](https://github.com/silverstripe/sapphire/commit/fea3a4e) Removed useless .DS_Store files (Sean Harvey)
 * 2012-03-20 [b5d4234](https://github.com/silverstripe/sapphire/commit/b5d4234) Correct DropdownField class documentation to include a proper example using DataList and non-deprecated way of setting the empty value and string (Sean Harvey)
 * 2012-03-19 [9e60225](https://github.com/silverstripe/sapphire/commit/9e60225) : Update core docs to use DataList::create() rather than DataObject::get()/get_one()/get_by_id() where appropriate - Trac#6891 (Normann Lou)
 * 2012-03-15 [22dc7fd](https://github.com/silverstripe/sapphire/commit/22dc7fd) Warning about imminent TableField deprecation (Ingo Schommer)
 * 2012-03-15 [9b00096](https://github.com/silverstripe/sapphire/commit/9b00096) Added tests for SS_Map testing value method instead of value field (Sean Harvey)
 * 2012-03-15 [304b89f](https://github.com/silverstripe/sapphire/commit/304b89f) replaced back button icon with correct icon. (jbridson)
 * 2012-03-14 [ed08b8c](https://github.com/silverstripe/sapphire/commit/ed08b8c) Don't auto-expand nodes on TreeDropdownField, as it makes a gazillion ajax requests on sufficiently large trees (and gets nodes in chunks of 30) (fixes #6879) (Ingo Schommer)
 * 2012-03-14 [4d723c7](https://github.com/silverstripe/sapphire/commit/4d723c7) Added note about 'homepagefordomain' module coupling (Ingo Schommer)
 * 2012-03-14 [c6b259e](https://github.com/silverstripe/silverstripe-cms/commit/c6b259e) Redirect to page edit view after rolling back to a specific version in CMSPageHistoryController (fixes #6912) (Ingo Schommer)
 * 2012-03-14 [71c026c](https://github.com/silverstripe/sapphire/commit/71c026c) Removed SiteTree dependency from SSViewerTest (fixes #6907) (Ingo Schommer)
 * 2012-03-14 [620b23a](https://github.com/silverstripe/sapphire/commit/620b23a) Including GET parameters in X-ControllerURL default headers (which fixes e.g. AssetAdmin search persistence) (Ingo Schommer)
 * 2012-03-14 [eecca9b](https://github.com/silverstripe/sapphire/commit/eecca9b) Removed unnecessary tests from symfony-yaml dependency (which also fixes phpunit binary execution) (Ingo Schommer)
 * 2012-03-14 [6db08cb](https://github.com/silverstripe/sapphire/commit/6db08cb) Fix tests on PHPUnit 3.4 (Andrew O'Neil)
 * 2012-03-14 [1a36f92](https://github.com/silverstripe/sapphire/commit/1a36f92) Fix tests on PHPUnit 3.4 (Andrew O'Neil)
 * 2012-03-13 [f8d38a3](https://github.com/silverstripe/sapphire/commit/f8d38a3) Upgrading notes (Ingo Schommer)
 * 2012-03-13 [4c1cb59](https://github.com/silverstripe/sapphire/commit/4c1cb59) fix the bug that ModelAdmin search filter doesn't work when arriving from another section of the CMS. (Normann Lou)
 * 2012-03-13 [4bf4d4d](https://github.com/silverstripe/sapphire/commit/4bf4d4d) SSF-53 - changed color of text on link existing button on hover. (jbridson)
 * 2012-03-11 [82bb12b](https://github.com/silverstripe/sapphire/commit/82bb12b) Explicitly declare $adapter in DbDatetimeTest (Fred Condo)
 * 2011-12-20 [95cdbe9](https://github.com/silverstripe/sapphire/commit/95cdbe9) Avoid duplicate var declaration in i18n::_t() (Ingo Schommer)
 * 2011-12-04 [27ec83c](https://github.com/silverstripe/sapphire/commit/27ec83c) i18n::_t() getter performance optimisation (saves 10% on default CMS execution!) (Ingo Schommer)
 * 2011-12-04 [03de6e5](https://github.com/silverstripe/sapphire/commit/03de6e5) Removed i18nSSLegacyTranslator from default setup for performance reasons, document how to re-apply it (Ingo Schommer)
 * 2011-12-04 [652f0ec](https://github.com/silverstripe/sapphire/commit/652f0ec) Infinite cache (Ingo Schommer)
 * 2011-12-04 [796975f](https://github.com/silverstripe/sapphire/commit/796975f) Don't set locale on adapter in i18n::_t() for performance reasons, we're passing it with each individual translate() call anyway (Ingo Schommer)
 * 2011-12-04 [190c758](https://github.com/silverstripe/sapphire/commit/190c758) Reverting to use directory scanning rather than Zend_Translate() in i18n::get_existing_languages(), as the only way to determine this information from Zend is loading all locales (which is way too slow e.g. for loading a language drop down in the member profile) (Ingo Schommer)
 * 2011-12-04 [326ff4a](https://github.com/silverstripe/sapphire/commit/326ff4a) Added array fallback support to i18nSSLegacyAdapter (Ingo Schommer)
 * 2011-11-27 [81d7d84](https://github.com/silverstripe/silverstripe-cms/commit/81d7d84) Removed legacy PHP translations (Ingo Schommer)
 * 2011-11-27 [7e7d988](https://github.com/silverstripe/sapphire/commit/7e7d988) Removed legacy PHP translation files (Ingo Schommer)
 * 2011-11-26 [a3e74bb](https://github.com/silverstripe/sapphire/commit/a3e74bb) Added Zend_Translate dependency (v1.11.11) (Ingo Schommer)
 * 2011-11-26 [3342c84](https://github.com/silverstripe/sapphire/commit/3342c84) Added zend_translate_railsyaml dependency (Ingo Schommer)
 * 2011-11-19 [169d125](https://github.com/silverstripe/silverstripe-cms/commit/169d125) Converted YML lang files (Ingo Schommer)
 * 2011-11-19 [88daa4f](https://github.com/silverstripe/silverstripe-cms/commit/88daa4f) Updated translations from translate.silverstripe.org (Ingo Schommer)
 * 2011-11-19 [6c1c98e](https://github.com/silverstripe/sapphire/commit/6c1c98e) Converted YML lang files (Ingo Schommer)
 * 2011-11-19 [edd4ef2](https://github.com/silverstripe/sapphire/commit/edd4ef2) Updated translations from translate.ss.org (Ingo Schommer)

### Other

 * 2012-04-18 [e5000dd](https://github.com/silverstripe/silverstripe-cms/commit/e5000dd) MERGE List view breadcrumbs (Ingo Schommer)
 * 2012-04-18 [972e7cc](https://github.com/silverstripe/sapphire/commit/972e7cc) MERGE sitetreeasul (Ingo Schommer)
 * 2012-04-18 [3ee4459](https://github.com/silverstripe/sapphire/commit/3ee4459) MERGE tabs url abs (Ingo Schommer)
 * 2012-04-18 [4c9fa62](https://github.com/silverstripe/sapphire/commit/4c9fa62) ENHANCMENT:Trac#7166 - added styling for 2nd level tabs. (Jeremy Bridson)
 * 2012-04-16 [65e3651](https://github.com/silverstripe/sapphire/commit/65e3651) API-CHANGE: new translatable syntax _t function (Julian Seidenberg)
 * 2012-04-16 [c314d0b](https://github.com/silverstripe/sapphire/commit/c314d0b) API-CHANGE: i18nTextCollector can now extract the new translatable entities (&lt;%t) from templates and populate them in language tables (uses PEG parser) (Julian Seidenberg)
 * 2012-04-16 [189c305](https://github.com/silverstripe/sapphire/commit/189c305) API-CHANGE: parser for new i18n syntax (Julian Seidenberg)
 * 2012-04-12 [1a532fa](https://github.com/silverstripe/silverstripe-installer/commit/1a532fa) API-CHANGE sapphire folder can now be renamed. (Simon Welsh)
 * 2012-04-12 [df08c2f](https://github.com/silverstripe/sapphire/commit/df08c2f) API-CHANGE Move tinymce plugins in thirdparty (Simon Welsh)
 * 2012-04-12 [b4e1552](https://github.com/silverstripe/sapphire/commit/b4e1552) API-CHANGE Move tinymce plugins in thirdparty (Simon Welsh)
 * 2012-04-12 [517bf31](https://github.com/silverstripe/silverstripe-cms/commit/517bf31) API-CHANGE Move tinymce plugins in thirdparty (Simon Welsh)
 * 2012-04-12 [a0e320d](https://github.com/silverstripe/silverstripe-cms/commit/a0e320d) API-CHANGE Update Readme to match renaming of sapphire to framework (Simon Welsh)
 * 2012-04-12 [c4e0189](https://github.com/silverstripe/silverstripe-cms/commit/c4e0189) API-CHANGE sapphire folder can now be renamed. (Simon Welsh)
 * 2012-04-12 [e9dc610](https://github.com/silverstripe/sapphire/commit/e9dc610) API-CHANGE: new GridFieldFooter component (Julian Seidenberg)
 * 2012-04-10 [9888f98](https://github.com/silverstripe/silverstripe-cms/commit/9888f98) ENHANCMENT: Link pages in reports to cms edit (Andrew O'Neil)
 * 2012-04-10 [1516934](https://github.com/silverstripe/silverstripe-cms/commit/1516934) Revert "BUGFIX: SSF-168 fixing rendering issue in Chrome, which displays extra control at the bottom of the window in a report that is of a certain length" (Julian Seidenberg)
 * 2012-04-06 [797d526](https://github.com/silverstripe/sapphire/commit/797d526) For png images with transparency, the imagesaveaplpha() needs to be set to true on the source image in order for the alpha to be preserved when using the modifier methods. (jmwohl)
 * 2012-04-05 [e76913f](https://github.com/silverstripe/sapphire/commit/e76913f) API-CHANGE: adding a default option of null to the $args argument in DataExtension::add_to_class. The args argument isn't used anywhere in the class and adding a third argument to every call to this function is tedious. (Julian Seidenberg)
 * 2012-04-04 [5826b36](https://github.com/silverstripe/sapphire/commit/5826b36) ENHACEMENT: SSF-168 updated the font for titles on print stylesheets (Felipe Skroski)
 * 2012-04-04 [349a04d](https://github.com/silverstripe/silverstripe-cms/commit/349a04d) API-CHANGE: SSF-168 changing the API/code-conventions for excluding specific reports. get_reports method now returns an ArrayList instead of an array of SS_Reports. (Julian Seidenberg)
 * 2012-04-03 [59706d5](https://github.com/silverstripe/sapphire/commit/59706d5) Using deprecated StringField::Upper() and StringField::Lower(). Calling $MyEnumField.Upper on the template returns an unresolvable deprecation error. (unclecheese)
 * 2012-04-03 [ee220bb](https://github.com/silverstripe/silverstripe-cms/commit/ee220bb) API-CHANGE: SSF-168 initial rearranging the SS_Report class for use in SS3. Deprecating unnecessary methods, moving code around, rewriting get_reports method and writing unit tests (Julian Seidenberg)
 * 2012-03-25 [6563690](https://github.com/silverstripe/sapphire/commit/6563690) API-CHANGE Update docs to match renaming of sapphire to framework (Simon Welsh)
 * 2012-03-24 [3a6341a](https://github.com/silverstripe/sapphire/commit/3a6341a) API-CHANGE sapphire folder can now be renamed. (Simon Welsh)
 * 2012-03-24 [4e9cbe0](https://github.com/silverstripe/silverstripe-cms/commit/4e9cbe0) Prevents notice error when parent page isn't set (Matt Gunn)
 * 2012-03-14 [31c9e98](https://github.com/silverstripe/sapphire/commit/31c9e98) Correction of template documentation: Removed mentions of deprecated control statement. (Andy Adiwidjaja)
 * 2012-03-13 [42f8d9f](https://github.com/silverstripe/sapphire/commit/42f8d9f) - Readded check for _config.php in ClassManifest. - Added UnitTest for files with underscore prefix. (AngryPHPNerd)
 * 2012-03-03 [7927fff](https://github.com/silverstripe/sapphire/commit/7927fff) AP(RE)CHANGE Exclude files with the underscore prefix from manifest. (Dominik Beerbohm)
