# 3.0.0-alpha1 #

## Overview ##

 * New ORM: More flexible and expressive querying via `DataList`
 * New ORM: Changes to manipulation of SQL queries
 * New ORM: Better encapsulation of relationship queries with `RelationList`
 * Early version of a `GridField` (formerly known as `DataGrid`) component which will supersede
`ComplexTableField` and `TableListField`
 * InnoDB driver for existing and new tables on MySQL (instead of MyISAM)
 * Using `[MySQLi](http://php.net/mysqli)` instead of deprecated `mysql_*` API in `MySQLDatabase`
 * User timezone support in `DateTimeField`
 * CMS UI: Collapsible menu, panel ajax loading with HTML5 history integration
 * CMS UI: New "add page" dialog
 * Deprecation API

See [3.0.0 upgrading guide](../3.0.0) for more details.

## Upgrading ##

See [3.0.0 upgrading guide](../3.0.0) for further details.

## Changelog ##

### API Changes

 * 2011-10-26 [d799c80](https://github.com/silverstripe/silverstripe-cms/commit/d799c80) Changed name from DataObjectSet to either ArrayList or DataList (Stig Lindqvist)
 * 2011-10-26 [05e9083](https://github.com/silverstripe/silverstripe-cms/commit/05e9083) Switch usage from FieldSet to FieldList (Stig Lindqvist)
 * 2011-10-22 [fb8ff50](https://github.com/silverstripe/sapphire/commit/fb8ff50) Childclasses to SS_List matches the same signature on abstract methods column and map. (Stig Lindqvist)
 * 2011-10-10 [e66255c](https://github.com/silverstripe/sapphire/commit/e66255c) Using 'BackURL' GET parameter in Controller-&gt;redirectBack() instead of the unused '_REDIRECT_BACK_URL', which e.g. makes the Security/logout behaviour consistent with Security/login (fixes #6729, thanks rixnix) (Ingo Schommer)
 * 2011-09-27 [b6f8803](https://github.com/silverstripe/sapphire/commit/b6f8803) Usage of FieldSet is deprecated, use FieldList instead (Stig Lindqvist)
 * 2011-09-26 [b807983](https://github.com/silverstripe/sapphire/commit/b807983) Using &lt;div&gt; instead of &lt;p&gt; for CheckboxField-&gt;FieldHolder() (Ingo Schommer)
 * 2011-09-26 [585a8bc](https://github.com/silverstripe/sapphire/commit/585a8bc) Removed 'showdropdown' option from TimeField, use custom libraries instead (Ingo Schommer)
 * 2011-09-14 [b438a0a](https://github.com/silverstripe/sapphire/commit/b438a0a) Removed support for undocumented and only partially implemented FormField-&gt;reserveNL flag, which is just the opposite of the documented and more frequently used FormField-&gt;dontEscape flag. (Ingo Schommer)
 * 2011-08-30 [7156383](https://github.com/silverstripe/sapphire/commit/7156383) Obeying existing memory_limit settings in increase_memory_limmit_to(). Introduced set_increase_memory_limit_max() and set_increase_time_limit_max() (Ingo Schommer)
 * 2011-07-15 [e13537e](https://github.com/silverstripe/silverstripe-cms/commit/e13537e) Refactored SilverStripeNavigator and SilverStripeNavigatorItem to instance-based utility classes, which take a DataObject record in the constructor rather than all of their methods (increasing template flexibility and code isolation). ENHANCEMENT Added SilverStripeNavigatorItem-&gt;canView() for flexible permission control MINOR Fixed duplicate priority overrides in SilverStripeNavigator MINOR Removed unnecessary inline styling from SilverStripeNavigator HTML generation (Ingo Schommer)
 * 2011-06-09 [d68ec39](https://github.com/silverstripe/sapphire/commit/d68ec39) Using $Link instead of $ApplicationTitle and $SectionTitle in LeftAndMain.ss. Adding new 'X-Title' HTTP header in order to support title changes for history.pushState (Ingo Schommer)
 * 2011-06-08 [ff54044](https://github.com/silverstripe/sapphire/commit/ff54044) Forms in ajax responses from LeftAndMain and subclasses include &lt;form&gt; tags, and replace the form itself on the client (rather than just everything inside the form). Form submissions and loading is handled by its container ('.cms-content') to avoid problems with a DOM element replacing itself upon form submission. (Ingo Schommer)
 * 2009-10-15 [e57be3f](https://github.com/silverstripe/silverstripe-cms/commit/e57be3f) Always allow users with ADMIN permissions to view or edit SiteConfig (sminnee)

### Features and Enhancements

 * 2011-10-27 [83e90aa](https://github.com/silverstripe/sapphire/commit/83e90aa) Release of DataGridPagination (Stig Lindqvist)
 * 2011-09-30 [b229c17](https://github.com/silverstripe/sapphire/commit/b229c17) Renamed DataGrid to GridField (Stig Lindqvist)
 * 2011-09-30 [488734e](https://github.com/silverstripe/sapphire/commit/488734e) Added correct styling of sorting and odd even on grid table (Stig Lindqvist)
 * 2011-09-29 [b1b1615](https://github.com/silverstripe/sapphire/commit/b1b1615) Datagrid renders ArrayList according to Datagrid#setModelClass() (Stig Lindqvist)
 * 2011-09-28 [1979138](https://github.com/silverstripe/sapphire/commit/1979138) First cut at data grid with the data presenter (Jean-Fabien)
 * 2011-09-28 [85cdb37](https://github.com/silverstripe/sapphire/commit/85cdb37) Added initial commit of Datagrid with tests (Stig Lindqvist)
 * 2011-09-26 [b05e3bd](https://github.com/silverstripe/sapphire/commit/b05e3bd) Enforcing min/max config on DateField in jQuery date picker (AIR-93) (Ingo Schommer)
 * 2011-09-26 [7c147fe](https://github.com/silverstripe/sapphire/commit/7c147fe) Passing 'timeformat' and other metadata to markup generated in DateField, TimeField and DatetimeField, to allow for easier integration with third party libraries (Ingo Schommer)
 * 2011-09-26 [d93bd49](https://github.com/silverstripe/sapphire/commit/d93bd49) Allowing global default configuration for DateField, TimeField and DatetimeField (Ingo Schommer)
 * 2011-09-26 [c89bdbb](https://github.com/silverstripe/sapphire/commit/c89bdbb) Added user timezone support to DatetimeField (Ingo Schommer)
 * 2011-09-22 [8302af1](https://github.com/silverstripe/sapphire/commit/8302af1) Added Database-&gt;getLock() and Database-&gt;releaseLock() for application-level advisory locks (Ingo Schommer)
 * 2011-09-19 [9c22a87](https://github.com/silverstripe/silverstripe-cms/commit/9c22a87) Removed unnecessary "Edit Page &gt; Reports" controller, feature will only be available through a dedicated "Reports" interface (Ingo Schommer)
 * 2011-09-19 [7408ba4](https://github.com/silverstripe/sapphire/commit/7408ba4) Removed unnecessary "Edit Page &gt; Reports" menu entry, feature will only be available through a dedicated "Reports" interface (Ingo Schommer)
 * 2011-09-19 [d0b419c](https://github.com/silverstripe/silverstripe-cms/commit/d0b419c) Showing class names in ClassDropDown in not en_US (fixes #6325, thanks dhensby) (Ingo Schommer)
 * 2011-09-15 [31b477e](https://github.com/silverstripe/sapphire/commit/31b477e) Added File.ShowInSearch flag to mirror the existing SiteTree.ShowInSearch flag - e.g. useful to limit visibility of user-uploaded files. Enforced in MySQLDatabase-&gt;searchEngine(). Tested in cms with SearchEngineTest. (Ingo Schommer)
 * 2011-09-15 [2693f67](https://github.com/silverstripe/silverstripe-cms/commit/2693f67) Testing new File.ShowInSearch flag, and adding it to AssetTableField view (Ingo Schommer)
 * 2011-09-09 [99355c0](https://github.com/silverstripe/sapphire/commit/99355c0) Added new onBeforeDuplicate() and onAfterDuplicate() hooks to DataObject (Ingo Schommer)
 * 2011-08-29 [6a98615](https://github.com/silverstripe/sapphire/commit/6a98615) Supporting values not in $source in LookupField, instead of displaying "(none)" (which makes it useable in DataDifferencer) (AIR-24) (Ingo Schommer)
 * 2011-08-29 [2ec2c97](https://github.com/silverstripe/sapphire/commit/2ec2c97) Allowing diffs of has_one relationship in DataDifferencer (AIR-24) (Ingo Schommer)
 * 2011-08-29 [4d31ac6](https://github.com/silverstripe/sapphire/commit/4d31ac6) Allowing array values in ListboxField-&gt;setValue(), serialising into comma-separated list of values (AIR-35) (Ingo Schommer)
 * 2011-08-22 [37dc807](https://github.com/silverstripe/sapphire/commit/37dc807) Added custom 'onafterinsert' event to forms dealing with link/image/flash insertion through tiny_mce_improvements.js, which allows e.g. to close them automatically after insertion (AIR-14) (Ingo Schommer)
 * 2011-08-22 [654173e](https://github.com/silverstripe/sapphire/commit/654173e) Allow usage of custom 'fieldClasses' argument to FormScaffolder for relationships (Ingo Schommer)
 * 2011-08-12 [aefda19](https://github.com/silverstripe/silverstripe-cms/commit/aefda19) Adding SilverStripe navigator to CMSMain-&gt;getEditForm() if not already present through LeftandMain-&gt;getEditForm() (in case custom $fields parameter is passed into the method) (Ingo Schommer)
 * 2011-07-21 [4461cae](https://github.com/silverstripe/sapphire/commit/4461cae) New CMSPreviewable interface class to standardize metadata making a record previewable by the CMS. ENHANCEMENT New "preview" and "edit" buttons to toggle between preview and cms views. Reinstated utility links to switch between draft and live preview (based on SilverStripeNavigator) (formerly called "AjaxSwitchView") (Ingo Schommer)
 * 2011-07-21 [ab3fe3e](https://github.com/silverstripe/silverstripe-cms/commit/ab3fe3e) Implementing CMSPreviewable in SiteTree (Ingo Schommer)
 * 2011-07-21 [00cc6dd](https://github.com/silverstripe/silverstripe-cms/commit/00cc6dd) More generic usage for SilverStripeNavigator (through new CMSPreviewable interface). Hiding certain items based on improved canView() logic. (Ingo Schommer)
 * 2011-07-21 [dacdade](https://github.com/silverstripe/sapphire/commit/dacdade) Removed automatic redirection to admin URLs in ContentController, too counter-intuitive and hard to implement consistently, while still allowing linkage of pages without CMS around them. Use $SilverStripeNavigator in custom Page.ss to link a page to its admin view for logged-in users. (Ingo Schommer)
 * 2011-07-21 [eecb401](https://github.com/silverstripe/silverstripe-cms/commit/eecb401) Removed automatic redirection to admin URLs in ContentController, too counter-intuitive and hard to implement consistently, while still allowing linkage of pages without CMS around them. (Ingo Schommer)
 * 2011-07-15 [e40d3d4](https://github.com/silverstripe/sapphire/commit/e40d3d4) $('.cms-preview').block()/unblock() for blocking preview window when unavailable. Fixed duplicate addition of GET parameters in preview with new jQuery.query library for parameter parsing. (Ingo Schommer)
 * 2011-07-06 [2ab9a06](https://github.com/silverstripe/silverstripe-cms/commit/2ab9a06) Changing CMSMain-&gt;RootForm() (edits SiteConfig record) from being invoked on the tree root node to having its own section called "Settings" in the CMS menu (through a new CMSSettingsController class) (Ingo Schommer)
 * 2011-06-09 [2f2096c](https://github.com/silverstripe/sapphire/commit/2f2096c) HTML5 History.pushState support in CMS (Ingo Schommer)
 * 2011-05-26 [0adac9d](https://github.com/silverstripe/sapphire/commit/0adac9d) Allowing filtered arguments on specific functions like mysql_connect() in SS_Backtrace (Ingo Schommer)
 * 2011-05-26 [0e0a59d](https://github.com/silverstripe/sapphire/commit/0e0a59d) Collapsible menu, disable menu actions on external links (Ingo Schommer)
 * 2011-05-20 [4e0949f](https://github.com/silverstripe/sapphire/commit/4e0949f) Consistently wrapping CMS forms in &lt;div class="cms-content"&gt;, added LeftAndMain.Content.js to reload panels via ajax, hooking into preview logic (Ingo Schommer)
 * 2011-05-19 [75ce441](https://github.com/silverstripe/silverstripe-cms/commit/75ce441) Redirecting to cms preview in ContentController if user is logged in (Ingo Schommer)
 * 2011-05-15 [2b56d2a](https://github.com/silverstripe/sapphire/commit/2b56d2a) Preview panel to show CMS changes on actual website. Navigating in preview loads new page for editing in CMS. (Ingo Schommer)
 * 2011-05-13 [686f101](https://github.com/silverstripe/sapphire/commit/686f101) Toggleable panels in CMS (Ingo Schommer)
 * 2011-05-08 [7a70b29](https://github.com/silverstripe/sapphire/commit/7a70b29) Support for record/selection-specific metadata in TreeDropdownField (e.g. useful for limiting available page type option based on a parent node selection) (Ingo Schommer)
 * 2011-05-08 [0b8f8a3](https://github.com/silverstripe/sapphire/commit/0b8f8a3) Checking allowed parents/children in tree dragging. Using 'data' attributes to encode metadata on the tree element (fixes #6578) (Frank Mullenger)
 * 2011-04-15 [b4366c9](https://github.com/silverstripe/silverstripe-cms/commit/b4366c9) 'data-hints' attribute into root of CMSMain site tree, changed from 'allowedParents' to 'disallowedParents', 'allowedChildren' to 'disallowedChildren' for brevity (fixes #6577) (Frank Mullenger)
 * 2011-03-19 [b254b6e](https://github.com/silverstripe/sapphire/commit/b254b6e) Pass through jQuery UI options through DateField-&gt;setConfig() (if applicable) (JayDevlin)
 * 2011-03-18 [a60f03f](https://github.com/silverstripe/sapphire/commit/a60f03f) Sapphire Doesn't Read HTTP Headers (fixes #6311) (ajshort)
 * 2011-03-18 [627a291](https://github.com/silverstripe/sapphire/commit/627a291) Image -&gt; SetWidth() and Image -&gt; SetHeight() generate new image when size is the same as the original file (fixes #5792) (j.m.milmine)

### Bugfixes

 * 2011-10-29 [c532354](https://github.com/silverstripe/silverstripe-cms/commit/c532354) Fixed loading of full page template via ajax in CMSPageHistoryController, which causes infinite loops in CMS initialization (Ingo Schommer)
 * 2011-10-29 [7be28d5](https://github.com/silverstripe/sapphire/commit/7be28d5) Making LeftAndMain-&gt;PreviewLink() an "opt-in", returning false by default to avoid adverse effects from loading unpreviewable items like users or filesystem folders - see CMSMain for sample implementation (Ingo Schommer)
 * 2011-10-29 [a5652ab](https://github.com/silverstripe/sapphire/commit/a5652ab) Added 'mceRemoveControl' calls to TinyMCE logic in CMS in order to reinitialise editors properly after replacing the panels via ajax (Ingo Schommer)
 * 2011-10-29 [c34ef60](https://github.com/silverstripe/silverstripe-cms/commit/c34ef60) prevent calling function on null record (Will Rossiter)
 * 2011-10-29 [6b88006](https://github.com/silverstripe/sapphire/commit/6b88006) show scroll bar on menu and side panels in adminstration section rather than hiding (Will Rossiter)
 * 2011-10-28 [3c5fd14](https://github.com/silverstripe/sapphire/commit/3c5fd14) Deprecation class throws notice on PHP 5.2 (Stig Lindqvist)
 * 2011-10-08 [916309e](https://github.com/silverstripe/silverstripe-cms/commit/916309e) returning false from canDeleteFromLive() for a DataObject did not remove the Unpublish button from CMS, but the Unpublish action returned an error. Fixes #6731. (Frank Mullenger)
 * 2011-10-07 [c630f83](https://github.com/silverstripe/sapphire/commit/c630f83) Setting level in DataObject-&gt;getChangedFields() to 'value change' rather than 'type change' for CompositeFields, so they save correctly (fixes #6726, thanks frankmullenger) (Ingo Schommer)
 * 2011-10-07 [f7d322a](https://github.com/silverstripe/silverstripe-cms/commit/f7d322a) Marking fields as readonly in CMSMain-&gt;compareversions() before loading data, to avoid loading invalid values (HTML diffs) into the fields (AIR-39) (Ingo Schommer)
 * 2011-10-07 [f98bc84](https://github.com/silverstripe/silverstripe-cms/commit/f98bc84) Respect writeWithoutVersion() when updating VirtualPage relationships in SiteTree-&gt;onAfterWrite() (AIR-97) (Ingo Schommer)
 * 2011-10-06 [d03724e](https://github.com/silverstripe/silverstripe-cms/commit/d03724e) Disable subsites filtering in File-&gt;BackLinkTracking() if module is installed (AIR-66) (Ingo Schommer)
 * 2011-09-27 [21d10ad](https://github.com/silverstripe/silverstripe-cms/commit/21d10ad) Consistently returning a record from VirtualPage-&gt;CopyContentFrom(), even if pointing to a non-existant ID (AIR-77) (Ingo Schommer)
 * 2011-09-27 [bf73265](https://github.com/silverstripe/sapphire/commit/bf73265) Added Fixing deprecated usage of array_multisort for php 5.3 (Stig Lindqvist)
 * 2011-09-26 [f8b2363](https://github.com/silverstripe/silverstripe-cms/commit/f8b2363) Replaced hardcoded CSS in ReportAdminForm.ss, using $FieldHolder instead of $Field for search fields to gain better control on how they're laid out (Ingo Schommer)
 * 2011-09-19 [8722398](https://github.com/silverstripe/silverstripe-cms/commit/8722398) Fixed history.pushState() ajax load duplication in CMSPageHistoryController.js (Ingo Schommer)
 * 2011-09-18 [a0eaad3](https://github.com/silverstripe/sapphire/commit/a0eaad3) Enforce status code set through SS_HTTPResponse-&gt;setStatusCode() in output(), override PHP auto-detection of code based on HTTP headers (thanks miiihi) (Ingo Schommer)
 * 2011-09-14 [f37640b](https://github.com/silverstripe/sapphire/commit/f37640b) Added support for array values in LookupField, to ensure it works correctly when used as a readonly representation of ListboxField (AIR-39) (Ingo Schommer)
 * 2011-09-14 [55183ec](https://github.com/silverstripe/sapphire/commit/55183ec) Reset WHERE clause in SQLMap-&gt;getItem() to ensure it can be invoked more than once (Ingo Schommer)
 * 2011-09-12 [3a5b3af](https://github.com/silverstripe/sapphire/commit/3a5b3af) Fixed tag stacking in Diff.php thirdparty lib (AIR-71) (Ingo Schommer)
 * 2011-08-29 [8cc1b4c](https://github.com/silverstripe/sapphire/commit/8cc1b4c) Bypassing setters in DataDifferencer to avoid problems with invalid data (e.g. HTML fragment instead of valid classname in SiteTree-&gt;setClassname(). Better validation of constructor parameters (AIR-42) (Ingo Schommer)
 * 2011-08-26 [7403056](https://github.com/silverstripe/sapphire/commit/7403056) Don't show CLI warnings from 'which' command in sake bash script by piping them to /dev/null ('which' fails silently on Debian, but produces warnings on CentOS) (AIR-25) (Ingo Schommer)
 * 2011-08-26 [823cae3](https://github.com/silverstripe/sapphire/commit/823cae3) Setting mbstring defaults in cli-script.php (same as main.php), and default mb_regex_encoding() to UTF-8 as well (in both files) (Ingo Schommer)
 * 2011-08-22 [7d01b40](https://github.com/silverstripe/sapphire/commit/7d01b40) Increasing length of Member.Email database column to comply with recommended RFC lengths for email addresses (Ingo Schommer)
 * 2011-07-26 [dfb0504](https://github.com/silverstripe/sapphire/commit/dfb0504) Setting "Content-Length" header in HTTPResponse to avoid problems with proxies timing out (Ingo Schommer)
 * 2011-07-06 [a3bd21b](https://github.com/silverstripe/sapphire/commit/a3bd21b) Don't trigger detail view in tree mode when first loaded (LeftAndMain.Content.js), limit to actual user clicks (Ingo Schommer)
 * 2011-05-19 [cfe0066](https://github.com/silverstripe/sapphire/commit/cfe0066) Allow omitting FROM clause in sqlQueryToString() (Ingo Schommer)
 * 2011-04-15 [2aa28c0](https://github.com/silverstripe/sapphire/commit/2aa28c0) Disabling add_sheet() on jstree, as its horribly slow (Ingo Schommer)
 * 2011-03-03 [135cb1c](https://github.com/silverstripe/sapphire/commit/135cb1c) Checking for node existence in get_text() for jquery.jstree.js (Ingo Schommer)

### Minor changes

 * 2011-10-30 [f815425](https://github.com/silverstripe/sapphire/commit/f815425) Fixed collapsed cms menu and preview by setting correct panel width (broken by 6b88006456) (Ingo Schommer)
 * 2011-10-30 [016c70a](https://github.com/silverstripe/sapphire/commit/016c70a) Fixed broken SS_MapTest in PostgreSQL. Need to sort the IDs before asserting the DataList contents. (Sean Harvey)
 * 2011-10-29 [e5b88c6](https://github.com/silverstripe/sapphire/commit/e5b88c6) Documentation (Ingo Schommer)
 * 2011-10-29 [3aafb63](https://github.com/silverstripe/sapphire/commit/3aafb63) Allowing usage of custom *_EditForm templates in base class with LeftAndMain-&gt;getEditForm() (was already implemented in subclasses) (Ingo Schommer)
 * 2011-10-29 [7e01c40](https://github.com/silverstripe/sapphire/commit/7e01c40) Avoid nesting metadata properties in TreeDropdownField, setting classname in metadata even if no record is pre-selected (Ingo Schommer)
 * 2011-10-29 [89abb29](https://github.com/silverstripe/silverstripe-cms/commit/89abb29) Fixed reading of javascript metadata in CMSMain.AddForm.js (Ingo Schommer)
 * 2011-10-29 [7924ce9](https://github.com/silverstripe/sapphire/commit/7924ce9) Fixed some JS warnings (Ingo Schommer)
 * 2011-10-29 [c6aa069](https://github.com/silverstripe/sapphire/commit/c6aa069) Moved &lt;ins&gt; and &lt;del&gt; styles to more specific selectors in cms module (Ingo Schommer)
 * 2011-10-29 [6683b38](https://github.com/silverstripe/sapphire/commit/6683b38) Protection against infinite initialization/callback loops caused by loading a full page template via ajax (in LeftAndMain.js) (Ingo Schommer)
 * 2011-10-29 [ec2b0a4](https://github.com/silverstripe/sapphire/commit/ec2b0a4) Apply loading styling to edit forms as well as content areas (Ingo Schommer)
 * 2011-10-29 [239ed13](https://github.com/silverstripe/silverstripe-cms/commit/239ed13) More specific selectors for &lt;ins&gt; and &lt;del&gt; styles in diff view, to avoid influencing jstree styling (Ingo Schommer)
 * 2011-10-29 [d66a472](https://github.com/silverstripe/silverstripe-cms/commit/d66a472) Implemented CMSMain-&gt;PreviewLink() (moved from LeftAndMain) (Ingo Schommer)
 * 2011-10-29 [ae4dcc4](https://github.com/silverstripe/silverstripe-cms/commit/ae4dcc4) Replaced calls to deprecated FormField-&gt;Name() with getName() (Ingo Schommer)
 * 2011-10-30 [748c019](https://github.com/silverstripe/silverstripe-cms/commit/748c019) Fixed broken CMSPageHistoryControllerTest assuming IDs (Sean Harvey)
 * 2011-10-30 [f2fba45](https://github.com/silverstripe/sapphire/commit/f2fba45) Fixed broken GridFieldPresenterTest assuming IDs (Sean Harvey)
 * 2011-10-29 [96d18ef](https://github.com/silverstripe/sapphire/commit/96d18ef) Replaced calls to deprecated FormField-&gt;Name() with getName() (Ingo Schommer)
 * 2011-10-29 [2ac0ea7](https://github.com/silverstripe/silverstripe-cms/commit/2ac0ea7) Don't emulate built-in radiobutton behaviour in CMSMain.AddForm.js (Ingo Schommer)
 * 2011-10-29 [6e2eaed](https://github.com/silverstripe/sapphire/commit/6e2eaed) Fixed batch action drop down width in CMS (somehow chosen.js interprets it as only 60px wide) (Ingo Schommer)
 * 2011-10-29 [2f4b630](https://github.com/silverstripe/sapphire/commit/2f4b630) Fixed broken test in PostgreSQL where assumption of IDs sorted isn't always the case (Sean Harvey)
 * 2011-10-29 [ac94809](https://github.com/silverstripe/sapphire/commit/ac94809) Fixed content loading overlay in CMS (Ingo Schommer)
 * 2011-10-29 [d020e65](https://github.com/silverstripe/sapphire/commit/d020e65) Updated TinyMCE dependency from 3.1 to 3.4.6 (Ingo Schommer)
 * 2011-10-29 [8f96ea7](https://github.com/silverstripe/sapphire/commit/8f96ea7) Fixed hardcoded IDs in DataListTest which fail in PostgreSQL (Sean Harvey)
 * 2011-10-29 [f4643e1](https://github.com/silverstripe/sapphire/commit/f4643e1) Added double quotes around column names in AggregateTest (Sean Harvey)
 * 2011-10-29 [01bfdbe](https://github.com/silverstripe/sapphire/commit/01bfdbe) tweaks to SecurityAdmin layout (Will Rossiter)
 * 2011-10-29 [e2b4913](https://github.com/silverstripe/silverstripe-cms/commit/e2b4913) moved title for content tools panel into scrollable region (Will Rossiter)
 * 2011-10-29 [a08a08e](https://github.com/silverstripe/sapphire/commit/a08a08e) move panel title into scrollable panel (Will Rossiter)
 * 2011-10-29 [aba6b44](https://github.com/silverstripe/sapphire/commit/aba6b44) remove console.log. MINOR clean up for icon sprites in the cms and content toolbars (Will Rossiter)
 * 2011-10-29 [f634ad0](https://github.com/silverstripe/silverstripe-cms/commit/f634ad0) update template to use jlayout (Will Rossiter)
 * 2011-10-29 [3d77214](https://github.com/silverstripe/sapphire/commit/3d77214) remove old stylesheet (Will Rossiter)
 * 2011-10-29 [b70bc85](https://github.com/silverstripe/sapphire/commit/b70bc85) remove missing icon from debug view (Will Rossiter)
 * 2011-10-28 [6cf03b9](https://github.com/silverstripe/sapphire/commit/6cf03b9) Fixed whitespace and added docblocks (Stig Lindqvist)
 * 2011-10-27 [7a4c7a6](https://github.com/silverstripe/sapphire/commit/7a4c7a6) Redirect user to homepage if the BackURL have been set to another site. (Stig Lindqvist)
 * 2011-10-27 [6db8306](https://github.com/silverstripe/sapphire/commit/6db8306) Do a isset check before using the value. (Stig Lindqvist)
 * 2011-10-27 [3a11bb2](https://github.com/silverstripe/sapphire/commit/3a11bb2) Do not call a constructor if there aren't one. (Stig Lindqvist)
 * 2011-10-27 [4123d2c](https://github.com/silverstripe/sapphire/commit/4123d2c) Added more tests to the DataList to improve the coverage. (Stig Lindqvist)
 * 2011-10-26 [d81b46f](https://github.com/silverstripe/silverstripe-cms/commit/d81b46f) Fixed some inline documentation (Stig Lindqvist)
 * 2011-10-22 [15ad2d2](https://github.com/silverstripe/sapphire/commit/15ad2d2) Fixing the path of the CSS files in LeftAndMain (Stig Lindqvist)
 * 2011-10-22 [d6f7b55](https://github.com/silverstripe/sapphire/commit/d6f7b55) Fix test to use the non deprecated way of fetching database records (Stig Lindqvist)
 * 2011-10-22 [a3a50b7](https://github.com/silverstripe/silverstripe-cms/commit/a3a50b7) Skipping test when PHP Version is lower than 5.3.2 (Stig Lindqvist)
 * 2011-10-18 [b4a8852](https://github.com/silverstripe/sapphire/commit/b4a8852) Updated changelog (Ingo Schommer)
 * 2011-10-10 [340a779](https://github.com/silverstripe/sapphire/commit/340a779) More transliteration matches for Lithuanian (fixes #6724, thanks zyzzza) (Ingo Schommer)
 * 2011-10-07 [670eec9](https://github.com/silverstripe/sapphire/commit/670eec9) Documentation (Ingo Schommer)
 * 2011-10-07 [dcf5995](https://github.com/silverstripe/sapphire/commit/dcf5995) Removed dependency of DatagridFunctionalTest on ContentController (sapphire vs. cms) (Ingo Schommer)
 * 2011-10-07 [0a8a178](https://github.com/silverstripe/sapphire/commit/0a8a178) Quoting relation tables in new ManyManyList API (Ingo Schommer)
 * 2011-10-07 [cc61551](https://github.com/silverstripe/sapphire/commit/cc61551) Using raw SQL queries in DBDatetimeTest as SQLQuery returns false if no explicit FROM part is provided (previously working API was broken in 4171015d) (Ingo Schommer)
 * 2011-10-07 [0899738](https://github.com/silverstripe/silverstripe-cms/commit/0899738) Using increase_memory_limit_to() in CMSMain-&gt;buildbrokenlinks() (Ingo Schommer)
 * 2011-10-06 [40db114](https://github.com/silverstripe/sapphire/commit/40db114) Resetting date/time defaults for DateFieldTest, TimeFieldTest, DatetimeFieldTest (Ingo Schommer)
 * 2011-10-04 [2ef1ae3](https://github.com/silverstripe/silverstripe-cms/commit/2ef1ae3) Fixed method signature on batch actions (Ingo Schommer)
 * 2011-10-04 [df56eb5](https://github.com/silverstripe/sapphire/commit/df56eb5) Don't throw deprecation notice on DataObjectSet and FieldSet if there's still over 500 (!) references to them in core, as it basically means that everybody has to suppress PHP NOTICE errors for months, impacting core code quality (Ingo Schommer)
 * 2011-10-04 [7b38fcf](https://github.com/silverstripe/sapphire/commit/7b38fcf) Updated jQuery UI from 1.8.10 to 1.8.16 (Ingo Schommer)
 * 2011-10-04 [5db7f38](https://github.com/silverstripe/sapphire/commit/5db7f38) Updated jQuery from 1.5 to 1.6.4 (Ingo Schommer)
 * 2011-10-04 [4b1b7d4](https://github.com/silverstripe/sapphire/commit/4b1b7d4) Moved jstree piston origin to github (need to reapply patches) (Ingo Schommer)
 * 2011-09-29 [1811fc2](https://github.com/silverstripe/sapphire/commit/1811fc2) Cleaning up code of Datagrid with related classes with more tests (Stig Lindqvist)
 * 2011-09-28 [7d90aa3](https://github.com/silverstripe/sapphire/commit/7d90aa3) Changed inline documentation to be correct (Stig Lindqvist)
 * 2011-09-27 [ce81740](https://github.com/silverstripe/silverstripe-cms/commit/ce81740) Added 'skipSyncLinkTracking' flag to FilesystemSyncTask (AIR-28) (Ingo Schommer)
 * 2011-09-27 [e3cceb6](https://github.com/silverstripe/sapphire/commit/e3cceb6) Refactored DateField.js from inline jQuery.live() application to a ssDatepicker() plugin which can be applied explicitly as well (Ingo Schommer)
 * 2011-09-27 [75c0fcd](https://github.com/silverstripe/sapphire/commit/75c0fcd) Better isset checks on Versioned#allVersions() due to changes in SQLQuery (Stig Lindqvist)
 * 2011-09-27 [8d7bfd4](https://github.com/silverstripe/sapphire/commit/8d7bfd4) Fixed DataObjectTest to use ManyManyList when testing relation manipulations (Stig Lindqvist)
 * 2011-09-27 [73c2491](https://github.com/silverstripe/sapphire/commit/73c2491) Fixed the SQLQuery to return empty query in only certain cases (Stig Lindqvist)
 * 2011-09-27 [2101d3c](https://github.com/silverstripe/sapphire/commit/2101d3c) Added codecoverage on a single test to the allowed actions (Stig Lindqvist)
 * 2011-09-27 [4171015](https://github.com/silverstripe/sapphire/commit/4171015) SQLQuery without a FROM table should return empty query (Stig Lindqvist)
 * 2011-09-26 [aa60201](https://github.com/silverstripe/sapphire/commit/aa60201) Making date/time order and separation configurable through DatetimeField-&gt;setConfig('datetimeorder') (Ingo Schommer)
 * 2011-09-26 [37d197c](https://github.com/silverstripe/sapphire/commit/37d197c) altered skipTest to be a instance property rather than static (Will Rossiter)
 * 2011-09-23 [f368686](https://github.com/silverstripe/silverstripe-cms/commit/f368686) Documentation (Ingo Schommer)
 * 2011-09-23 [6564faf](https://github.com/silverstripe/sapphire/commit/6564faf) Removed unused  parameter from File-&gt;Link() and File-&gt;RelativeLink() (Ingo Schommer)
 * 2011-09-19 [443777e](https://github.com/silverstripe/sapphire/commit/443777e) Selecting parents of nested menu entries by default in LeftAndMain.Menu.js (Ingo Schommer)
 * 2011-09-19 [ab9d62b](https://github.com/silverstripe/silverstripe-cms/commit/ab9d62b) Removed hardcoding of history ajax links (Ingo Schommer)
 * 2011-09-19 [8adb259](https://github.com/silverstripe/sapphire/commit/8adb259) Exclude buttons from focusing first elements in CMS edit form, as it stuffs up the layout engine (Ingo Schommer)
 * 2011-09-19 [b4fd20d](https://github.com/silverstripe/sapphire/commit/b4fd20d) More flexible definition of non-previewable CMS interfaces (Ingo Schommer)
 * 2011-09-19 [10e7683](https://github.com/silverstripe/silverstripe-cms/commit/10e7683) Fixed history panel non-ajax loading and version links in "comparing X and Y" titles (Ingo Schommer)
 * 2011-09-19 [c862b24](https://github.com/silverstripe/sapphire/commit/c862b24) Fixed merge errors from 'history-panel' branch (Ingo Schommer)
 * 2011-09-19 [168b1ff](https://github.com/silverstripe/sapphire/commit/168b1ff) Allowing to retrieve the whole configuration array in DateField/TimeField/DateetimeField-&gt;getConfig() (Ingo Schommer)
 * 2011-09-18 [5de2ba5](https://github.com/silverstripe/silverstripe-cms/commit/5de2ba5) Removing executable flag from all files (thanks miiihi) (Ingo Schommer)
 * 2011-09-18 [ce8e72c](https://github.com/silverstripe/sapphire/commit/ce8e72c) Removing executable flag from all files (thanks miiihi) (Ingo Schommer)
 * 2011-09-15 [67568b0](https://github.com/silverstripe/sapphire/commit/67568b0) Checking for valid field type in DataDifferencer (built-in fields like 'RecordClassName' can't be casted to a field object) (Ingo Schommer)
 * 2011-09-09 [72d5423](https://github.com/silverstripe/sapphire/commit/72d5423) Removed debug code from Diff.php (Ingo Schommer)
 * 2011-09-01 [093eb6c](https://github.com/silverstripe/silverstripe-cms/commit/093eb6c) Checking for success of file upload before trying to add metadata in AssetAdmin-&gt;doUpload() (AIR-37) (Ingo Schommer)
 * 2011-08-30 [45f857e](https://github.com/silverstripe/silverstripe-cms/commit/45f857e) Removing class comparison in SiteTree-&gt;canCreate() (mainly in order to enable overloading via SiteTreeSubsite-&gt;canCreate()) (Ingo Schommer)
 * 2011-08-30 [5257c35](https://github.com/silverstripe/sapphire/commit/5257c35) Documentation (Ingo Schommer)
 * 2011-08-30 [54b81a3](https://github.com/silverstripe/sapphire/commit/54b81a3) Don't set cookies in CLI mode for Versioned (AIR-75) (Ingo Schommer)
 * 2011-08-29 [6e1013e](https://github.com/silverstripe/sapphire/commit/6e1013e) Allowing HTML values in SimpleImageField_Readonly in order to allow image-based diffs (Ingo Schommer)
 * 2011-08-29 [922dd12](https://github.com/silverstripe/silverstripe-cms/commit/922dd12) Allowing TRUE vetoes in SiteTree-&gt;augmentValidURLSegment() (in addition to the existing FALSE vetoes) (Ingo Schommer)
 * 2011-08-29 [d6f4b24](https://github.com/silverstripe/sapphire/commit/d6f4b24) Allowing array-based values in Diff-&gt;getHTMLChunks() by imploding on comma (AIR-39) (Ingo Schommer)
 * 2011-08-29 [007eb25](https://github.com/silverstripe/sapphire/commit/007eb25) Added DataDifferencerTest, starting by testing array-based values (AIR-39) (Ingo Schommer)
 * 2011-08-26 [de13f14](https://github.com/silverstripe/silverstripe-cms/commit/de13f14) Argument checks in AssetTableField-&gt;getCustomFieldsFor() (AIR-40) (Ingo Schommer)
 * 2011-08-16 [3bd80df](https://github.com/silverstripe/sapphire/commit/3bd80df) Requiring behaviour.js for TimeField, and using document.getElementById() instead of $ function alias in TimeField_dropdown.js (Ingo Schommer)
 * 2011-08-14 [1b39780](https://github.com/silverstripe/sapphire/commit/1b39780) Added FileIframeField-&gt;getCanUploadNewFile() (Ingo Schommer)
 * 2011-08-12 [8249834](https://github.com/silverstripe/sapphire/commit/8249834) Adding 'runTask' to allowed_actions in TaskRunner (Ingo Schommer)
 * 2011-08-12 [e35b4b6](https://github.com/silverstripe/sapphire/commit/e35b4b6) Updated language files (Ingo Schommer)
 * 2011-08-12 [bc9fb12](https://github.com/silverstripe/sapphire/commit/bc9fb12) Fixed LeftAndMainTest assertions around DBField instead of string values (broken in 1827c18f) (Ingo Schommer)
 * 2011-07-21 [07094f5](https://github.com/silverstripe/silverstripe-cms/commit/07094f5) Removed temporary preview links in CMSPageEditController (Ingo Schommer)
 * 2011-07-21 [c06d52d](https://github.com/silverstripe/sapphire/commit/c06d52d) Delegated JavaScript layout from .cms-container to redraw() methods on the individual panels (Ingo Schommer)
 * 2011-07-21 [5062dd9](https://github.com/silverstripe/sapphire/commit/5062dd9) Removed debug comments from generated screen.css (Ingo Schommer)
 * 2011-07-15 [6d26a88](https://github.com/silverstripe/sapphire/commit/6d26a88) Better redrawing of panels loaded via ajax in CMS (no jslayout/tabset glitches, loading overlay) (Ingo Schommer)
 * 2011-07-15 [475e055](https://github.com/silverstripe/sapphire/commit/475e055) Avoid triggering $('.cms-menu') item selection when already selected. Add new 'select' event for easier customization (Ingo Schommer)
 * 2011-07-07 [928884c](https://github.com/silverstripe/sapphire/commit/928884c) IE compatibility fixes in new admin CSS (Ingo Schommer)
 * 2011-07-07 [d77cbe6](https://github.com/silverstripe/sapphire/commit/d77cbe6) Cleaned up structure and documentation of SCSS files in sapphire/admin/scss (Ingo Schommer)
 * 2011-07-06 [bb0574e](https://github.com/silverstripe/silverstripe-cms/commit/bb0574e) Extra CSS classes in SiteTree-&gt;getCMSActions() (Ingo Schommer)
 * 2011-07-06 [177e085](https://github.com/silverstripe/sapphire/commit/177e085) Improved CSS for left navigation, tabs and form fields (Ingo Schommer)
 * 2011-07-06 [657dbc1](https://github.com/silverstripe/sapphire/commit/657dbc1) Recompiled CSS from SCSS (Ingo Schommer)
 * 2011-07-06 [8382ebb](https://github.com/silverstripe/silverstripe-cms/commit/8382ebb) Using post() instead of submitForm() in CMSMainTest to work around SimpleTest issues (Ingo Schommer)
 * 2011-07-06 [17131f7](https://github.com/silverstripe/silverstripe-cms/commit/17131f7) Fall back to homepage record for CMSMain-&gt;PreviewLink() (Ingo Schommer)
 * 2011-07-05 [a1b8698](https://github.com/silverstripe/sapphire/commit/a1b8698) Removed '.LeftAndMain' selector from rules in order to avoid DOM hierarchy confusion (.LeftAndMain contains .cms-content vs .LeftAndMain equals .cms-content) (Ingo Schommer)
 * 2011-07-05 [19b9edb](https://github.com/silverstripe/sapphire/commit/19b9edb) Clearer CSS classes in CMS controller templates. Fixed JS loading of ModelAdmin panels. Added $BaseCSSClasses to content templates in order to support partial template loads through ajax (instead of relying on stale CSS classes on the &lt;body&gt; tag). Leaving $BaseCSSClasses in LeftAndMain.ss base template for legacy reasons. (Ingo Schommer)
 * 2011-07-05 [38db63c](https://github.com/silverstripe/silverstripe-cms/commit/38db63c) Clearer CSS classes in CMS controller templates, added $BaseCSSClasses to content templates in order to support partial template loads through ajax (instead of relying on stale CSS classes on the &lt;body&gt; tag) (Ingo Schommer)
 * 2011-07-04 [1dc9457](https://github.com/silverstripe/sapphire/commit/1dc9457) Using LeftAndMain-&gt;BaseCSSClasses() instead of ViewableData-&gt;CSSClasses() to avoid conflicts with customized controller objects (e.g. ModelAdmin_RecordController-&gt;edit()) (Ingo Schommer)
 * 2011-07-04 [c4a99df](https://github.com/silverstripe/silverstripe-cms/commit/c4a99df) Redirecting page links in CMSPagesController to CMSPageEditController (admin/pages/show/99 to admin/page/show/99) (Ingo Schommer)
 * 2011-07-04 [2e9ea1d](https://github.com/silverstripe/sapphire/commit/2e9ea1d) Disable ping until jQuery.entwine _super() confusion is resolved (Ingo Schommer)
 * 2011-06-25 [ebb1e0f](https://github.com/silverstripe/silverstripe-cms/commit/ebb1e0f) Additional HTML for tree styling in SiteTree-&gt;getTreeTitle() (Ed)
 * 2011-06-25 [ed449ee](https://github.com/silverstripe/sapphire/commit/ed449ee) CSS styles for tree and misc. form elements (Ed)
 * 2011-06-14 [a142e49](https://github.com/silverstripe/silverstripe-cms/commit/a142e49) class additions to assist styling elements in cms-content-toolbar (Ed)
 * 2011-06-09 [803a3d9](https://github.com/silverstripe/sapphire/commit/803a3d9) CSS styles for admin buttons. Color defintions set into _default.scss (Ed)
 * 2011-06-09 [b326f03](https://github.com/silverstripe/sapphire/commit/b326f03) Using LeftAndMain-&gt;Link() $action parameter correctly in getSiteTreeFor() (Ingo Schommer)
 * 2011-06-08 [c4c3d21](https://github.com/silverstripe/silverstripe-cms/commit/c4c3d21) Using Form-&gt;forTemplate() to include &lt;form&gt; tags in controller actions on AssetAdmin and CMSMain (underlying clientside logic has changed) (Ingo Schommer)
 * 2011-06-08 [490fd01](https://github.com/silverstripe/sapphire/commit/490fd01) Contributing docs (Ingo Schommer)
 * 2011-05-31 [908eeb4](https://github.com/silverstripe/sapphire/commit/908eeb4) Fixed SQL quoting in DbDatetimeTest (broke PostgreSQL) (Ingo Schommer)
 * 2011-05-31 [e1931c1](https://github.com/silverstripe/sapphire/commit/e1931c1) Updated MemberTest to accept new default date formats caused by Zend/CLDR upgrade (from 'MM/dd/yyyy' to a less ambiguous 'MMM d, y') (Ingo Schommer)
 * 2011-05-30 [0f7b115](https://github.com/silverstripe/sapphire/commit/0f7b115) Updated MemberDatetimeOptionsetFieldTest, i18nTest, MoneyTest to accept new default date formats caused by Zend/CLDR upgrade (from 'MM/dd/yyyy' to a less ambiguous 'MMM d, y') (Ingo Schommer)
 * 2011-05-30 [f11751c](https://github.com/silverstripe/sapphire/commit/f11751c) Fixed SS_LogEmailWriter and SS_LogFileWriter to adhere to new Zend interface (Ingo Schommer)
 * 2011-05-28 [2a13fa2](https://github.com/silverstripe/silverstripe-cms/commit/2a13fa2) SiteTree documentation (mattclegg)
 * 2011-05-25 [3588cef](https://github.com/silverstripe/sapphire/commit/3588cef) DateField documentation (Ingo Schommer)
 * 2011-05-24 [4f90659](https://github.com/silverstripe/sapphire/commit/4f90659) Fixed CheckboxSetTest (broken by wrossiter in 771e93ef18858a0a4ab1088d0678ce9e4fca75df) (Ingo Schommer)
 * 2011-05-20 [f90c317](https://github.com/silverstripe/sapphire/commit/f90c317) Removed unnecessary files for history.js (Ingo Schommer)
 * 2011-05-20 [a5f8417](https://github.com/silverstripe/sapphire/commit/a5f8417) Added history.js dependency (Ingo Schommer)
 * 2011-05-20 [8378a9d](https://github.com/silverstripe/sapphire/commit/8378a9d) Moved "pinging" logic for CMS into new LeftAndMain.Ping.js container (Ingo Schommer)
 * 2011-05-20 [00b1bf8](https://github.com/silverstripe/sapphire/commit/00b1bf8) Fixed DataObjectTest-&gt;testNewClassInstance() to use same ancestry classes, broken in dc367258 (Ingo Schommer)
 * 2011-05-20 [d157e6e](https://github.com/silverstripe/sapphire/commit/d157e6e) Removing 'text' CSS class from CheckboxField_Disabled to avoid different styling from standard checkbox (fixes #6636, thanks theAlien) (Ingo Schommer)
 * 2011-05-19 [67ec236](https://github.com/silverstripe/sapphire/commit/67ec236) Fixed RestfulServerTest (Ingo Schommer)
 * 2011-05-19 [ced7d6d](https://github.com/silverstripe/sapphire/commit/ced7d6d) Return empty string from SQLQuery-&gt;sql() if SELECT is the default value, and no FROM is set (moved logic from DB-specific implementations) (Ingo Schommer)
 * 2011-05-19 [11b409a](https://github.com/silverstripe/sapphire/commit/11b409a) Using SQLQuery wrapper in DbDatetimeTest to provide better cross-db support, specifically correct LIMIT syntax in MSSQL (previously broken in a9b13509) (Ingo Schommer)
 * 2011-05-19 [c196c47](https://github.com/silverstripe/silverstripe-cms/commit/c196c47) Temporarily disabled deprecation notice in SiteTreeDecorator, to be re-enabled once we're in beta (Ingo Schommer)
 * 2011-05-19 [a2d334c](https://github.com/silverstripe/sapphire/commit/a2d334c) Fixed fixture ordering in RestfulServerTest to work with PostgreSQL (Ingo Schommer)
 * 2011-05-19 [cbf191b](https://github.com/silverstripe/sapphire/commit/cbf191b) Temporarily disabled deprecation notice in DataObjectDecorator and LeftAndMainDecorator, to be re-enabled once we're in beta stage (they unnecessarily break too many modules for now (Ingo Schommer)
 * 2011-05-15 [18b9a55](https://github.com/silverstripe/sapphire/commit/18b9a55) Removed oudated documentation link to 'translatable' module (Ingo Schommer)
 * 2011-05-13 [6649d69](https://github.com/silverstripe/sapphire/commit/6649d69) Updated menu icons (Ingo Schommer)
 * 2011-05-13 [1ad4bd6](https://github.com/silverstripe/silverstripe-cms/commit/1ad4bd6) Panel markup for AssetAdmin and CMSPagesController templates (Ingo Schommer)
 * 2011-05-12 [340f2ce](https://github.com/silverstripe/sapphire/commit/340f2ce) Updated jquery-entwine (Ingo Schommer)
 * 2011-05-08 [4feae59](https://github.com/silverstripe/sapphire/commit/4feae59) Only setting form state if form element is available in 'ss-ui-button' (Ingo Schommer)
 * 2011-05-01 [1189bcb](https://github.com/silverstripe/sapphire/commit/1189bcb) Documentation corrected download link for tutorial code (Al)

### Other

 * 2011-10-29 [82da8a0](https://github.com/silverstripe/sapphire/commit/82da8a0) Only set the create_table_options value when enabling FulltextSearch (Simon Welsh)
 * 2011-10-29 [9dac9e5](https://github.com/silverstripe/sapphire/commit/9dac9e5) When relying on the order of returned objects, sort explicitly as it is nondeterminate for non-MySQL. (Simon Welsh)
 * 2011-10-29 [89ec7e6](https://github.com/silverstripe/sapphire/commit/89ec7e6) When relying on the order of returned objects, sort explicitly as it is nondeterminate for non-MySQL. (Simon Welsh)
 * 2011-10-29 [2c0257e](https://github.com/silverstripe/sapphire/commit/2c0257e) Cast the header value to string as PHPUnit can't handle it being NULL. (Simon Welsh)
 * 2011-10-29 [af144d9](https://github.com/silverstripe/sapphire/commit/af144d9) WS (Simon Welsh)
 * 2011-10-29 [03f52c4](https://github.com/silverstripe/sapphire/commit/03f52c4) Adds docs on Fulltext search usage in MySQL (Simon Welsh)
 * 2011-10-29 [ca074eb](https://github.com/silverstripe/sapphire/commit/ca074eb) Changes default MySQL storage engine to InnoDB. File requires MyISAM for FulltextSearch. (Simon Welsh)
 * 2011-10-29 [6bf3f7d](https://github.com/silverstripe/sapphire/commit/6bf3f7d) Switches MySQLDatabase to use the MySQLi class rather than the mysql_* functions. (Simon Welsh)
 * 2011-10-29 [1eab669](https://github.com/silverstripe/sapphire/commit/1eab669) Fucntion signatures should match when containing arrays (PHP5.4 bug) (Simon Welsh)
 * 2011-10-29 [840343f](https://github.com/silverstripe/sapphire/commit/840343f) Checks for array to string conversion (E_NOTICE as of PHP5.4) (Simon Welsh)
 * 2011-10-29 [75b16f6](https://github.com/silverstripe/sapphire/commit/75b16f6) Don't try redirecting to install.php if there is no install.php to redirect to. (Simon Welsh)
 * 2011-10-29 [5ad5dfc](https://github.com/silverstripe/sapphire/commit/5ad5dfc) Changes error reporting level to explicitly exclude E_DREPRECATED and E_STRICT, rather than xor. (Simon Welsh)
 * 2011-10-28 [33de79e](https://github.com/silverstripe/sapphire/commit/33de79e) BUGIX Altering calls to methods that are not deprecated (Stig Lindqvist)
 * 2011-10-18 [9bd4996](https://github.com/silverstripe/sapphire/commit/9bd4996) Spelling correction (Fred Condo)
 * 2011-09-19 [b80efb7](https://github.com/silverstripe/sapphire/commit/b80efb7) Add comment about duplicating create options as well as structure. (simonwelsh)
 * 2011-09-14 [af81f44](https://github.com/silverstripe/sapphire/commit/af81f44) [BUGFIX] Files with uppercase extensions were not being assigned an appCategory() (Al)
 * 2011-09-12 [7e1b8a8](https://github.com/silverstripe/silverstripe-cms/commit/7e1b8a8) Changed Dropdown value to language specific to allow setting default to 'any' (Tim Klein)
 * 2011-08-16 [dbdfa01](https://github.com/silverstripe/sapphire/commit/dbdfa01) Added an additional utility function to return country name from code from the Geoip class. (drzax)
 * 2011-08-11 [cbd42ed](https://github.com/silverstripe/sapphire/commit/cbd42ed) This class attempts to run the extraStatics method without first checking it exists. There's no reason why a data object decorator would necessarily add extra statics. (drzax)
 * 2011-06-23 [bb09555](https://github.com/silverstripe/sapphire/commit/bb09555) Forgot to remove this line in my last commit. (Colby Klein)
 * 2011-06-23 [1460789](https://github.com/silverstripe/sapphire/commit/1460789) Fix tabindex being present on read only form fields instead of regular ones. (Colby Klein)
 * 2011-06-08 [047d256](https://github.com/silverstripe/sapphire/commit/047d256) Updated return types for createTag and describe in documentation (Marijn Kampf)
 * 2011-03-18 [cae7791](https://github.com/silverstripe/sapphire/commit/cae7791) Allowing success and error callbacks in refresh() (Ingo Schommer)