<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Tasks extends Model
{
    use HasFactory;

    // Define the table associated with the model
    protected $table = 'tasks';

    // Define the primary key (optional if not the default 'id')
    protected $primaryKey = 'id';

    // Define the attributes that are mass assignable
    protected $fillable = [
        'task_name', // Corrected case to match typical conventions
        'project_id',
        'assigned_to',
        'due_date',
        'task_status',
        'priority_status',
        'plan_start_date',
        'plan_end_date',
        'start_date',
        'end_date',
        'total_hours',
        'estimate_hours',
        'progress',
        'description',
        'creator_id'
    ];

    // Define the attributes that should be cast to specific data types
    protected $casts = [
        'due_date' => 'date',
        'plan_start_date' => 'date',
        'plan_end_date' => 'date',
        'start_date' => 'date',
        'end_date' => 'date',
    ];

    // Example relationship if needed:
    // public function project()
    // {
    //     return $this->belongsTo(Project::class, 'project_id');
    // }

    // public function user()
    // {
    //     return $this->belongsTo(User::class, 'assigned_to');
    // }
}
