<?php

namespace App\Http\Controllers;

use App\Models\Project;
use App\Models\Tasks;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;

class TaskController extends Controller
{
    // Display the list of tasks
    public function index()
    {
        $tasks = Tasks::all(); // Get all tasks
        $users = User::all();
        $projects = Project::all();
        return view('tasks.index', compact('tasks','users','projects'));
    }

    // Show the form for creating a new task
    public function create()
    {
        return view('tasks.create');
    }

    // Store a newly created task
    public function store(Request $request)
    {
        // return "HAAI";
        // die();
        // Validate the task data
        // $request->validate([
        //     'task_name' => 'required|max:255',
        //     'project_id' => 'nullable|integer', // Assuming there's a 'projects' table
        //     'assigned_to' => 'nullable|integer', // Assuming there's a 'users' table
        //     'due_date' => 'required|date',
        //     'task_status' => 'required|in:pending,in-progress,completed',
        //     'priority_status' => 'required|in:low,medium,high',
        //     'estimate_hours' => 'required|integer',
        //     'description' => 'nullable|string',
        // ]);

        // Create a new task
        $task = new Tasks([
            'task_name' => $request->task_name,
            'project_id' => $request->project_id,
            'assigned_to' => $request->assigned_to,
            'due_date' => $request->due_date,
            'task_status' => $request->task_status,
            'priority_status' => $request->priority_status,
            'plan_start_date' => $request->plan_start_date,
            'plan_end_date' => $request->plan_end_date,
            'start_date' => $request->start_date,
            'end_date' => $request->end_date,
            'total_hours' => $request->total_hours,
            'estimate_hours' => $request->estimate_hours,
            'progress' => $request->progress,
            'description' => $request->description,
            'creator_id' => $request->creator_id, // Assuming the logged-in user is the task creator
        ]);

        $task->save();
    
        return redirect()->route('task.index')->with('success', 'Task created successfully');
    }

    // Show the form for editing a task
    public function edit(Request $request)
    {
        $task = Tasks::find($request->id)->first();
        return response()->json($task);
        // return view('tasks.edit', compact('task'));
    }

    // Update an existing task
    public function update(Request $request, $id)
    {
        // Validate the task data
        $request->validate([
            'task_name' => 'required|max:255',
            'project_id' => 'nullable|integer',
            'assigned_to' => 'nullable|integer',
            'due_date' => 'required|date',
            'task_status' => 'required|in:pending,in-progress,completed',
            'priority_status' => 'required|in:low,medium,high',
            'estimate_hours' => 'required|integer',
            'description' => 'nullable|string',
        ]);

        $task = Tasks::findOrFail($id);
        
        // Update the task fields
        $task->task_name = $request->task_name;
        $task->project_id = $request->project_id;
        $task->assigned_to = $request->assigned_to;
        $task->due_date = $request->due_date;
        $task->task_status = $request->task_status;
        $task->priority_status = $request->priority_status;
        $task->plan_start_date = $request->plan_start_date;
        $task->plan_end_date = $request->plan_end_date;
        $task->start_date = $request->start_date;
        $task->end_date = $request->end_date;
        $task->total_hours = $request->total_hours;
        $task->estimate_hours = $request->estimate_hours;
        $task->progress = $request->progress;
        $task->description = $request->description;
        
        $task->save();

        return redirect()->route('task.index')->with('success', 'Task updated successfully');
    }

    // Delete a task
    public function destroy($id)
    {
        $task = Tasks::findOrFail($id);
        $task->delete();

        return redirect()->route('task.index')->with('success', 'Task deleted successfully');
    }

    // View the details of a specific task
    public function show($id)
    {
        $task = Tasks::findOrFail($id);
        return view('tasks.show', compact('task'));
    }
}
