<?php

namespace App\Http\Controllers;

use App\Models\Defect;
use App\Models\department;
use App\Models\Project;
use App\Models\User;
use Illuminate\Http\Request;

class DefectController extends Controller
{
    // Display a listing of the defects
    public function index()
    {
        $defects = Defect::all(); // Get all defects from the database
        $projects = Project::all();
        $users = User::all();
        $groups = department::all();
        // dd($projects);
        return view('defects.index', compact('defects','projects','users','groups')); // Return to the view with defects
    }

    // Show the form for creating a new defect
    public function create()
    {
        return view('defects.create');
    }

    // Store a newly created defect in storage
    public function store(Request $request)
{
    // Validate the incoming data
    $validated = $request->validate([
        'defect_name' => 'required|string|max:255',
        'project_id' => 'required|integer',
        'defect_type' => 'required|string|max:255',
        'defect_description' => 'nullable|string',
        'assigned_team' => 'nullable|string',
        'estimated_hours' => 'nullable|numeric', // Changed to numeric to allow decimals
        'fileupload' => 'nullable|file|mimes:jpg,png,pdf,docx,txt', // You can define accepted file types
        'overdue' => 'nullable', // Changed to date for correct date input
        'severity' => 'nullable|string|max:255',
        'status' => 'nullable|string|max:255',
        'reported_by' => 'nullable|string|max:255',
        'assigned_to' => 'nullable|string|max:255',
        'created_user_id' => 'nullable',
        'start_date' => 'nullable|date',
        'end_date' => 'nullable|date',
    ]);

    // Create a new defect instance
    $defect = new Defect([
        'defect_name' => $request->defect_name,
        'project_id' => $request->project_id,
        'defect_type' => $request->defect_type,
        'defect_description' => $request->defect_description,
        'assigned_team' => $request->assigned_team,
        'estimated_hours' => $request->estimated_hours,
        'overdue' => $request->overdue,
        'severity' => $request->severity,
        'status' => $request->status,
        'reported_by' => $request->reported_by,
        'assigned_to' => $request->assigned_to,
        'created_user_id' => $request->created_user_id,
        'start_date' => $request->start_date,
        'end_date' => $request->end_date,
    ]);

    // Handle file upload (fileupload field)
    if ($request->hasFile('fileupload')) {
        // Validate and save the uploaded file
        $file = $request->file('fileupload');
        $filename = time() . '.' . $file->getClientOriginalExtension();
        $file->move(public_path('uploads/defects/'), $filename);
        // Store the file path in the defect model
        $defect->fileupload = 'uploads/defects/' . $filename;
    }

    // Save the defect record
    $defect->save();

    // Redirect to defects index page with success message
    return redirect()->route('defects.index')->with('success', 'Defect created successfully');
}


    // Display the specified defect
    public function show($id)
    {
        $defect = Defect::findOrFail($id); // Find the defect by ID
        return view('defects.show', compact('defect'));
    }

    // Show the form for editing the specified defect
    public function edit($id)
    {
        $defect = Defect::findOrFail($id);
        $user = User::where('id', $defect->assigned_to)->first();
        $defect->creator_id_name = $user->name;
        return response()->json($defect);
        // return view('defects.edit', compact('defect'));
    }

    // Update the specified defect in storage
    public function update(Request $request, $id)
    {
        $defect = Defect::findOrFail($id);

        // Validate the incoming data
        $validated = $request->validate([
            'defect_name' => 'required|string|max:255',
            'project_id' => 'required|integer',
            'defect_type' => 'required|string|max:255',
            'defect_description' => 'nullable|string',
            'assigned_team' => 'nullable|string',
            'estimated_hours' => 'nullable|integer',
            'fileupload' => 'nullable|file',
            'overdue' => 'nullable',
            'severity' => 'nullable|string|max:255',
            'status' => 'nullable|string|max:255',
            'reported_by' => 'nullable|string|max:255',
            'assigned_to' => 'nullable|string|max:255',
            'created_user_id' => 'nullable',
            'start_date' => 'nullable|date',
            'end_date' => 'nullable|date',
        ]);

        // Update the defect record
        $defect->update($validated);

        return redirect()->route('defects.index')->with('success', 'Defect updated successfully');
    }

    // Remove the specified defect from storage
    public function destroy($id)
    {
        $defect = Defect::findOrFail($id);
        $defect->delete();

        return redirect()->route('defects.index')->with('success', 'Defect deleted successfully');
    }
}
